/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.tuition;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.exemptions.StatuteExemptionByIntervalMapEntry;
import org.fenixedu.academictreasury.dto.tuition.TuitionDebitEntryBean;
import org.fenixedu.academictreasury.services.tuition.RegistrationTuitionService;
import org.fenixedu.academictreasury.services.tuition.TreasuryExemptionMoneyBox;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption_Base;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.fenixframework.core.AbstractDomainObject;

class TreasuryExemptionsTeller {
    static Comparator<TreasuryExemptionType> TREASURY_EVENT_COMPARATOR = Comparator.comparing(AbstractDomainObject::getExternalId);
    RegistrationTuitionService _registrationTuitionService;
    TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> _discountExemptionsMapForAllInstallments;
    Map<TuitionInstallmentTariff, TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox>> _discountExemptionsMapForOnlyThisInstallment = new HashMap<TuitionInstallmentTariff, TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox>>();
    Map<TuitionInstallmentTariff, TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox>> _alreadyCreatedExemptionsMapForOnlyThisInstallment = new HashMap<TuitionInstallmentTariff, TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox>>();
    TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> _alreadyCreatedExemptionsMapForAllInstallments = new TreeMap(TREASURY_EVENT_COMPARATOR);

    TreasuryExemptionsTeller(RegistrationTuitionService registrationTuitionService) {
        this._registrationTuitionService = registrationTuitionService;
        this.initializeDiscountExemptionsMapForAllInstallments();
    }

    private void initializeDiscountExemptionsMapForAllInstallments() {
        Registration registration = this._registrationTuitionService.registrationOptions.registration;
        ExecutionYear executionYear = this._registrationTuitionService.registrationOptions.executionYear;
        Person person = registration.getPerson();
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        DegreeCurricularPlan degreeCurricularPlan = studentCurricularPlan.getDegreeCurricularPlan();
        Collector<TreasuryEvent, ?, TreeMap> collector = Collectors.toMap(TreasuryEvent::getTreasuryExemptionToApplyInEventDiscountInTuitionFee, ev -> new TreasuryExemptionMoneyBox(ev.getNetAmountToPay(), ev.getNetAmountToPay()), TreasuryExemptionMoneyBox::mergeBySumming, () -> new TreeMap(TREASURY_EVENT_COMPARATOR));
        TreeMap result = TreasuryExemptionsTeller.getOtherEventsToDiscountInTuitionFee(person, executionYear, degreeCurricularPlan).stream().collect(collector);
        if (!this._registrationTuitionService.isForCalculationsOfOriginalAmounts) {
            this.removeAlreadyCreatedExemptedAmountsFromTheDiscountMapForAllInstallments(result);
        }
        this._discountExemptionsMapForAllInstallments = result;
    }

    private TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> removeAlreadyCreatedExemptedAmountsFromTheDiscountMapForAllInstallments(TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> discountMapForAllInstallments) {
        Registration registration = this._registrationTuitionService.registrationOptions.registration;
        ExecutionYear executionYear = this._registrationTuitionService.registrationOptions.executionYear;
        AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).ifPresent(tuitionEvent -> this._registrationTuitionService.tuitionOptions.tuitionPaymentPlan.getOrderedTuitionInstallmentTariffs().forEach(tariff -> {
            Product product = tariff.getProduct();
            Map exemptedAmountsByTypeMap = tuitionEvent.getNetExemptedAmountsMap(product);
            for (Map.Entry entry : exemptedAmountsByTypeMap.entrySet()) {
                TreasuryExemptionType treasuryExemptionType = (TreasuryExemptionType)entry.getKey();
                if (!discountMapForAllInstallments.containsKey(treasuryExemptionType)) continue;
                BigDecimal netExemptedAmount = (BigDecimal)entry.getValue();
                BigDecimal totalDebitCreatedIncludingExemptions = DebitEntry.findActive((TreasuryEvent)tuitionEvent, (Product)product).map(d -> d.getNetAmount().add(d.getNetExemptedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal maximumAmountToExemptFromDiscountExemptionsMapForOnlyThisInstallment = this.buildDiscountExemptionsMapForOnlyThisInstallmentByAmount((BigDecimal)totalDebitCreatedIncludingExemptions).computeIfAbsent((TreasuryExemptionType)treasuryExemptionType, (Function<TreasuryExemptionType, TreasuryExemptionMoneyBox>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$removeAlreadyCreatedExemptedAmountsFromTheDiscountMapForAllInstallments$3(org.fenixedu.treasury.domain.exemption.TreasuryExemptionType ), (Lorg/fenixedu/treasury/domain/exemption/TreasuryExemptionType;)Lorg/fenixedu/academictreasury/services/tuition/TreasuryExemptionMoneyBox;)()).maximumNetAmountForExemption.min(netExemptedAmount);
                this._alreadyCreatedExemptionsMapForOnlyThisInstallment.putIfAbsent((TuitionInstallmentTariff)((Object)((Object)tariff)), new TreeMap(TREASURY_EVENT_COMPARATOR));
                this._alreadyCreatedExemptionsMapForOnlyThisInstallment.get(tariff).merge(treasuryExemptionType, new TreasuryExemptionMoneyBox(maximumAmountToExemptFromDiscountExemptionsMapForOnlyThisInstallment, maximumAmountToExemptFromDiscountExemptionsMapForOnlyThisInstallment), (currentVal, newVal) -> currentVal.mergeBySumming((TreasuryExemptionMoneyBox)newVal));
                BigDecimal remainingAmountToRemoveFromDiscountMapForAllInstallments = netExemptedAmount.subtract(maximumAmountToExemptFromDiscountExemptionsMapForOnlyThisInstallment);
                this._alreadyCreatedExemptionsMapForAllInstallments.merge(treasuryExemptionType, new TreasuryExemptionMoneyBox(remainingAmountToRemoveFromDiscountMapForAllInstallments, remainingAmountToRemoveFromDiscountMapForAllInstallments), (currentVal, newVal) -> currentVal.mergeBySumming((TreasuryExemptionMoneyBox)newVal));
                ((TreasuryExemptionMoneyBox)discountMapForAllInstallments.get(treasuryExemptionType)).subtractFromCurrentNetAmount(remainingAmountToRemoveFromDiscountMapForAllInstallments);
            }
        }));
        return discountMapForAllInstallments;
    }

    private static List<TreasuryEvent> getOtherEventsToDiscountInTuitionFee(Person person, ExecutionYear executionYear, DegreeCurricularPlan degreeCurricularPlan) {
        return AcademicTreasuryEvent.getAllAcademicTreasuryEventsOfPerson(person).stream().map(TreasuryEvent.class::cast).filter(t -> t.isEventDiscountInTuitionFee()).filter(t -> executionYear.getQualifiedName().equals(t.getExecutionYearName())).filter(t -> degreeCurricularPlan.getDegree().getCode().equals(t.getDegreeCode())).collect(Collectors.toList());
    }

    void createDiscountExemptionsMapForOnlyThisInstallment(TuitionInstallmentTariff tuitionInstallmentTariff) {
        this._discountExemptionsMapForOnlyThisInstallment.put(tuitionInstallmentTariff, this.buildDiscountExemptionsMapForOnlyThisInstallment(tuitionInstallmentTariff));
    }

    private TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> buildDiscountExemptionsMapForOnlyThisInstallment(TuitionInstallmentTariff tuitionInstallmentTariff) {
        BigDecimal tuitionInstallmentAmountToPay = tuitionInstallmentTariff.amountToPay(this._registrationTuitionService);
        TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> result = this.buildDiscountExemptionsMapForOnlyThisInstallmentByAmount(tuitionInstallmentAmountToPay);
        return result;
    }

    private TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> buildDiscountExemptionsMapForOnlyThisInstallmentByAmount(BigDecimal tuitionInstallmentAmountToPay) {
        Registration registration = this._registrationTuitionService.getRegistration();
        ExecutionYear executionYear = this._registrationTuitionService.getExecutionYear();
        FinantialEntity finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(registration.getDegree(), executionYear.getBeginLocalDate());
        Set<StatuteType> statutesOfStudent = AcademicTreasuryConstants.statutesTypesValidOnAnyExecutionSemesterFor(registration, (ExecutionInterval)executionYear);
        TreeMap exemptionMapByStatutes = StatuteExemptionByIntervalMapEntry.find(finantialEntity, (ExecutionInterval)executionYear).filter(s -> statutesOfStudent.contains(s.getStatuteType())).collect(Collectors.toMap(s -> s.getTreasuryExemptionType(), s -> {
            BigDecimal val = s.getTreasuryExemptionType().calculateDefaultNetAmountToExempt(tuitionInstallmentAmountToPay);
            return new TreasuryExemptionMoneyBox(val, val);
        }, TreasuryExemptionMoneyBox::mergeByChoosingTheGreaterMaximumAmount, () -> new TreeMap(TREASURY_EVENT_COMPARATOR)));
        if (this._registrationTuitionService.tuitionOptions.tuitionAllocation != null) {
            this._registrationTuitionService.tuitionOptions.tuitionAllocation.getTreasuryExemptionTypesSet().stream().forEach(s -> {
                BigDecimal val = s.calculateDefaultNetAmountToExempt(tuitionInstallmentAmountToPay);
                TreasuryExemptionMoneyBox box = new TreasuryExemptionMoneyBox(val, val);
                exemptionMapByStatutes.merge(s, box, TreasuryExemptionMoneyBox::mergeByChoosingTheGreaterMaximumAmount);
            });
        }
        return exemptionMapByStatutes;
    }

    Map<TreasuryExemptionType, BigDecimal> retrieveUnchargedExemptionsToApplyMapForTariff(TuitionInstallmentTariff tariff, BigDecimal tuitionInstallmentAmountToPay) {
        HashMap<TreasuryExemptionType, BigDecimal> resultMap = new HashMap<TreasuryExemptionType, BigDecimal>();
        BigDecimal netAmountToExemptForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForOnlyThisInstallment.get((Object)tariff), tuitionInstallmentAmountToPay, resultMap);
        this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForAllInstallments, tuitionInstallmentAmountToPay.subtract(netAmountToExemptForOnlyThisInstallment), resultMap);
        return resultMap;
    }

    public Map<TreasuryExemptionType, BigDecimal> retrieveAdditionalExemptionsToApplyMapForTariff(TuitionInstallmentTariff tariff, Product product, TuitionDebitEntryBean originalBean, BigDecimal differenceInNetExemptedAmount) {
        HashMap<TreasuryExemptionType, BigDecimal> resultMap = new HashMap<TreasuryExemptionType, BigDecimal>();
        BigDecimal simulationOfTotalExemptedAmountForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(this.buildDiscountExemptionsMapForOnlyThisInstallment(tariff), originalBean.getExemptedAmount(), new HashMap<TreasuryExemptionType, BigDecimal>());
        BigDecimal simulationOfAlreadyExemptedAmountForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(this.buildDiscountExemptionsMapForOnlyThisInstallmentByAmount(this.getNetAmountAlreadyDebited(product).add(this.getNetAmountAlreadyExempted(product))), this.getNetAmountAlreadyExempted(product), new HashMap<TreasuryExemptionType, BigDecimal>());
        BigDecimal netExemptedAmountToTakeFromExemptionsMapForAllInstallments = differenceInNetExemptedAmount;
        if (TreasuryConstants.isGreaterOrEqualThan((BigDecimal)simulationOfTotalExemptedAmountForOnlyThisInstallment, (BigDecimal)simulationOfAlreadyExemptedAmountForOnlyThisInstallment)) {
            this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForOnlyThisInstallment.get((Object)tariff), simulationOfAlreadyExemptedAmountForOnlyThisInstallment, new HashMap<TreasuryExemptionType, BigDecimal>());
            BigDecimal totalExemptedAmountFromExemptionsMapForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForOnlyThisInstallment.get((Object)tariff), simulationOfTotalExemptedAmountForOnlyThisInstallment.subtract(simulationOfAlreadyExemptedAmountForOnlyThisInstallment), resultMap);
            netExemptedAmountToTakeFromExemptionsMapForAllInstallments = netExemptedAmountToTakeFromExemptionsMapForAllInstallments.subtract(totalExemptedAmountFromExemptionsMapForOnlyThisInstallment);
        }
        this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForAllInstallments, netExemptedAmountToTakeFromExemptionsMapForAllInstallments, resultMap);
        return resultMap;
    }

    private BigDecimal getNetAmountAlreadyExempted(Product product) {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(this._registrationTuitionService.registrationOptions.registration, this._registrationTuitionService.registrationOptions.executionYear).map(e -> e.getNetExemptedAmount(product)).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getNetAmountAlreadyDebited(Product product) {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(this._registrationTuitionService.registrationOptions.registration, this._registrationTuitionService.registrationOptions.executionYear).map(e -> e.getNetAmountToPay(product)).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getAndDecrementFromDiscountMap(TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> _discountExemptionsMap, BigDecimal maximumAmountToDiscount, Map<TreasuryExemptionType, BigDecimal> treasuryExemptionsToApplyMap) {
        BigDecimal result = BigDecimal.ZERO;
        for (TreasuryExemptionType treasuryExemptionType : _discountExemptionsMap.navigableKeySet()) {
            if (!_discountExemptionsMap.get(treasuryExemptionType).isAvailableNetAmountForExemptionPositive()) continue;
            BigDecimal availableAmountToDiscount = _discountExemptionsMap.get((Object)treasuryExemptionType).availableNetAmountForExemption;
            BigDecimal amountToDiscount = availableAmountToDiscount.min(maximumAmountToDiscount);
            result = result.add(amountToDiscount);
            maximumAmountToDiscount = maximumAmountToDiscount.subtract(amountToDiscount);
            _discountExemptionsMap.get(treasuryExemptionType).subtractFromCurrentNetAmount(amountToDiscount);
            treasuryExemptionsToApplyMap.merge(treasuryExemptionType, amountToDiscount, BigDecimal::add);
            if (TreasuryConstants.isPositive((BigDecimal)maximumAmountToDiscount)) continue;
            break;
        }
        return result;
    }

    public Map<TreasuryExemptionType, BigDecimal> getTreasuryExemptionDecrementsByTypeMap(TuitionInstallmentTariff tariff, AcademicTreasuryEvent academicTreasuryEvent, TuitionDebitEntryBean originalBean) {
        Map alreadyCreatedMap = academicTreasuryEvent.getNetExemptedAmountsMap(tariff.getProduct());
        Map<TreasuryExemptionType, BigDecimal> newExemptionsMap = originalBean.getExemptionsMap();
        HashMap<TreasuryExemptionType, BigDecimal> result = new HashMap<TreasuryExemptionType, BigDecimal>();
        for (TreasuryExemptionType t : alreadyCreatedMap.keySet()) {
            if (newExemptionsMap.containsKey(t) && TreasuryConstants.isLessThan((BigDecimal)newExemptionsMap.get(t), (BigDecimal)((BigDecimal)alreadyCreatedMap.get(t)))) {
                result.put(t, ((BigDecimal)alreadyCreatedMap.get(t)).subtract(newExemptionsMap.get(t)));
                continue;
            }
            if (newExemptionsMap.containsKey(t)) continue;
            result.put(t, (BigDecimal)alreadyCreatedMap.get(t));
        }
        return result;
    }

    void revertExemptionAmountsFromAcademicTreasuryToDiscountExemptionsMapForAllInstallments(TuitionInstallmentTariff tariff) {
        Registration registration = this._registrationTuitionService.registrationOptions.registration;
        ExecutionYear executionYear = this._registrationTuitionService.registrationOptions.executionYear;
        AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).ifPresent(tuitionEvent -> {
            Product product = tariff.getProduct();
            Map<TreasuryExemptionType, BigDecimal> exemptedAmountsByTypeMap = DebitEntry.findActive((TreasuryEvent)tuitionEvent, (Product)product).flatMap(d -> d.getTreasuryExemptionsSet().stream()).collect(Collectors.toMap(TreasuryExemption_Base::getTreasuryExemptionType, TreasuryExemption::getNetAmountToExempt, BigDecimal::add));
            for (Map.Entry<TreasuryExemptionType, BigDecimal> entry : exemptedAmountsByTypeMap.entrySet()) {
                TreasuryExemptionType treasuryExemptionType = entry.getKey();
                if (!this._discountExemptionsMapForAllInstallments.containsKey(treasuryExemptionType)) continue;
                BigDecimal netExemptedAmount = entry.getValue();
                BigDecimal totalDebitCreatedIncludingExemptions = DebitEntry.findActive((TreasuryEvent)tuitionEvent, (Product)product).map(d -> d.getNetAmount().add(d.getNetExemptedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal maximumAmountToExemptFromDiscountExemptionsMapForOnlyThisInstallment = this.buildDiscountExemptionsMapForOnlyThisInstallmentByAmount((BigDecimal)totalDebitCreatedIncludingExemptions).computeIfAbsent((TreasuryExemptionType)treasuryExemptionType, (Function<TreasuryExemptionType, TreasuryExemptionMoneyBox>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$revertExemptionAmountsFromAcademicTreasuryToDiscountExemptionsMapForAllInstallments$20(org.fenixedu.treasury.domain.exemption.TreasuryExemptionType ), (Lorg/fenixedu/treasury/domain/exemption/TreasuryExemptionType;)Lorg/fenixedu/academictreasury/services/tuition/TreasuryExemptionMoneyBox;)()).maximumNetAmountForExemption.min(netExemptedAmount);
                BigDecimal remainingAmountToRemoveFromDiscountMapForAllInstallments = netExemptedAmount.subtract(maximumAmountToExemptFromDiscountExemptionsMapForOnlyThisInstallment);
                this._discountExemptionsMapForAllInstallments.get(treasuryExemptionType).addToAvailableNetAmountForExemption(remainingAmountToRemoveFromDiscountMapForAllInstallments);
            }
        });
    }

    boolean isThereIsOnlyRemovalsOrDecrementsInExemptions(TuitionInstallmentTariff tariff, AcademicTreasuryEvent academicTreasuryEvent, TuitionDebitEntryBean originalBean) {
        Map alreadyCreatedMap = academicTreasuryEvent.getNetExemptedAmountsMap(tariff.getProduct());
        Map<TreasuryExemptionType, BigDecimal> newExemptionsMap = originalBean.getExemptionsMap();
        Set allTypes = Stream.concat(alreadyCreatedMap.keySet().stream(), newExemptionsMap.keySet().stream()).collect(Collectors.toSet());
        Predicate<TreasuryExemptionType> typeMatchInValue = t -> newExemptionsMap.containsKey(t) && alreadyCreatedMap.containsKey(t) && TreasuryConstants.isEqual((BigDecimal)((BigDecimal)newExemptionsMap.get(t)), (BigDecimal)((BigDecimal)alreadyCreatedMap.get(t)));
        Set differingTypesSet = allTypes.stream().filter(typeMatchInValue.negate()).collect(Collectors.toSet());
        return !differingTypesSet.isEmpty() && differingTypesSet.stream().allMatch(t -> alreadyCreatedMap.containsKey(t) && (!newExemptionsMap.containsKey(t) || TreasuryConstants.isLessThan((BigDecimal)((BigDecimal)newExemptionsMap.get(t)), (BigDecimal)((BigDecimal)alreadyCreatedMap.get(t)))));
    }

    boolean isThereAreRemovalOrDecrementsInExemptions(TuitionInstallmentTariff tariff, AcademicTreasuryEvent academicTreasuryEvent, TuitionDebitEntryBean newTuitionDebitEntryBean) {
        Map alreadyCreatedMap = academicTreasuryEvent.getNetExemptedAmountsMap(tariff.getProduct());
        Map<TreasuryExemptionType, BigDecimal> newTuitionDebitEntryBeanExemptionsMap = newTuitionDebitEntryBean.getExemptionsMap();
        Predicate<Map.Entry> predicate = alreadyExemptedEntry -> !newTuitionDebitEntryBeanExemptionsMap.containsKey(alreadyExemptedEntry.getKey()) || TreasuryConstants.isLessThan((BigDecimal)((BigDecimal)newTuitionDebitEntryBeanExemptionsMap.get(alreadyExemptedEntry.getKey())), (BigDecimal)((BigDecimal)alreadyExemptedEntry.getValue()));
        return alreadyCreatedMap.entrySet().stream().anyMatch(predicate);
    }

    boolean isThereAreOnlyNewEntriesOrIncrementsInExemptions(TuitionInstallmentTariff tariff, AcademicTreasuryEvent academicTreasuryEvent, TuitionDebitEntryBean originalBean) {
        Map alreadyCreatedMap = academicTreasuryEvent.getNetExemptedAmountsMap(tariff.getProduct());
        Map<TreasuryExemptionType, BigDecimal> newExemptionsMap = originalBean.getExemptionsMap();
        Set allTypes = Stream.concat(alreadyCreatedMap.keySet().stream(), newExemptionsMap.keySet().stream()).collect(Collectors.toSet());
        Predicate<TreasuryExemptionType> typeMatchInValue = t -> newExemptionsMap.containsKey(t) && alreadyCreatedMap.containsKey(t) && TreasuryConstants.isEqual((BigDecimal)((BigDecimal)newExemptionsMap.get(t)), (BigDecimal)((BigDecimal)alreadyCreatedMap.get(t)));
        Set differingTypesSet = allTypes.stream().filter(typeMatchInValue.negate()).collect(Collectors.toSet());
        return !differingTypesSet.isEmpty() && differingTypesSet.stream().allMatch(t -> newExemptionsMap.containsKey(t) && (!alreadyCreatedMap.containsKey(t) || TreasuryConstants.isGreaterThan((BigDecimal)((BigDecimal)newExemptionsMap.get(t)), (BigDecimal)((BigDecimal)alreadyCreatedMap.get(t)))));
    }

    boolean isExemptionsMapAreEqual(TuitionInstallmentTariff tariff, AcademicTreasuryEvent academicTreasuryEvent, TuitionDebitEntryBean newTuitionDebitEntryBean) {
        Map alreadyCreatedMap = academicTreasuryEvent.getNetExemptedAmountsMap(tariff.getProduct());
        Map<TreasuryExemptionType, BigDecimal> originalExemptionsMap = newTuitionDebitEntryBean.getExemptionsMap();
        if (!alreadyCreatedMap.keySet().equals(originalExemptionsMap.keySet())) {
            return false;
        }
        Predicate<Map.Entry> predicate = e -> TreasuryConstants.isEqual((BigDecimal)((BigDecimal)e.getValue()), (BigDecimal)((BigDecimal)originalExemptionsMap.get(e.getKey())));
        return alreadyCreatedMap.entrySet().stream().allMatch(predicate);
    }

    public void fillBackExemptionAmountForAllInstallments(TuitionInstallmentTariff tariff, TreasuryExemptionType treasuryExemptionType, BigDecimal exemptionAmount) {
        Supplier<BigDecimal> exemptionAmountMinusOnlyForInstallmentCalc = () -> {
            if (!this._alreadyCreatedExemptionsMapForOnlyThisInstallment.containsKey((Object)tariff)) {
                return BigDecimal.ZERO;
            }
            if (!this._alreadyCreatedExemptionsMapForOnlyThisInstallment.get((Object)tariff).containsKey(treasuryExemptionType)) {
                return BigDecimal.ZERO;
            }
            BigDecimal exemptionRatio = TreasuryConstants.divide((BigDecimal)treasuryExemptionType.getDefaultExemptionPercentage(), (BigDecimal)TreasuryConstants.HUNDRED_PERCENT);
            BigDecimal result = exemptionAmount.multiply(exemptionRatio);
            return Currency.getValueWithScale((BigDecimal)this._alreadyCreatedExemptionsMapForOnlyThisInstallment.get((Object)((Object)((Object)tariff))).get((Object)treasuryExemptionType).availableNetAmountForExemption.min(result));
        };
        BigDecimal exemptionAmountMinusOnlyForInstallment = exemptionAmount.subtract(exemptionAmountMinusOnlyForInstallmentCalc.get());
        if (!this._alreadyCreatedExemptionsMapForAllInstallments.containsKey(treasuryExemptionType)) {
            return;
        }
        BigDecimal amountToAdd = this._alreadyCreatedExemptionsMapForAllInstallments.get((Object)treasuryExemptionType).availableNetAmountForExemption.min(exemptionAmountMinusOnlyForInstallment);
        this._discountExemptionsMapForAllInstallments.get(treasuryExemptionType).addToAvailableNetAmountForExemption(amountToAdd);
        this._alreadyCreatedExemptionsMapForAllInstallments.get(treasuryExemptionType).subtractFromCurrentNetAmount(amountToAdd);
    }

    private static /* synthetic */ TreasuryExemptionMoneyBox lambda$revertExemptionAmountsFromAcademicTreasuryToDiscountExemptionsMapForAllInstallments$20(TreasuryExemptionType t) {
        return TreasuryExemptionMoneyBox.zero();
    }

    private static /* synthetic */ TreasuryExemptionMoneyBox lambda$removeAlreadyCreatedExemptedAmountsFromTheDiscountMapForAllInstallments$3(TreasuryExemptionType t) {
        return TreasuryExemptionMoneyBox.zero();
    }
}

