/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.conditionRule;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionAnnotation;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.WithLaboratorialClassesConditionRule_Base;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;

@TuitionConditionAnnotation(value="resources.AcademicTreasuryResources")
public class WithLaboratorialClassesConditionRule
extends WithLaboratorialClassesConditionRule_Base {
    public static final String BUNDLE_NAME = "resources.AcademicTreasuryResources";

    public boolean containsRule(TuitionConditionRule tuitionConditionRule) {
        if (!(tuitionConditionRule instanceof WithLaboratorialClassesConditionRule)) {
            return false;
        }
        WithLaboratorialClassesConditionRule rule = (WithLaboratorialClassesConditionRule)((Object)tuitionConditionRule);
        return this.getWithLaboratorialClasses().equals(rule.getWithLaboratorialClasses());
    }

    public boolean isValidTo(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        if (enrolment == null) {
            return false;
        }
        ExecutionInterval executionSemester = enrolment.getExecutionInterval();
        boolean hasLaboratorialClasses = AcademicTreasuryConstants.isPositive(new BigDecimal(enrolment.getCurricularCourse().getCompetenceCourse().getLaboratorialHours(executionSemester)));
        return Boolean.TRUE.equals(this.getWithLaboratorialClasses()) ? hasLaboratorialClasses : !hasLaboratorialClasses;
    }

    public boolean checkRules() {
        if (this.getWithLaboratorialClasses() == null) {
            throw new DomainException(this.i18n("org.fenixedu.academictreasury.domain.tuition.conditionRule.withLaboratorialClassesConditionRule.withLaboratorialClasses.cannotBeNull", new String[0]), new String[0]);
        }
        return true;
    }

    public String getDescription() {
        return Boolean.TRUE.equals(this.getWithLaboratorialClasses()) ? this.i18n("label.true", new String[0]) : this.i18n("label.false", new String[0]);
    }

    protected String getBundle() {
        return BUNDLE_NAME;
    }

    public void delete() {
        this.setTuitionPaymentPlan(null);
        this.setTuitionPaymentPlanCalculator(null);
        this.setDomainRoot(null);
        this.deleteDomainObject();
    }

    public TuitionConditionRule duplicate() {
        WithLaboratorialClassesConditionRule result = new WithLaboratorialClassesConditionRule();
        result.setWithLaboratorialClasses(this.getWithLaboratorialClasses());
        return result;
    }

    public void fillRuleFromImporter(TuitionPaymentPlanBean bean) {
        String value = bean.getImporterRules().get(((Object)((Object)this)).getClass());
        if (value.equals(this.i18n("label.true", new String[0]))) {
            this.setWithLaboratorialClasses(Boolean.TRUE);
            return;
        }
        if (value.equals(this.i18n("label.false", new String[0]))) {
            this.setWithLaboratorialClasses(Boolean.FALSE);
            return;
        }
        throw new AcademicTreasuryDomainException("error.WithLaboratorialClassesConditionRule.value.invalid", value);
    }
}

