/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.conditionRule;

import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionAnnotation;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.RegistrationYearConditionRule_Base;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;

@TuitionConditionAnnotation(value="resources.AcademicTreasuryResources")
public class RegistrationYearConditionRule
extends RegistrationYearConditionRule_Base {
    public static final String BUNDLE_NAME = "resources.AcademicTreasuryResources";

    public boolean containsRule(TuitionConditionRule tuitionConditionRule) {
        if (!(tuitionConditionRule instanceof RegistrationYearConditionRule)) {
            return false;
        }
        RegistrationYearConditionRule rule = (RegistrationYearConditionRule)((Object)tuitionConditionRule);
        return this.getExecutionIntervalsSet().containsAll(rule.getExecutionIntervalsSet());
    }

    public boolean isValidTo(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        return this.getExecutionIntervalsSet().contains(registration.getRegistrationYear());
    }

    public boolean checkRules() {
        if (this.getExecutionIntervalsSet() == null || this.getExecutionIntervalsSet().isEmpty()) {
            throw new IllegalStateException("org.fenixedu.academictreasury.domain.tuition.conditionRule.RegistrationYearConditionRule.executionIntervalsSet.cannotBeEmpty");
        }
        return true;
    }

    public String getDescription() {
        return this.getExecutionIntervalsSet().stream().sorted(ExecutionInterval.COMPARATOR_BY_BEGIN_DATE).map(ExecutionInterval::getQualifiedName).collect(Collectors.joining(", "));
    }

    protected String getBundle() {
        return BUNDLE_NAME;
    }

    public void delete() {
        this.getExecutionIntervalsSet().clear();
        this.setTuitionPaymentPlan(null);
        this.setDomainRoot(null);
        this.deleteDomainObject();
    }

    public TuitionConditionRule duplicate() {
        RegistrationYearConditionRule result = new RegistrationYearConditionRule();
        this.getExecutionIntervalsSet().addAll(this.getExecutionIntervalsSet());
        return result;
    }

    public void fillRuleFromImporter(TuitionPaymentPlanBean bean) {
        String[] split;
        String string = bean.getImporterRules().get(((Object)((Object)this)).getClass());
        for (String s : split = string.split("\\|")) {
            ExecutionYear executionYear = ExecutionYear.readExecutionYearByName((String)s);
            if (executionYear == null) {
                throw new AcademicTreasuryDomainException("error.RegistrationYearConditionRule.executionInterval.invalid", s);
            }
            this.addExecutionIntervals((ExecutionInterval)executionYear);
        }
    }
}

