/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.event;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.treasury.AcademicTreasuryEventPayment;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEventPayment;
import org.fenixedu.academic.domain.treasury.IPaymentReferenceCode;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.joda.time.LocalDate;

public class TreasuryEventDefaultMethods {
    public static void annulDebts(TreasuryEvent event, String reason) {
        event.annulAllDebitEntries(reason);
    }

    public static String formatMoney(TreasuryEvent event, BigDecimal moneyValue) {
        if (DebitEntry.findActive((TreasuryEvent)event).findFirst().isPresent()) {
            return ((DebitEntry)DebitEntry.findActive((TreasuryEvent)event).findFirst().get()).getDebtAccount().getFinantialInstitution().getCurrency().getValueFor(moneyValue);
        }
        return ((FinantialInstitution)FinantialInstitution.findAll().iterator().next()).getCurrency().getValueFor(moneyValue);
    }

    public static String getDebtAccountURL(TreasuryEvent treasuryEvent) {
        return AcademicTreasurySettings.getInstance().getAcademicTreasuryAccountUrl().getDebtAccountURL(treasuryEvent);
    }

    public static String getExemptionReason(TreasuryEvent treasuryEvent) {
        return String.join((CharSequence)", ", TreasuryExemption.find((TreasuryEvent)treasuryEvent).map(l -> l.getReason()).collect(Collectors.toSet()));
    }

    public static String getExemptionTypeName(TreasuryEvent treasuryEvent, Locale locale) {
        return String.join((CharSequence)", ", TreasuryExemption.find((TreasuryEvent)treasuryEvent).map(l -> l.getTreasuryExemptionType().getName().getContent(locale)).collect(Collectors.toSet()));
    }

    public static List<IPaymentReferenceCode> getPaymentReferenceCodesList(TreasuryEvent treasuryEvent) {
        return DebitEntry.findActive((TreasuryEvent)treasuryEvent).flatMap(d -> d.getSibsPaymentRequests().stream()).map(r -> new PaymentReferenceCodeImpl((SibsPaymentRequest)r)).collect(Collectors.toList());
    }

    public static List<IAcademicTreasuryEventPayment> getPaymentsList(TreasuryEvent event) {
        return DebitEntry.findActive((TreasuryEvent)event).map(l -> l.getSettlementEntriesSet()).reduce((a, b) -> Sets.union((Set)a, (Set)b)).orElse(Sets.newHashSet()).stream().filter(l -> l.getFinantialDocument().isClosed()).map(l -> new AcademicTreasuryEventPayment((SettlementEntry)l)).collect(Collectors.toList());
    }

    public static boolean isBlockingAcademicalActs(TreasuryEvent treasuryEvent, LocalDate when) {
        return DebitEntry.find((TreasuryEvent)treasuryEvent).filter(l -> PersonCustomer.isDebitEntryBlockingAcademicalActs(l, when)).count() > 0L;
    }

    public static boolean isCharged(TreasuryEvent event) {
        return DebitEntry.findActive((TreasuryEvent)event).count() > 0L;
    }

    public static boolean isDueDateExpired(TreasuryEvent treasuryEvent, LocalDate when) {
        return DebitEntry.findActive((TreasuryEvent)treasuryEvent).map(l -> l.isDueDateExpired(when)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public static boolean isExempted(TreasuryEvent treasuryEvent) {
        return !treasuryEvent.getTreasuryExemptionsSet().isEmpty();
    }

    public static boolean isOnlinePaymentsActive(TreasuryEvent treasuryEvent) {
        if (!((IAcademicTreasuryEvent)treasuryEvent).isCharged()) {
            return false;
        }
        FinantialInstitution finantialInstitution = ((DebitEntry)DebitEntry.findActive((TreasuryEvent)treasuryEvent).iterator().next()).getDebtAccount().getFinantialInstitution();
        return DigitalPaymentPlatform.find((FinantialInstitution)finantialInstitution, (PaymentMethod)TreasurySettings.getInstance().getCreditCardPaymentMethod(), (boolean)true).findFirst().isPresent();
    }

    private static class PaymentReferenceCodeImpl
    implements IPaymentReferenceCode {
        private final SibsPaymentRequest paymentReferenceCode;

        private PaymentReferenceCodeImpl(SibsPaymentRequest referenceCode) {
            this.paymentReferenceCode = referenceCode;
        }

        public LocalDate getEndDate() {
            return this.paymentReferenceCode.getDueDate();
        }

        public String getEntityCode() {
            return this.paymentReferenceCode.getEntityReferenceCode();
        }

        public String getFormattedCode() {
            return this.paymentReferenceCode.getFormattedCode();
        }

        public String getReferenceCode() {
            return this.paymentReferenceCode.getReferenceCode();
        }

        public boolean isAnnuled() {
            return this.paymentReferenceCode.getState().isAnnuled();
        }

        public boolean isUsed() {
            return this.paymentReferenceCode.getState().isUsed();
        }

        public boolean isProcessed() {
            return this.paymentReferenceCode.getState().isProcessed();
        }

        public BigDecimal getPayableAmount() {
            return this.paymentReferenceCode.getPayableAmount();
        }
    }
}

