/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.tuition.recalculation.complete.tests;

import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentTest;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academictreasury.base.FenixFrameworkRunner;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.tuition.EctsCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.tuition.RegistrationTuitionService;
import org.fenixedu.academictreasury.tuition.TuitionPaymentPlanTestsUtilities;
import org.fenixedu.academictreasury.util.AcademicTreasuryBootstrapper;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry_Base;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;

@RunWith(value=FenixFrameworkRunner.class)
public class TestRegistrationTuitionRecalculationTestSeven {
    private static Registration registration;
    private static ExecutionInterval executionInterval;
    private static ExecutionYear executionYear;

    @BeforeClass
    public static void init() {
        try {
            FenixFramework.getTransactionManager().withTransaction(() -> {
                EnrolmentTest.initEnrolments();
                TuitionPaymentPlanTestsUtilities.startUp();
                AcademicTreasuryBootstrapper.bootstrap();
                TestRegistrationTuitionRecalculationTestSeven.createTuitionPaymentPlanWithAmountByEcts();
                return null;
            }, (Atomic)new AtomicInstance(Atomic.TxMode.WRITE, true));
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static TuitionPaymentPlan createTuitionPaymentPlanWithAmountByEcts() {
        registration = (Registration)Student.readStudentByNumber((Integer)1).getRegistrationStream().findAny().orElseThrow();
        StudentCurricularPlan scp = registration.getLastStudentCurricularPlan();
        executionInterval = ExecutionInterval.findFirstCurrentChild((AcademicCalendarRootEntry)scp.getDegree().getCalendar());
        executionYear = executionInterval.getExecutionYear();
        TuitionPaymentPlanBean bean = new TuitionPaymentPlanBean(((TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get()).getCurrentProduct(), (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), TestRegistrationTuitionRecalculationTestSeven.readFinantialEntity(), executionYear);
        bean.setDefaultPaymentPlan(true);
        DegreeCurricularPlan degreeCurricularPlan = registration.getLastStudentCurricularPlan().getDegreeCurricularPlan();
        bean.addDegreeCurricularPlans(degreeCurricularPlan);
        bean.setDegreeType(degreeCurricularPlan.getDegreeType());
        AcademicTariffBean academicTariffBean = new AcademicTariffBean(1);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_1_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(new BigDecimal("10"));
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(7);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(2);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_2_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(new BigDecimal("10"));
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(30);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(3);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_3_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(new BigDecimal("10"));
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(60);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(4);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_4_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(new BigDecimal("10"));
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(90);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        return TuitionPaymentPlan.create((TuitionPaymentPlanBean)bean);
    }

    private static void ensureNecessaryAcademicDataIsAvailable() {
        registration.getRegistrationProtocol().setPayGratuity(Boolean.valueOf(true));
        if (Country.readByTwoLetterCode((String)"PT") == null) {
            new Country(TestRegistrationTuitionRecalculationTestSeven.ls("Portugal"), TestRegistrationTuitionRecalculationTestSeven.ls("Portugal"), "PT", "PRT").setDefaultCountry(Boolean.valueOf(true));
        }
        registration.getPerson().editSocialSecurityNumber("999999990", PersonCustomer.createSaftDefaultPhysicalAddress((Person)registration.getPerson()));
    }

    @Test
    public void doRecalculation() {
        TestRegistrationTuitionRecalculationTestSeven.createTuitionPaymentPlanWithAmountByEcts();
        TestRegistrationTuitionRecalculationTestSeven.ensureNecessaryAcademicDataIsAvailable();
        Product firstInstallmentProduct = (Product)Product.findUniqueByCode((String)"PROP_1_PREST_1_CIC").get();
        RegistrationTuitionService.startServiceInvocation((Registration)registration, (ExecutionYear)executionYear, (LocalDate)new LocalDate()).applyEnrolledEctsUnits(new BigDecimal("30")).applyEnrolledCoursesCount(new BigDecimal("5")).withInferedTuitionPaymentPlan().restrictForInstallmentProducts(Set.of(firstInstallmentProduct)).withoutInstallmentsRecalculation().executeTuitionPaymentPlanCreation();
        AcademicTreasuryEvent academicTreasuryEvent = (AcademicTreasuryEvent)AcademicTreasuryEvent.findUniqueForRegistrationTuition((Registration)registration, (ExecutionYear)executionYear).get();
        Assert.assertEquals((Object)new BigDecimal("300.00"), (Object)academicTreasuryEvent.getAmountWithVatToPay());
        Assert.assertEquals((long)1L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).count());
        DebitEntry firstInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).iterator().next();
        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.findUniqueDefaultSeries((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialEntity)firstInstallment.getFinantialEntity());
        DebitNote.createDebitNoteForDebitEntry((DebitEntry)firstInstallment, null, (DocumentNumberSeries)documentNumberSeries, (DateTime)new DateTime(), (LocalDate)new LocalDate(), null, null, null);
        firstInstallment.getDebitNote().closeDocument();
        RegistrationTuitionService.startServiceInvocation((Registration)registration, (ExecutionYear)executionYear, (LocalDate)new LocalDate()).applyEnrolledEctsUnits(new BigDecimal("30")).applyEnrolledCoursesCount(new BigDecimal("5")).withInferedTuitionPaymentPlan().withAllInstallments().forceInstallmentsEvenTreasuryEventIsCharged(true).recalculateInstallments(Map.of(firstInstallmentProduct, new LocalDate())).executeTuitionPaymentPlanCreation();
        Assert.assertEquals((Object)new BigDecimal("1200.00"), (Object)academicTreasuryEvent.getAmountWithVatToPay());
        Assert.assertEquals((long)4L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent).count());
        Assert.assertEquals((long)1L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).count());
        Assert.assertEquals((Object)firstInstallment, DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).iterator().next());
        Assert.assertEquals((Object)false, (Object)firstInstallment.isAnnulled());
        Assert.assertEquals((long)0L, (long)firstInstallment.getCreditEntriesSet().size());
        Assert.assertEquals((long)0L, (long)firstInstallment.getSettlementEntriesSet().size());
        Assert.assertEquals((Object)new BigDecimal("300.00"), (Object)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).map(InvoiceEntry_Base::getAmountWithVat).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    private static FinantialEntity readFinantialEntity() {
        return (FinantialEntity)FinantialEntity.findAll().iterator().next();
    }

    public static LocalizedString ls(String string) {
        return new LocalizedString(TreasuryConstants.DEFAULT_LANGUAGE, string);
    }
}

