/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.calculators;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.tuition.ITuitionRegistrationServiceParameters;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.calculators.TuitionCalculatorAggregator;
import org.fenixedu.academictreasury.domain.tuition.calculators.TuitionPaymentPlanCalculator_Base;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.FenixFramework;

public abstract class TuitionPaymentPlanCalculator
extends TuitionPaymentPlanCalculator_Base {
    public TuitionPaymentPlanCalculator() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public ExecutionYear getExecutionYear() {
        return this.getTuitionCalculatorParentAggregator() != null ? this.getTuitionCalculatorParentAggregator().getExecutionYear() : this.getTuitionPaymentPlan().getExecutionYear();
    }

    public TuitionPaymentPlan getAssociatedTuitionPaymentPlan() {
        return this.getTuitionCalculatorParentAggregator() != null ? this.getTuitionCalculatorParentAggregator().getAssociatedTuitionPaymentPlan() : this.getTuitionPaymentPlan();
    }

    public abstract boolean isValid();

    public abstract BigDecimal getTotalAmount(Registration var1);

    public BigDecimal getTotalAmount(Registration registration, ITuitionRegistrationServiceParameters parameters) {
        return this.getTotalAmount(registration);
    }

    public abstract BigDecimal getTotalAmount(Enrolment var1);

    public BigDecimal getTotalAmount(Enrolment enrolment, ITuitionRegistrationServiceParameters parameters) {
        return this.getTotalAmount(enrolment);
    }

    public abstract String getCalculationDescription(Registration var1);

    public abstract String getCalculationDescription(Enrolment var1);

    public abstract LocalizedString getParametersDescription();

    public abstract TuitionPaymentPlanCalculator copyTo(TuitionPaymentPlan var1);

    public abstract TuitionPaymentPlanCalculator copyTo(TuitionCalculatorAggregator var1);

    public abstract void fillWithParametersFromImportation(String var1);

    public void editName(LocalizedString name) {
        super.setName(name);
    }

    public void delete() {
        super.setDomainRoot(null);
        super.setTuitionPaymentPlan(null);
        super.setTuitionCalculatorParentAggregator(null);
        this.getTuitionConditionRulesSet().forEach(r -> r.delete());
        super.deleteDomainObject();
    }

    public LocalizedString getCalculatorImplementationName() {
        return TuitionPaymentPlanCalculator.getPresentationNameFor(((Object)((Object)this)).getClass());
    }

    public static LocalizedString getPresentationNameFor(Class<? extends TuitionPaymentPlanCalculator> tuitionPaymentPlanCalculatorClass) {
        try {
            Method method = tuitionPaymentPlanCalculatorClass.getMethod("getCalculatorPresentationName", new Class[0]);
            return (LocalizedString)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

