/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.tuition.recalculation.complete.tests;

import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentTest;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academictreasury.base.BasicAcademicTreasuryUtils;
import org.fenixedu.academictreasury.base.FenixFrameworkRunner;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.tuition.EctsCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionAllocation;
import org.fenixedu.academictreasury.domain.tuition.TuitionCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionDebtPostingType;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.tuition.RegistrationTuitionService;
import org.fenixedu.academictreasury.tuition.TuitionPaymentPlanTestsUtilities;
import org.fenixedu.academictreasury.util.AcademicTreasuryBootstrapper;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;

@RunWith(value=FenixFrameworkRunner.class)
public class TestRegistrationTuitionRecalculationTestThirtyOne {
    private static Registration registration;
    private static ExecutionInterval executionInterval;
    private static ExecutionYear executionYear;

    @BeforeClass
    public static void init() {
        try {
            FenixFramework.getTransactionManager().withTransaction(() -> {
                EnrolmentTest.initEnrolments();
                TuitionPaymentPlanTestsUtilities.startUp();
                AcademicTreasuryBootstrapper.bootstrap();
                BasicAcademicTreasuryUtils.createReservationTaxes();
                TestRegistrationTuitionRecalculationTestThirtyOne.createTuitionPaymentPlanWithAmountByEcts();
                TestRegistrationTuitionRecalculationTestThirtyOne.createTuitionAllocationData();
                return null;
            }, (Atomic)new AtomicInstance(Atomic.TxMode.WRITE, true));
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static void createTuitionPaymentPlanWithAmountByEcts() {
        registration = (Registration)Student.readStudentByNumber((Integer)1).getRegistrationStream().findAny().orElseThrow();
        StudentCurricularPlan scp = registration.getLastStudentCurricularPlan();
        executionInterval = ExecutionInterval.findFirstCurrentChild((AcademicCalendarRootEntry)scp.getDegree().getCalendar());
        executionYear = executionInterval.getExecutionYear();
        TestRegistrationTuitionRecalculationTestThirtyOne.createTuitionPaymentPlan("1T", new BigDecimal("10"));
        TestRegistrationTuitionRecalculationTestThirtyOne.createTuitionPaymentPlan("2T", new BigDecimal("10"));
    }

    private static void createTuitionAllocationData() {
        TuitionDebtPostingType firstMoment = TuitionDebtPostingType.create((FinantialEntity)((FinantialEntity)FinantialEntity.findAll().iterator().next()), (LocalizedString)new LocalizedString(new Locale("pt"), "1M"));
        TuitionDebtPostingType secondMoment = TuitionDebtPostingType.create((FinantialEntity)((FinantialEntity)FinantialEntity.findAll().iterator().next()), (LocalizedString)new LocalizedString(new Locale("pt"), "2M"));
        TuitionPaymentPlan tuitionPaymentPlan_1T = registration.getLastStudentCurricularPlan().getDegreeCurricularPlan().getTuitionPaymentPlanOrdersSet().stream().map(t -> t.getTuitionPaymentPlan()).filter(t -> "1T".equals(t.getCustomizedName().getContent())).findFirst().get();
        TuitionPaymentPlan tuitionPaymentPlan_2T = registration.getLastStudentCurricularPlan().getDegreeCurricularPlan().getTuitionPaymentPlanOrdersSet().stream().map(t -> t.getTuitionPaymentPlan()).filter(t -> "2T".equals(t.getCustomizedName().getContent())).findFirst().get();
        TreasuryExemptionType exemptionType = (TreasuryExemptionType)TreasuryExemptionType.findByCode((String)"TET1").findFirst().get();
        TuitionAllocation.create((TuitionPaymentPlanGroup)tuitionPaymentPlan_1T.getTuitionPaymentPlanGroup(), (Registration)registration, (ExecutionInterval)tuitionPaymentPlan_1T.getExecutionYear(), (TuitionDebtPostingType)firstMoment, (TuitionPaymentPlan)tuitionPaymentPlan_1T, Set.of(exemptionType));
        TuitionAllocation.create((TuitionPaymentPlanGroup)tuitionPaymentPlan_2T.getTuitionPaymentPlanGroup(), (Registration)registration, (ExecutionInterval)tuitionPaymentPlan_2T.getExecutionYear(), (TuitionDebtPostingType)secondMoment, (TuitionPaymentPlan)tuitionPaymentPlan_2T, Set.of(exemptionType));
    }

    private static TuitionPaymentPlan createTuitionPaymentPlan(String customizedPlanName, BigDecimal amountByEcts) {
        TuitionPaymentPlanBean bean = new TuitionPaymentPlanBean(((TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get()).getCurrentProduct(), (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), TestRegistrationTuitionRecalculationTestThirtyOne.readFinantialEntity(), executionYear);
        bean.setDefaultPaymentPlan(false);
        bean.setCustomized(true);
        bean.setName(customizedPlanName);
        DegreeCurricularPlan degreeCurricularPlan = registration.getLastStudentCurricularPlan().getDegreeCurricularPlan();
        bean.addDegreeCurricularPlans(degreeCurricularPlan);
        bean.setDegreeType(degreeCurricularPlan.getDegreeType());
        AcademicTariffBean academicTariffBean = new AcademicTariffBean(1);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_1_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(amountByEcts);
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(7);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(2);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_2_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(amountByEcts);
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(30);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(3);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_3_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(amountByEcts);
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(60);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(4);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_4_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(amountByEcts);
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(90);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        return TuitionPaymentPlan.create((TuitionPaymentPlanBean)bean);
    }

    private static void ensureNecessaryAcademicDataIsAvailable() {
        registration.getRegistrationProtocol().setPayGratuity(Boolean.valueOf(true));
        if (Country.readByTwoLetterCode((String)"PT") == null) {
            new Country(TestRegistrationTuitionRecalculationTestThirtyOne.ls("Portugal"), TestRegistrationTuitionRecalculationTestThirtyOne.ls("Portugal"), "PT", "PRT").setDefaultCountry(Boolean.valueOf(true));
        }
        registration.getPerson().editSocialSecurityNumber("999999990", PersonCustomer.createSaftDefaultPhysicalAddress((Person)registration.getPerson()));
    }

    @Test
    public void doRecalculation() {
        ((FinantialInstitution)FinantialInstitution.findAll().iterator().next()).setSupportCreditTreasuryExemptions(Boolean.valueOf(true));
        ((FinantialInstitution)FinantialInstitution.findAll().iterator().next()).setSplitDebitEntriesWithSettledAmount(Boolean.valueOf(true));
        ((FinantialInstitution)FinantialInstitution.findAll().iterator().next()).setSplitCreditEntriesWithSettledAmount(Boolean.valueOf(true));
        TestRegistrationTuitionRecalculationTestThirtyOne.createTuitionPaymentPlanWithAmountByEcts();
        TestRegistrationTuitionRecalculationTestThirtyOne.ensureNecessaryAcademicDataIsAvailable();
        TuitionDebtPostingType firstMoment = TuitionDebtPostingType.findAll().filter(t -> "1M".equals(t.getName().getContent())).findFirst().get();
        TuitionDebtPostingType secondMoment = TuitionDebtPostingType.findAll().filter(t -> "2M".equals(t.getName().getContent())).findFirst().get();
        TuitionAllocation firstAllocation = (TuitionAllocation)TuitionAllocation.findUnique((TuitionPaymentPlanGroup)((TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get()), (Registration)registration, (ExecutionInterval)executionYear, (TuitionDebtPostingType)firstMoment).get();
        TuitionAllocation secondAllocation = (TuitionAllocation)TuitionAllocation.findUnique((TuitionPaymentPlanGroup)((TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get()), (Registration)registration, (ExecutionInterval)executionYear, (TuitionDebtPostingType)secondMoment).get();
        Product firstInstallmentProduct = (Product)Product.findUniqueByCode((String)"PROP_1_PREST_1_CIC").get();
        RegistrationTuitionService.startServiceInvocation((Registration)registration, (ExecutionYear)executionYear, (LocalDate)new LocalDate()).applyEnrolledEctsUnits(new BigDecimal("30")).applyEnrolledCoursesCount(new BigDecimal("5")).withTuitionPaymentPlan(firstAllocation.getTuitionPaymentPlan()).applyTuitionAllocation(firstAllocation).restrictForInstallmentProducts(Set.of(firstInstallmentProduct)).withoutInstallmentsRecalculation().executeTuitionPaymentPlanCreation();
        AcademicTreasuryEvent academicTreasuryEvent = (AcademicTreasuryEvent)AcademicTreasuryEvent.findUniqueForRegistrationTuition((Registration)registration, (ExecutionYear)executionYear).get();
        Assert.assertEquals((Object)new BigDecimal("263.37"), (Object)academicTreasuryEvent.getAmountWithVatToPay());
        Assert.assertEquals((Object)new BigDecimal("36.63"), (Object)academicTreasuryEvent.getNetExemptedAmount());
        Assert.assertEquals((long)1L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).count());
        DebitEntry firstInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).iterator().next();
        Assert.assertEquals((Object)new BigDecimal("263.37"), (Object)firstInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("36.63"), (Object)firstInstallment.getNetExemptedAmount());
        RegistrationTuitionService.startServiceInvocation((Registration)registration, (ExecutionYear)executionYear, (LocalDate)new LocalDate()).applyEnrolledEctsUnits(new BigDecimal("31")).applyEnrolledCoursesCount(new BigDecimal("5")).withTuitionPaymentPlan(secondAllocation.getTuitionPaymentPlan()).applyTuitionAllocation(secondAllocation).withAllInstallments().forceInstallmentsEvenTreasuryEventIsCharged(true).recalculateInstallments(Map.of(firstInstallmentProduct, new LocalDate())).executeTuitionPaymentPlanCreation();
        Assert.assertEquals((long)2L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).count());
        Assert.assertEquals((Object)false, (Object)firstInstallment.isAnnulled());
        Assert.assertEquals((Object)false, (Object)firstInstallment.isEventAnnuled());
        Assert.assertEquals((Object)new BigDecimal("272.15"), (Object)academicTreasuryEvent.getAmountWithVatToPay(firstInstallmentProduct));
        Assert.assertEquals((Object)new BigDecimal("37.85"), (Object)academicTreasuryEvent.getNetExemptedAmount(firstInstallmentProduct));
        DebitEntry secondFirstInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).filter(d -> d != firstInstallment).iterator().next();
        Assert.assertEquals((Object)new BigDecimal("8.78"), (Object)secondFirstInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("1.22"), (Object)secondFirstInstallment.getNetExemptedAmount());
        Product secondInstallmentProduct = (Product)Product.findUniqueByCode((String)"PROP_2_PREST_1_CIC").get();
        Assert.assertEquals((long)1L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)secondInstallmentProduct).count());
        DebitEntry secondInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)secondInstallmentProduct).iterator().next();
        Assert.assertEquals((Object)new BigDecimal("272.15"), (Object)secondInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("37.85"), (Object)secondInstallment.getNetExemptedAmount());
        Assert.assertEquals((Object)new BigDecimal("1088.60"), (Object)academicTreasuryEvent.getAmountWithVatToPay());
        Assert.assertEquals((Object)new BigDecimal("151.40"), (Object)academicTreasuryEvent.getNetExemptedAmount());
        Assert.assertEquals((long)5L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent).count());
    }

    private static FinantialEntity readFinantialEntity() {
        return (FinantialEntity)FinantialEntity.findAll().iterator().next();
    }

    public static LocalizedString ls(String string) {
        return new LocalizedString(TreasuryConstants.DEFAULT_LANGUAGE, string);
    }
}

