/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.tuition.recalculation.complete.tests;

import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentTest;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academictreasury.base.BasicAcademicTreasuryUtils;
import org.fenixedu.academictreasury.base.FenixFrameworkRunner;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTax;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTaxEventTarget;
import org.fenixedu.academictreasury.domain.tuition.EctsCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionAllocation;
import org.fenixedu.academictreasury.domain.tuition.TuitionCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionDebtPostingType;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.tuition.RegistrationTuitionService;
import org.fenixedu.academictreasury.tuition.TuitionPaymentPlanTestsUtilities;
import org.fenixedu.academictreasury.util.AcademicTreasuryBootstrapper;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;

@RunWith(value=FenixFrameworkRunner.class)
public class TestRegistrationTuitionRecalculationTestFifty {
    private static Registration registration;
    private static ExecutionInterval executionInterval;
    private static ExecutionYear executionYear;

    @BeforeClass
    public static void init() {
        try {
            FenixFramework.getTransactionManager().withTransaction(() -> {
                EnrolmentTest.initEnrolments();
                TuitionPaymentPlanTestsUtilities.startUp();
                AcademicTreasuryBootstrapper.bootstrap();
                BasicAcademicTreasuryUtils.createReservationTaxes();
                TestRegistrationTuitionRecalculationTestFifty.createTuitionPaymentPlanWithAmountByEcts();
                BasicAcademicTreasuryUtils.createStatuteTypeExemptionsMap();
                TestRegistrationTuitionRecalculationTestFifty.createTuitionAllocationData();
                return null;
            }, (Atomic)new AtomicInstance(Atomic.TxMode.WRITE, true));
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static void createTuitionPaymentPlanWithAmountByEcts() {
        registration = (Registration)Student.readStudentByNumber((Integer)1).getRegistrationStream().findAny().orElseThrow();
        StudentCurricularPlan scp = registration.getLastStudentCurricularPlan();
        executionInterval = ExecutionInterval.findFirstCurrentChild((AcademicCalendarRootEntry)scp.getDegree().getCalendar());
        executionYear = executionInterval.getExecutionYear();
        TestRegistrationTuitionRecalculationTestFifty.createTuitionPaymentPlan("1T", new BigDecimal("10"));
        TestRegistrationTuitionRecalculationTestFifty.createTuitionPaymentPlan("2T", new BigDecimal("10"));
    }

    private static void createTuitionAllocationData() {
        TuitionDebtPostingType firstMoment = TuitionDebtPostingType.create((FinantialEntity)((FinantialEntity)FinantialEntity.findAll().iterator().next()), (LocalizedString)new LocalizedString(new Locale("pt"), "1M"));
        TuitionDebtPostingType secondMoment = TuitionDebtPostingType.create((FinantialEntity)((FinantialEntity)FinantialEntity.findAll().iterator().next()), (LocalizedString)new LocalizedString(new Locale("pt"), "2M"));
        TuitionPaymentPlan tuitionPaymentPlan_1T = registration.getLastStudentCurricularPlan().getDegreeCurricularPlan().getTuitionPaymentPlanOrdersSet().stream().map(t -> t.getTuitionPaymentPlan()).filter(t -> "1T".equals(t.getCustomizedName().getContent())).findFirst().get();
        TuitionPaymentPlan tuitionPaymentPlan_2T = registration.getLastStudentCurricularPlan().getDegreeCurricularPlan().getTuitionPaymentPlanOrdersSet().stream().map(t -> t.getTuitionPaymentPlan()).filter(t -> "2T".equals(t.getCustomizedName().getContent())).findFirst().get();
        TreasuryExemptionType exemptionTypeOne = (TreasuryExemptionType)TreasuryExemptionType.findByCode((String)"TET1").findFirst().get();
        TreasuryExemptionType exemptionTypeThree = (TreasuryExemptionType)TreasuryExemptionType.findByCode((String)"TET3").findFirst().get();
        TuitionAllocation.create((TuitionPaymentPlanGroup)tuitionPaymentPlan_1T.getTuitionPaymentPlanGroup(), (Registration)registration, (ExecutionInterval)tuitionPaymentPlan_1T.getExecutionYear(), (TuitionDebtPostingType)firstMoment, (TuitionPaymentPlan)tuitionPaymentPlan_1T, Set.of(exemptionTypeOne));
        TuitionAllocation.create((TuitionPaymentPlanGroup)tuitionPaymentPlan_2T.getTuitionPaymentPlanGroup(), (Registration)registration, (ExecutionInterval)tuitionPaymentPlan_2T.getExecutionYear(), (TuitionDebtPostingType)secondMoment, (TuitionPaymentPlan)tuitionPaymentPlan_2T, Set.of(exemptionTypeThree));
    }

    private static TuitionPaymentPlan createTuitionPaymentPlan(String customizedPlanName, BigDecimal amountByEcts) {
        TuitionPaymentPlanBean bean = new TuitionPaymentPlanBean(((TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get()).getCurrentProduct(), (TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), TestRegistrationTuitionRecalculationTestFifty.readFinantialEntity(), executionYear);
        bean.setDefaultPaymentPlan(false);
        bean.setCustomized(true);
        bean.setName(customizedPlanName);
        DegreeCurricularPlan degreeCurricularPlan = registration.getLastStudentCurricularPlan().getDegreeCurricularPlan();
        bean.addDegreeCurricularPlans(degreeCurricularPlan);
        bean.setDegreeType(degreeCurricularPlan.getDegreeType());
        AcademicTariffBean academicTariffBean = new AcademicTariffBean(1);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_1_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(amountByEcts);
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(7);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(2);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_2_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(amountByEcts);
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(30);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(3);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_3_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(amountByEcts);
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(60);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        academicTariffBean = new AcademicTariffBean(4);
        academicTariffBean.setTuitionInstallmentProduct((Product)Product.findUniqueByCode((String)"PROP_4_PREST_1_CIC").get());
        academicTariffBean.setTuitionCalculationType(TuitionCalculationType.ECTS);
        academicTariffBean.setEctsCalculationType(EctsCalculationType.FIXED_AMOUNT);
        academicTariffBean.setFixedAmount(amountByEcts);
        academicTariffBean.setBeginDate(executionYear.getBeginLocalDate());
        academicTariffBean.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        academicTariffBean.setNumberOfDaysAfterCreationForDueDate(90);
        academicTariffBean.setInterestRateType(null);
        bean.getTuitionInstallmentBeans().add(academicTariffBean);
        return TuitionPaymentPlan.create((TuitionPaymentPlanBean)bean);
    }

    private static void ensureNecessaryAcademicDataIsAvailable() {
        registration.getRegistrationProtocol().setPayGratuity(Boolean.valueOf(true));
        if (Country.readByTwoLetterCode((String)"PT") == null) {
            new Country(TestRegistrationTuitionRecalculationTestFifty.ls("Portugal"), TestRegistrationTuitionRecalculationTestFifty.ls("Portugal"), "PT", "PRT").setDefaultCountry(Boolean.valueOf(true));
        }
        registration.getPerson().editSocialSecurityNumber("999999990", PersonCustomer.createSaftDefaultPhysicalAddress((Person)registration.getPerson()));
    }

    @Test
    public void doRecalculation() {
        ((FinantialInstitution)FinantialInstitution.findAll().iterator().next()).setSupportCreditTreasuryExemptions(Boolean.valueOf(true));
        ((FinantialInstitution)FinantialInstitution.findAll().iterator().next()).setSplitDebitEntriesWithSettledAmount(Boolean.valueOf(true));
        ((FinantialInstitution)FinantialInstitution.findAll().iterator().next()).setSplitCreditEntriesWithSettledAmount(Boolean.valueOf(true));
        TestRegistrationTuitionRecalculationTestFifty.createTuitionPaymentPlanWithAmountByEcts();
        TestRegistrationTuitionRecalculationTestFifty.ensureNecessaryAcademicDataIsAvailable();
        TuitionDebtPostingType firstMoment = TuitionDebtPostingType.findAll().filter(t -> "1M".equals(t.getName().getContent())).findFirst().get();
        TuitionDebtPostingType secondMoment = TuitionDebtPostingType.findAll().filter(t -> "2M".equals(t.getName().getContent())).findFirst().get();
        TuitionAllocation firstAllocation = (TuitionAllocation)TuitionAllocation.findUnique((TuitionPaymentPlanGroup)((TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get()), (Registration)registration, (ExecutionInterval)executionYear, (TuitionDebtPostingType)firstMoment).get();
        TuitionAllocation secondAllocation = (TuitionAllocation)TuitionAllocation.findUnique((TuitionPaymentPlanGroup)((TuitionPaymentPlanGroup)TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get()), (Registration)registration, (ExecutionInterval)executionYear, (TuitionDebtPostingType)secondMoment).get();
        ReservationTaxEventTarget.createReservationTaxDebt((ReservationTax)((ReservationTax)ReservationTax.findUniqueActiveByProduct((Product)((Product)Product.findUniqueByCode((String)"RT1").get())).get()), (Person)registration.getPerson(), (DegreeCurricularPlan)registration.getLastStudentCurricularPlan().getDegreeCurricularPlan(), (ExecutionInterval)executionYear, (LocalDate)new LocalDate());
        Product firstInstallmentProduct = (Product)Product.findUniqueByCode((String)"PROP_1_PREST_1_CIC").get();
        RegistrationTuitionService.startServiceInvocation((Registration)registration, (ExecutionYear)executionYear, (LocalDate)new LocalDate()).applyEnrolledEctsUnits(new BigDecimal("60")).applyEnrolledCoursesCount(new BigDecimal("5")).withTuitionPaymentPlan(firstAllocation.getTuitionPaymentPlan()).applyTuitionAllocation(firstAllocation).restrictForInstallmentProducts(Set.of(firstInstallmentProduct)).withoutInstallmentsRecalculation().executeTuitionPaymentPlanCreation();
        AcademicTreasuryEvent academicTreasuryEvent = (AcademicTreasuryEvent)AcademicTreasuryEvent.findUniqueForRegistrationTuition((Registration)registration, (ExecutionYear)executionYear).get();
        Assert.assertEquals((Object)new BigDecimal("176.74"), (Object)academicTreasuryEvent.getAmountWithVatToPay());
        Assert.assertEquals((Object)new BigDecimal("423.26"), (Object)academicTreasuryEvent.getNetExemptedAmount());
        Assert.assertEquals((long)1L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).count());
        DebitEntry firstInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).iterator().next();
        Assert.assertEquals((long)1L, (long)firstInstallment.getTreasuryExemptionsSet().size());
        Assert.assertEquals((Object)new BigDecimal("176.74"), (Object)firstInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("423.26"), (Object)firstInstallment.getNetExemptedAmount());
        DocumentNumberSeries debitNoteDocumentNumberSeries = DocumentNumberSeries.findUniqueDefaultSeries((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialEntity)firstInstallment.getFinantialEntity());
        DebitNote.createDebitNoteForDebitEntry((DebitEntry)firstInstallment, null, (DocumentNumberSeries)debitNoteDocumentNumberSeries, (DateTime)new DateTime(), (LocalDate)new LocalDate(), null, null, null);
        DocumentNumberSeries settleDocumentNumberSeries = DocumentNumberSeries.findUniqueDefaultSeries((FinantialDocumentType)FinantialDocumentType.findForSettlementNote(), (FinantialEntity)firstInstallment.getFinantialEntity());
        SettlementNoteBean settlementNoteBean = new SettlementNoteBean(firstInstallment.getDebtAccount(), false, false);
        settlementNoteBean.setDocNumSeries(settleDocumentNumberSeries);
        settlementNoteBean.getInvoiceEntryBean((InvoiceEntry)firstInstallment).setSettledAmount(new BigDecimal("36.74"));
        settlementNoteBean.getInvoiceEntryBean((InvoiceEntry)firstInstallment).setIncluded(true);
        settlementNoteBean.setFinantialEntity(firstInstallment.getFinantialEntity());
        settlementNoteBean.getPaymentEntries().add(new SettlementNoteBean.PaymentEntryBean(new BigDecimal("36.74"), PaymentMethod.findByCode((String)"NU"), null));
        SettlementNote.createSettlementNote((SettlementNoteBean)settlementNoteBean);
        Assert.assertEquals((Object)new BigDecimal("36.74"), (Object)firstInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("87.99"), (Object)firstInstallment.getNetExemptedAmount());
        Assert.assertEquals((long)2L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).count());
        DebitEntry secondFirstInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).filter(de -> de != firstInstallment).iterator().next();
        Assert.assertEquals((Object)new BigDecimal("140.00"), (Object)secondFirstInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("335.27"), (Object)secondFirstInstallment.getNetExemptedAmount());
        Assert.assertEquals((Object)true, (Object)firstInstallment.isProcessedInClosedDebitNote());
        Assert.assertEquals((Object)true, (Object)secondFirstInstallment.getDebitNote().isPreparing());
        RegistrationTuitionService.startServiceInvocation((Registration)registration, (ExecutionYear)executionYear, (LocalDate)new LocalDate()).applyEnrolledEctsUnits(new BigDecimal("60")).applyEnrolledCoursesCount(new BigDecimal("10")).withTuitionPaymentPlan(secondAllocation.getTuitionPaymentPlan()).applyTuitionAllocation(secondAllocation).withAllInstallments().forceInstallmentsEvenTreasuryEventIsCharged(true).recalculateInstallments(Map.of(firstInstallmentProduct, new LocalDate())).executeTuitionPaymentPlanCreation();
        Assert.assertEquals((long)2L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).count());
        Assert.assertEquals((Object)false, (Object)firstInstallment.isAnnulled());
        Assert.assertEquals((long)1L, (long)firstInstallment.getCreditEntriesSet().size());
        Assert.assertEquals((Object)true, (Object)secondFirstInstallment.isAnnulled());
        DebitEntry thirdFirstInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).filter(de -> de.isProcessedInClosedDebitNote()).iterator().next();
        Assert.assertEquals((Object)true, (Object)(thirdFirstInstallment != firstInstallment ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(thirdFirstInstallment != secondFirstInstallment ? 1 : 0));
        Assert.assertEquals((Object)new BigDecimal("36.74"), (Object)thirdFirstInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("387.18"), (Object)thirdFirstInstallment.getNetExemptedAmount());
        Assert.assertEquals((long)1L, (long)thirdFirstInstallment.getSettlementEntriesSet().size());
        DebitEntry fourFirstInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)firstInstallmentProduct).filter(de -> de != thirdFirstInstallment).iterator().next();
        Assert.assertEquals((Object)true, (Object)(fourFirstInstallment != firstInstallment ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(fourFirstInstallment != secondFirstInstallment ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(fourFirstInstallment != thirdFirstInstallment ? 1 : 0));
        Assert.assertEquals((Object)new BigDecimal("15.26"), (Object)fourFirstInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("160.82"), (Object)fourFirstInstallment.getNetExemptedAmount());
        Product secondInstallmentProduct = (Product)Product.findUniqueByCode((String)"PROP_2_PREST_1_CIC").get();
        Assert.assertEquals((long)1L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)secondInstallmentProduct).count());
        DebitEntry secondInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)secondInstallmentProduct).iterator().next();
        Assert.assertEquals((long)1L, (long)secondInstallment.getTreasuryExemptionsSet().size());
        Assert.assertEquals((Object)new BigDecimal("402.00"), (Object)secondInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("198.00"), (Object)secondInstallment.getNetExemptedAmount());
        Product thirdInstallmentProduct = (Product)Product.findUniqueByCode((String)"PROP_3_PREST_1_CIC").get();
        DebitEntry thirdInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)thirdInstallmentProduct).iterator().next();
        Assert.assertEquals((Object)new BigDecimal("402.00"), (Object)thirdInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("198.00"), (Object)thirdInstallment.getNetExemptedAmount());
        Product fourInstallmentProduct = (Product)Product.findUniqueByCode((String)"PROP_4_PREST_1_CIC").get();
        DebitEntry fourInstallment = (DebitEntry)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)fourInstallmentProduct).iterator().next();
        Assert.assertEquals((Object)new BigDecimal("402.00"), (Object)fourInstallment.getAmountWithVat());
        Assert.assertEquals((Object)new BigDecimal("198.00"), (Object)fourInstallment.getNetExemptedAmount());
        Assert.assertEquals((Object)new BigDecimal("1258.00"), (Object)academicTreasuryEvent.getAmountWithVatToPay());
        Assert.assertEquals((Object)new BigDecimal("1142.00"), (Object)academicTreasuryEvent.getNetExemptedAmount());
        Assert.assertEquals((long)5L, (long)DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent).count());
    }

    private static FinantialEntity readFinantialEntity() {
        return (FinantialEntity)FinantialEntity.findAll().iterator().next();
    }

    public static LocalizedString ls(String string) {
        return new LocalizedString(TreasuryConstants.DEFAULT_LANGUAGE, string);
    }
}

