/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.base;

import com.qubit.terra.framework.services.ServiceProvider;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PartyContactValidationState;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.curriculum.grade.GradeScale;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.IdDocumentTypeObject;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicIntervalCE;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE;
import org.fenixedu.academic.domain.treasury.ITreasuryBridgeAPI;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.academictreasury.base.AcademicTreasuryPlatformDependentServicesForTests;
import org.fenixedu.academictreasury.base.TreasuryPlatformDependentServicesForTests;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTax;
import org.fenixedu.academictreasury.domain.reservationtax.ReservationTaxTariff;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.treasury.AcademicTreasuryBridgeImpl;
import org.fenixedu.academictreasury.domain.tuition.exemptions.StatuteExemptionByIntervalMapEntry;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryBootstrapper;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.ProductGroup;
import org.fenixedu.treasury.domain.VatExemptionReason;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryBootstrapper;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;

public class BasicAcademicTreasuryUtils {
    public static void startup(Callable<?> startup) {
        try {
            FenixFramework.getTransactionManager().withTransaction(() -> {
                Locale.setDefault(new Locale("PT", "pt"));
                TreasuryPlataformDependentServicesFactory.registerImplementation((ITreasuryPlatformDependentServices)new TreasuryPlatformDependentServicesForTests());
                AcademicTreasuryPlataformDependentServicesFactory.registerImplementation((IAcademicTreasuryPlatformDependentServices)new AcademicTreasuryPlatformDependentServicesForTests());
                ServiceProvider.registerService(ITreasuryBridgeAPI.class, AcademicTreasuryBridgeImpl.class);
                TreasuryBootstrapper.bootstrap((String)"teste", (String)"teste", (String)"PT");
                AcademicTreasuryBootstrapper.bootstrap();
                startup.call();
                return null;
            }, (Atomic)new AtomicInstance(Atomic.TxMode.WRITE, true));
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static Degree findOrCreateDegree() {
        if (Degree.find((String)"9999") == null) {
            GradeScale.create((String)"TYPE20", (LocalizedString)BasicAcademicTreasuryUtils.ls("Type 20"), (BigDecimal)new BigDecimal(0), (BigDecimal)new BigDecimal(9), (BigDecimal)new BigDecimal(10), (BigDecimal)new BigDecimal(20), (boolean)true, (boolean)true);
            GradeScale numericGradeScale = GradeScale.getGradeScaleByCode((String)"TYPE20");
            DegreeType degreeType = BasicAcademicTreasuryUtils.findOrCreateDegreeType();
            Degree degree = new Degree("Curso Teste", "Degree Test", "9999", degreeType, numericGradeScale, numericGradeScale, BasicAcademicTreasuryUtils.findOrCreateExecutionYear("2022/2023"));
            degree.setCalendar(BasicAcademicTreasuryUtils.findOrCreateExecutionYear("2022/2023").getAcademicInterval().getAcademicCalendar());
            degree.createDegreeCurricularPlan("DCP", BasicAcademicTreasuryUtils.findOrCreatePerson(), AcademicPeriod.YEAR);
            degree.setCode("9999");
            ((DegreeCurricularPlan)degree.getDegreeCurricularPlansSet().iterator().next()).setCurricularStage(CurricularStage.APPROVED);
            ((DegreeCurricularPlan)degree.getDegreeCurricularPlansSet().iterator().next()).createExecutionDegree(BasicAcademicTreasuryUtils.findOrCreateExecutionYear("2022/2023"), null, Boolean.valueOf(false));
            return degree;
        }
        return Degree.find((String)"9999");
    }

    private static DegreeType findOrCreateDegreeType() {
        if (DegreeType.matching(dt -> "First Cycle".equals(dt.getName().getContent())).isEmpty()) {
            new DegreeType(BasicAcademicTreasuryUtils.ls("First Cycle"));
        }
        return (DegreeType)DegreeType.matching(dt -> "First Cycle".equals(dt.getName().getContent())).get();
    }

    private static Person findOrCreatePerson() {
        if (Person.readAllPersons().isEmpty()) {
            if (IdDocumentTypeObject.readByIDDocumentType((IDDocumentType)IDDocumentType.OTHER) == null) {
                new IdDocumentTypeObject().setValue(IDDocumentType.OTHER);
            }
            PersonBean personBean = new PersonBean("Test person", "999999990", IDDocumentType.OTHER, new LocalDate(2000, 1, 1).toDateTimeAtStartOfDay().toYearMonthDay());
            personBean.setGivenNames("Test");
            personBean.setFamilyNames("person");
            Person person = new Person(personBean);
            if (Country.readByTwoLetterCode((String)"PT") == null) {
                new Country(BasicAcademicTreasuryUtils.ls("Portugal"), BasicAcademicTreasuryUtils.ls("Portugal"), "PT", "PRT");
            }
            PhysicalAddress physicalAddress = new PhysicalAddress((Party)person, PartyContactType.PERSONAL, Boolean.valueOf(true), "Desconhecido", "Desconhecido", "Desconhecido", "Desconhecido", "Desconhecido", "Desconhecido", "Desconhecido", Country.readByTwoLetterCode((String)"PT"));
            physicalAddress.setActive(Boolean.valueOf(true));
            physicalAddress.getPartyContactValidation().setState(PartyContactValidationState.VALID);
            person.editSocialSecurityNumber("999999990", physicalAddress);
        }
        return (Person)Person.readAllPersons().iterator().next();
    }

    public static ExecutionYear findOrCreateExecutionYear(String string) {
        if (ExecutionYear.readExecutionYearByName((String)"2022/2023") != null) {
            return ExecutionYear.readExecutionYearByName((String)"2022/2023");
        }
        AcademicCalendarRootEntry rootEntry = new AcademicCalendarRootEntry(BasicAcademicTreasuryUtils.ls("root calendar entry"), BasicAcademicTreasuryUtils.ls("root calendar entry"));
        AcademicYearCE calendarYear = new AcademicYearCE((AcademicCalendarEntry)rootEntry, BasicAcademicTreasuryUtils.ls("2022/2023"), BasicAcademicTreasuryUtils.ls("2022/2023"), new LocalDate(2022, 9, 1).toDateTimeAtStartOfDay(), new LocalDate(2023, 8, 31).toDateTimeAtStartOfDay(), rootEntry);
        AcademicInterval academicInterval = new AcademicInterval((AcademicCalendarEntry)calendarYear, rootEntry);
        ExecutionYear.readExecutionYearByName((String)"2022/2023").setState(PeriodState.CURRENT);
        new AcademicIntervalCE(AcademicPeriod.SEMESTER, (AcademicCalendarEntry)calendarYear, BasicAcademicTreasuryUtils.ls("1st Semester"), BasicAcademicTreasuryUtils.ls("1st Semester"), new LocalDate(2022, 9, 1).toDateTimeAtStartOfDay(), new LocalDate(2023, 2, 28).toDateTimeAtStartOfDay(), rootEntry);
        return ExecutionYear.readExecutionYearByName((String)"2022/2023");
    }

    public static LocalizedString ls(String string) {
        return new LocalizedString(TreasuryConstants.DEFAULT_LANGUAGE, string);
    }

    public static Registration findOrCreateRegistration() {
        RegistrationStateType.findByCode((String)"REGISTERED").ifPresentOrElse(t -> {}, () -> RegistrationStateType.create((String)"REGISTERED", (LocalizedString)BasicAcademicTreasuryUtils.ls("Registered"), (boolean)true));
        if (BasicAcademicTreasuryUtils.findOrCreateStudent().getRegistrationsFor(BasicAcademicTreasuryUtils.findOrCreateDegree()).isEmpty()) {
            Registration.create((Student)BasicAcademicTreasuryUtils.findOrCreateStudent(), (DegreeCurricularPlan)((DegreeCurricularPlan)BasicAcademicTreasuryUtils.findOrCreateDegree().getDegreeCurricularPlansSet().iterator().next()), (ExecutionYear)BasicAcademicTreasuryUtils.findOrCreateExecutionYear("2022/2023"), (RegistrationProtocol)BasicAcademicTreasuryUtils.findOrCreateRegistrationProtocol(), (IngressionType)BasicAcademicTreasuryUtils.findOrCreateIngressionType());
        }
        return (Registration)BasicAcademicTreasuryUtils.findOrCreateStudent().getRegistrationsFor(BasicAcademicTreasuryUtils.findOrCreateDegree()).iterator().next();
    }

    private static IngressionType findOrCreateIngressionType() {
        if (IngressionType.findByPredicate(t -> "PSA1".equals(t.getCode())).isEmpty()) {
            IngressionType.createIngressionType((String)"PSA1", (LocalizedString)BasicAcademicTreasuryUtils.ls("default ingression"));
        }
        return (IngressionType)IngressionType.findByPredicate(t -> "PSA1".equals(t.getCode())).get();
    }

    private static RegistrationProtocol findOrCreateRegistrationProtocol() {
        if (RegistrationProtocol.getDefault() == null) {
            RegistrationProtocol registrationProtocol = new RegistrationProtocol("NORMAL", BasicAcademicTreasuryUtils.ls("Normal"), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
            registrationProtocol.setDefaultStatus(true);
        }
        return RegistrationProtocol.getDefault();
    }

    private static Student findOrCreateStudent() {
        Person person = BasicAcademicTreasuryUtils.findOrCreatePerson();
        if (person.getStudent() == null) {
            new Student(BasicAcademicTreasuryUtils.findOrCreatePerson());
        }
        return person.getStudent();
    }

    public static void createReservationTaxes() {
        TreasuryExemptionType tet1 = TreasuryExemptionType.create((String)"TET1", (LocalizedString)BasicAcademicTreasuryUtils.ls("Treasury Exemption 1"), (BigDecimal)new BigDecimal("12.21"), (boolean)true);
        TreasuryExemptionType tet2 = TreasuryExemptionType.create((String)"TET2", (LocalizedString)BasicAcademicTreasuryUtils.ls("Treasury Exemption 2"), (BigDecimal)new BigDecimal("100.00"), (boolean)true);
        Product prt1 = Product.create((ProductGroup)AcademicTreasurySettings.getInstance().getEmolumentsProductGroup(), (String)"RT1", (LocalizedString)BasicAcademicTreasuryUtils.ls("Reservation Tax 1"), (LocalizedString)BasicAcademicTreasuryUtils.ls("Unit"), (boolean)true, (boolean)false, (int)0, (VatType)VatType.findByCode((String)"ISE"), List.of((FinantialInstitution)FinantialInstitution.findAll().iterator().next()), (VatExemptionReason)VatExemptionReason.findByCode((String)"M07"));
        Product prt2 = Product.create((ProductGroup)AcademicTreasurySettings.getInstance().getEmolumentsProductGroup(), (String)"RT2", (LocalizedString)BasicAcademicTreasuryUtils.ls("Reservation Tax 2"), (LocalizedString)BasicAcademicTreasuryUtils.ls("Unit"), (boolean)true, (boolean)false, (int)0, (VatType)VatType.findByCode((String)"ISE"), List.of((FinantialInstitution)FinantialInstitution.findAll().iterator().next()), (VatExemptionReason)VatExemptionReason.findByCode((String)"M07"));
        ReservationTax rt1 = ReservationTax.create((String)"RT1", (LocalizedString)BasicAcademicTreasuryUtils.ls("Reservation Tax 1"), (FinantialEntity)((FinantialEntity)FinantialEntity.findAll().iterator().next()), (Product)prt1, (boolean)true, (boolean)true, (boolean)false, (LocalizedString)BasicAcademicTreasuryUtils.ls("Reservation Tax 1"), (TreasuryExemptionType)tet1);
        ReservationTax rt2 = ReservationTax.create((String)"RT2", (LocalizedString)BasicAcademicTreasuryUtils.ls("Reservation Tax 2"), (FinantialEntity)((FinantialEntity)FinantialEntity.findAll().iterator().next()), (Product)prt2, (boolean)true, (boolean)true, (boolean)false, (LocalizedString)BasicAcademicTreasuryUtils.ls("Reservation Tax 2"), (TreasuryExemptionType)tet2);
        ExecutionYear.readNotClosedExecutionYears().forEach(ey -> {
            ReservationTaxTariff.create((ReservationTax)rt1, (ExecutionInterval)ey, (BigDecimal)new BigDecimal("350.00"), (DueDateCalculationType)DueDateCalculationType.DAYS_AFTER_CREATION, (int)1, null, (boolean)false, null, null).addDegrees(Degree.findAll().collect(Collectors.toSet()));
            ReservationTaxTariff.create((ReservationTax)rt2, (ExecutionInterval)ey, (BigDecimal)new BigDecimal("100.00"), (DueDateCalculationType)DueDateCalculationType.DAYS_AFTER_CREATION, (int)1, null, (boolean)false, null, null).addDegrees(Degree.findAll().collect(Collectors.toSet()));
        });
    }

    public static void createStatuteTypeExemptionsMap() {
        TreasuryExemptionType tet1 = (TreasuryExemptionType)TreasuryExemptionType.findByCode((String)"TET1").iterator().next();
        TreasuryExemptionType tet3 = TreasuryExemptionType.create((String)"TET3", (LocalizedString)BasicAcademicTreasuryUtils.ls("Treasury Exemption 3"), (BigDecimal)new BigDecimal("33.00"), (boolean)true);
        TreasuryExemptionType tet4 = TreasuryExemptionType.create((String)"TET4", (LocalizedString)BasicAcademicTreasuryUtils.ls("Treasury Exemption 4"), (BigDecimal)new BigDecimal("11.00"), (boolean)true);
        StatuteType st3 = StatuteType.create((String)"ST3", (LocalizedString)BasicAcademicTreasuryUtils.ls("Statute Type 3"));
        StatuteType st4 = StatuteType.create((String)"ST4", (LocalizedString)BasicAcademicTreasuryUtils.ls("Statute Type 4"));
        StatuteType st5 = StatuteType.create((String)"ST_SHARED", (LocalizedString)BasicAcademicTreasuryUtils.ls("Statute Type Shared"));
        ExecutionYear.readNotClosedExecutionYears().forEach(ey -> {
            StatuteExemptionByIntervalMapEntry.create((FinantialEntity)((FinantialEntity)FinantialEntity.findAll().iterator().next()), (ExecutionInterval)ey, (StatuteType)st3, (TreasuryExemptionType)tet3);
            StatuteExemptionByIntervalMapEntry.create((FinantialEntity)((FinantialEntity)FinantialEntity.findAll().iterator().next()), (ExecutionInterval)ey, (StatuteType)st4, (TreasuryExemptionType)tet4);
            StatuteExemptionByIntervalMapEntry.create((FinantialEntity)((FinantialEntity)FinantialEntity.findAll().iterator().next()), (ExecutionInterval)ey, (StatuteType)st5, (TreasuryExemptionType)tet1);
        });
        TreasuryExemptionType tet5 = TreasuryExemptionType.create((String)"TET5", (LocalizedString)BasicAcademicTreasuryUtils.ls("Treasury Exemption 5"), (BigDecimal)new BigDecimal("25"), (boolean)true);
    }
}

