/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.conditionRule;

import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionAnnotation;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.FirstTimeStudentConditionRule_Base;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;

@TuitionConditionAnnotation(value="resources.AcademicTreasuryResources")
public class FirstTimeStudentConditionRule
extends FirstTimeStudentConditionRule_Base {
    public static final String BUNDLE_NAME = "resources.AcademicTreasuryResources";

    public boolean containsRule(TuitionConditionRule tuitionConditionRule) {
        if (!(tuitionConditionRule instanceof FirstTimeStudentConditionRule)) {
            return false;
        }
        FirstTimeStudentConditionRule rule = (FirstTimeStudentConditionRule)((Object)tuitionConditionRule);
        return this.getFirstTimeStudent().equals(rule.getFirstTimeStudent());
    }

    public boolean isValidTo(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        boolean registrationFirstTime = registration.isFirstTime(executionYear);
        return Boolean.logicalAnd(this.getFirstTimeStudent(), registrationFirstTime);
    }

    public boolean checkRules() {
        if (this.getFirstTimeStudent() == null) {
            throw new DomainException(this.i18n("org.fenixedu.academictreasury.domain.tuition.conditionRule.firstTimeStudentConditionRule.firstTimeStudent.cannotBeNull", new String[0]), new String[0]);
        }
        return true;
    }

    public String getDescription() {
        return Boolean.TRUE.equals(this.getFirstTimeStudent()) ? this.i18n("label.true", new String[0]) : this.i18n("label.false", new String[0]);
    }

    protected String getBundle() {
        return BUNDLE_NAME;
    }

    public void delete() {
        this.setTuitionPaymentPlan(null);
        this.setTuitionPaymentPlanCalculator(null);
        this.setDomainRoot(null);
        this.deleteDomainObject();
    }

    public TuitionConditionRule duplicate() {
        FirstTimeStudentConditionRule result = new FirstTimeStudentConditionRule();
        result.setFirstTimeStudent(this.getFirstTimeStudent());
        return result;
    }

    public void fillRuleFromImporter(TuitionPaymentPlanBean bean) {
        String value = bean.getImporterRules().get(((Object)((Object)this)).getClass());
        if (value.equals(this.i18n("label.true", new String[0]))) {
            this.setFirstTimeStudent(Boolean.TRUE);
            return;
        }
        if (value.equals(this.i18n("label.false", new String[0]))) {
            this.setFirstTimeStudent(Boolean.FALSE);
            return;
        }
        throw new AcademicTreasuryDomainException("error.FirstTimeStudentConditionRule.value.invalid", value);
    }
}

