/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.base;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.joda.time.LocalDate;

public class AcademicTreasuryPlatformDependentServicesForTests
implements IAcademicTreasuryPlatformDependentServices {
    public Set<DegreeType> readAllDegreeTypes() {
        return DegreeType.all().collect(Collectors.toSet());
    }

    public Set<DegreeCurricularPlan> readAllDegreeCurricularPlansSet() {
        return DegreeCurricularPlan.readBolonhaDegreeCurricularPlans();
    }

    public Set<DegreeCurricularPlan> readDegreeCurricularPlansWithExecutionDegree(ExecutionYear executionYear, DegreeType degreeType) {
        return null;
    }

    public Set<CurricularYear> readAllCurricularYearsSet() {
        return Collections.emptySet();
    }

    public Set<IngressionType> readAllIngressionTypesSet() {
        return Collections.emptySet();
    }

    public Set<RegistrationProtocol> readAllRegistrationProtocol() {
        return Collections.emptySet();
    }

    public Set<StatuteType> readAllStatuteTypesSet() {
        return Collections.emptySet();
    }

    public Set<StatuteType> readAllStatuteTypesSet(boolean active) {
        return Collections.emptySet();
    }

    public Set<Registration> readAllRegistrations(RegistrationProtocol registrationProtocol) {
        return null;
    }

    public Set<Registration> readAllRegistrations(IngressionType ingressionType) {
        return null;
    }

    public Set<Person> readAllPersonsSet() {
        return null;
    }

    public PersonCustomer personCustomer(Person person) {
        return person.getPersonCustomer();
    }

    public Set<PersonCustomer> inactivePersonCustomers(Person person) {
        return person.getInactivePersonCustomersSet();
    }

    public PhysicalAddress fiscalAddress(Person person) {
        return person.getFiscalAddress();
    }

    public String iban(Person person) {
        return null;
    }

    public Set<AcademicTreasuryEvent> academicTreasuryEventsSet(Person person) {
        return person.getAcademicTreasuryEventSet();
    }

    public String defaultPhoneNumber(Person person) {
        return null;
    }

    public String defaultMobilePhoneNumber(Person person) {
        return null;
    }

    public List<PhysicalAddress> pendingOrValidPhysicalAddresses(Person person) {
        return null;
    }

    public List<? extends PartyContact> pendingOrValidPartyContacts(Person person, Class<? extends PartyContact> partyContactType) {
        return null;
    }

    public void editSocialSecurityNumber(Person person, String fiscalNumber, PhysicalAddress fiscalAddress) {
    }

    public void setFiscalAddress(PhysicalAddress physicalAddress, boolean fiscalAddress) {
    }

    public PhysicalAddress createPhysicalAddress(Person person, Country countryOfResidence, String districtOfResidence, String districtSubdivisionOfResidence, String areaCode, String address) {
        PhysicalAddressData data = new PhysicalAddressData();
        data.setAddress(address);
        data.setCountryOfResidence(countryOfResidence);
        data.setDistrictOfResidence(districtOfResidence);
        data.setDistrictSubdivisionOfResidence(districtSubdivisionOfResidence);
        data.setAreaCode(areaCode);
        PhysicalAddress physicalAddress = PhysicalAddress.createPhysicalAddress((Party)person, (PhysicalAddressData)data, (PartyContactType)PartyContactType.PERSONAL, (Boolean)false);
        physicalAddress.setValid();
        return physicalAddress;
    }

    public String fiscalCountry(Person person) {
        return null;
    }

    public String fiscalNumber(Person person) {
        return person.getSocialSecurityNumber();
    }

    public boolean isFrontOfficeMember(String username, FinantialEntity finantialEntity) {
        return false;
    }

    public boolean isBackOfficeMember(String username, FinantialEntity finantialEntity) {
        return false;
    }

    public boolean isAllowToModifySettlements(String username, FinantialEntity finantialEntity) {
        return false;
    }

    public boolean isAllowToModifyInvoices(String username, FinantialEntity finantialEntity) {
        return false;
    }

    public Set<Degree> readDegrees(FinantialEntity finantialEntity) {
        return null;
    }

    public FinantialEntity finantialEntityOfDegree(Degree degree, LocalDate when) {
        return (FinantialEntity)FinantialEntity.findAll().iterator().next();
    }

    public Optional<FinantialEntity> finantialEntity(Unit unit) {
        return FinantialEntity.findAll().findFirst();
    }

    public Set<String> getFrontOfficeMemberUsernames(FinantialEntity finantialEntity) {
        return null;
    }

    public Set<String> getBackOfficeMemberUsernames(FinantialEntity finantialEntity) {
        return null;
    }

    public String localizedNameOfDegreeType(DegreeType degreeType) {
        return degreeType.getName().getContent();
    }

    public String localizedNameOfDegreeType(DegreeType degreeType, Locale locale) {
        return degreeType.getName().getContent(locale);
    }

    public String localizedNameOfStatuteType(StatuteType statuteType) {
        return statuteType.getName().getContent();
    }

    public String localizedNameOfStatuteType(StatuteType statuteType, Locale locale) {
        return statuteType.getName().getContent(locale);
    }

    public String localizedNameOfEnrolment(Enrolment enrolment) {
        return null;
    }

    public String localizedNameOfEnrolment(Enrolment enrolment, Locale locale) {
        return null;
    }

    public RegistrationDataByExecutionYear findRegistrationDataByExecutionYear(Registration registration, ExecutionYear executionYear) {
        return null;
    }

    public IngressionType ingression(Registration registration) {
        return null;
    }

    public RegistrationProtocol registrationProtocol(Registration registration) {
        return registration.getRegistrationProtocol();
    }

    public RegistrationRegimeType registrationRegimeType(Registration registration, ExecutionYear executionYear) {
        return null;
    }

    public Set<StatuteType> statutesTypesValidOnAnyExecutionSemesterFor(Registration registration, ExecutionInterval executionInterval) {
        return Sets.newHashSet(AcademicTreasuryPlatformDependentServicesForTests.findStatuteTypes(registration, executionInterval));
    }

    public static Collection<StatuteType> findStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        if (executionInterval instanceof ExecutionYear) {
            return AcademicTreasuryPlatformDependentServicesForTests.findStatuteTypesByYear(registration, (ExecutionYear)executionInterval);
        }
        return AcademicTreasuryPlatformDependentServicesForTests.findStatuteTypesByChildInterval(registration, executionInterval);
    }

    private static Collection<StatuteType> findStatuteTypesByYear(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        for (ExecutionInterval executionInterval : executionYear.getExecutionPeriodsSet()) {
            result.addAll(AcademicTreasuryPlatformDependentServicesForTests.findStatuteTypesByChildInterval(registration, executionInterval));
        }
        return result;
    }

    private static Collection<StatuteType> findStatuteTypesByChildInterval(Registration registration, ExecutionInterval executionInterval) {
        return registration.getStudent().getStudentStatutesSet().stream().filter(s -> s.isValidInExecutionInterval(executionInterval) && (s.getRegistration() == null || s.getRegistration() == registration)).map(s -> s.getType()).collect(Collectors.toSet());
    }

    public static String getVisibleStatuteTypesDescription(Registration registration, ExecutionInterval executionInterval) {
        return AcademicTreasuryPlatformDependentServicesForTests.findVisibleStatuteTypes(registration, executionInterval).stream().map(s -> s.getName().getContent()).distinct().collect(Collectors.joining(", "));
    }

    public static Collection<StatuteType> findVisibleStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        return AcademicTreasuryPlatformDependentServicesForTests.findStatuteTypes(registration, executionInterval).stream().filter(s -> s.getVisible()).collect(Collectors.toSet());
    }

    public ExecutionInterval executionSemester(Enrolment enrolment) {
        return null;
    }

    public ExecutionInterval executionSemester(EnrolmentEvaluation enrolmentEvaluation) {
        return null;
    }

    public ExecutionYear executionYearOfExecutionSemester(ExecutionInterval executionInterval) {
        return null;
    }

    public Integer executionIntervalChildOrder(ExecutionInterval executionInterval) {
        return null;
    }

    public ExecutionInterval getExecutionIntervalByName(String s) {
        return null;
    }
}

