/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import com.google.common.base.Strings;
import java.util.Comparator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import pt.ist.fenixframework.core.AbstractDomainObject;

public interface IFinantialReportEntryCommonMethods {
    default public void fillAcademicInformation(InvoiceEntry invoiceEntry) {
        DebitEntry debitEntry = invoiceEntry.isDebitNoteEntry() ? (DebitEntry)invoiceEntry : ((CreditEntry)invoiceEntry).getDebitEntry();
        TreasuryEvent treasuryEvent = null;
        if (debitEntry != null) {
            treasuryEvent = debitEntry.getTreasuryEvent();
        } else if (invoiceEntry.isCreditNoteEntry()) {
            treasuryEvent = ((CreditEntry)invoiceEntry).getTreasuryEvent();
        }
        if (treasuryEvent == null) {
            boolean isExcessPayment;
            boolean isTreasuryCertificationMode = invoiceEntry.getDebtAccount().getFinantialInstitution().isInvoiceRegistrationByTreasuryCertification();
            boolean bl = isExcessPayment = invoiceEntry.getProduct() == TreasurySettings.getInstance().getAdvancePaymentProduct();
            if (isTreasuryCertificationMode && isExcessPayment) {
                DebitEntry originDebitEntry = this.getExcessPaymentOriginDebitEntry(invoiceEntry);
                if (originDebitEntry == null || originDebitEntry.getFinantialDocument() == null) {
                    return;
                }
                SettlementNote originSettlementNote = originDebitEntry.getDebitNote().getExcessPaymentSettlementNote();
                if (originSettlementNote == null) {
                    return;
                }
                if (originSettlementNote.getPaymentTransaction() != null && originSettlementNote.getPaymentTransaction() != null) {
                    TreasuryEvent relatedTreasuryEvent;
                    PaymentRequest paymentRequest = originSettlementNote.getPaymentTransaction().getPaymentRequest();
                    treasuryEvent = relatedTreasuryEvent = (TreasuryEvent)paymentRequest.getDebitEntriesSet().stream().sorted(Comparator.comparing(AbstractDomainObject::getExternalId)).filter(de -> de.getTreasuryEvent() != null).map(de -> de.getTreasuryEvent()).findFirst().orElse(null);
                }
                if (treasuryEvent == null) {
                    TreasuryEvent relatedTreasuryEvent;
                    treasuryEvent = relatedTreasuryEvent = (TreasuryEvent)originSettlementNote.getSettlemetEntriesSet().stream().sorted(Comparator.comparing(AbstractDomainObject::getExternalId)).filter(se -> se.getInvoiceEntry() != originDebitEntry).filter(se -> se.getInvoiceEntry().getTreasuryEvent() != null).map(se -> se.getInvoiceEntry().getTreasuryEvent()).findFirst().orElse(null);
                }
            }
        }
        if (treasuryEvent != null) {
            if (treasuryEvent instanceof AcademicTreasuryEvent) {
                AcademicTreasuryEvent academicTreasuryEvent = (AcademicTreasuryEvent)treasuryEvent;
                if (academicTreasuryEvent.getDegree() != null) {
                    this.setDegreeType(academicTreasuryEvent.getDegree().getDegreeType().getName().getContent());
                    this.setDegreeCode(academicTreasuryEvent.getDegree().getCode());
                    this.setDegreeName(academicTreasuryEvent.getDegree().getPresentationName());
                    this.setDegreeDomainObject(academicTreasuryEvent.getDegree());
                }
                if (academicTreasuryEvent.getExecutionYear() != null) {
                    this.setExecutionYear(academicTreasuryEvent.getExecutionYear().getQualifiedName());
                    this.setExecutionYearDomainObject(academicTreasuryEvent.getExecutionYear());
                }
                if (academicTreasuryEvent.isForRegistrationTuition()) {
                    Registration registration = academicTreasuryEvent.getRegistration();
                    executionYear = academicTreasuryEvent.getExecutionYear();
                    this.setRegistrationNumber(registration.getNumber());
                    this.setDegreeType(academicTreasuryEvent.getRegistration().getDegree().getDegreeType().getName().getContent());
                    this.setDegreeCode(academicTreasuryEvent.getRegistration().getDegree().getCode());
                    this.setDegreeName(academicTreasuryEvent.getRegistration().getDegree().getPresentationName());
                    this.setDegreeDomainObject(academicTreasuryEvent.getRegistration().getDegree());
                    this.setExecutionYear(executionYear.getQualifiedName());
                    this.setExecutionYearDomainObject(executionYear);
                    if (debitEntry != null) {
                        this.setTuitionPaymentPlan(AcademicTreasuryEvent.AcademicTreasuryEventKeys.valueFor(debitEntry, AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYMENT_PLAN));
                        this.setTuitionPaymentPlanConditions(AcademicTreasuryEvent.AcademicTreasuryEventKeys.valueFor(debitEntry, AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYMENT_PLAN_CONDITIONS));
                    }
                    this.fillStudentConditionsInformation(registration, executionYear);
                    this.setActiveStudentCurricularPlanOfExecutionYear(registration.getStudentCurricularPlan(executionYear));
                    if (this.getActiveStudentCurricularPlanOfExecutionYear() == null) {
                        this.setActiveStudentCurricularPlanOfExecutionYear(registration.getActiveStudentCurricularPlan());
                    }
                } else if (academicTreasuryEvent.isForStandaloneTuition() || academicTreasuryEvent.isForExtracurricularTuition()) {
                    if (debitEntry != null) {
                        CurricularCourse curricularCourse = IFinantialReportEntryCommonMethods.getCurricularCourse(debitEntry);
                        if (curricularCourse != null) {
                            this.setDegreeType(curricularCourse.getDegree().getDegreeType().getName().getContent());
                            this.setDegreeCode(curricularCourse.getDegree().getCode());
                            this.setDegreeName(curricularCourse.getDegree().getPresentationName());
                            this.setDegreeDomainObject(curricularCourse.getDegree());
                        }
                        if (debitEntry.getExecutionSemester() != null) {
                            this.setExecutionYear(debitEntry.getExecutionSemester().getExecutionYear().getQualifiedName());
                            this.setExecutionYearDomainObject(debitEntry.getExecutionSemester().getExecutionYear());
                            this.setExecutionSemester(debitEntry.getExecutionSemester().getQualifiedName());
                        }
                        this.setTuitionPaymentPlan(AcademicTreasuryEvent.AcademicTreasuryEventKeys.valueFor(debitEntry, AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYMENT_PLAN));
                        this.setTuitionPaymentPlanConditions(AcademicTreasuryEvent.AcademicTreasuryEventKeys.valueFor(debitEntry, AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYMENT_PLAN_CONDITIONS));
                    }
                    Registration registration = academicTreasuryEvent.getRegistration();
                    executionYear = academicTreasuryEvent.getExecutionYear();
                    this.fillStudentConditionsInformation(registration, executionYear);
                    this.setActiveStudentCurricularPlanOfExecutionYear(registration.getStudentCurricularPlan(executionYear));
                    if (this.getActiveStudentCurricularPlanOfExecutionYear() == null) {
                        this.setActiveStudentCurricularPlanOfExecutionYear(registration.getActiveStudentCurricularPlan());
                    }
                } else if (academicTreasuryEvent.isForImprovementTax()) {
                    if (debitEntry != null) {
                        CurricularCourse curricularCourse = IFinantialReportEntryCommonMethods.getCurricularCourse(debitEntry);
                        if (curricularCourse != null) {
                            this.setDegreeType(curricularCourse.getDegree().getDegreeType().getName().getContent());
                            this.setDegreeCode(curricularCourse.getDegree().getCode());
                            this.setDegreeName(curricularCourse.getDegree().getPresentationName());
                            this.setDegreeDomainObject(curricularCourse.getDegree());
                        }
                        if (debitEntry.getExecutionSemester() != null) {
                            this.setExecutionYear(debitEntry.getExecutionSemester().getExecutionYear().getQualifiedName());
                            this.setExecutionSemester(debitEntry.getExecutionSemester().getQualifiedName());
                            this.setExecutionYearDomainObject(debitEntry.getExecutionSemester().getExecutionYear());
                        }
                    }
                    Registration registration = academicTreasuryEvent.getRegistration();
                    executionYear = academicTreasuryEvent.getExecutionYear();
                    this.fillStudentConditionsInformation(registration, executionYear);
                    this.setActiveStudentCurricularPlanOfExecutionYear(registration.getStudentCurricularPlan(executionYear));
                    if (this.getActiveStudentCurricularPlanOfExecutionYear() == null) {
                        this.setActiveStudentCurricularPlanOfExecutionYear(registration.getActiveStudentCurricularPlan());
                    }
                } else if (academicTreasuryEvent.isForAcademicTax()) {
                    Registration registration = academicTreasuryEvent.getRegistration();
                    executionYear = academicTreasuryEvent.getExecutionYear();
                    this.setRegistrationNumber(registration.getNumber());
                    this.setDegreeType(academicTreasuryEvent.getRegistration().getDegree().getDegreeType().getName().getContent());
                    this.setDegreeCode(academicTreasuryEvent.getRegistration().getDegree().getCode());
                    this.setDegreeName(academicTreasuryEvent.getRegistration().getDegree().getPresentationName());
                    this.setDegreeDomainObject(academicTreasuryEvent.getRegistration().getDegree());
                    this.setExecutionYear(executionYear.getQualifiedName());
                    this.setExecutionYearDomainObject(executionYear);
                    this.fillStudentConditionsInformation(academicTreasuryEvent.getRegistration(), executionYear);
                    this.setActiveStudentCurricularPlanOfExecutionYear(registration.getStudentCurricularPlan(executionYear));
                    if (this.getActiveStudentCurricularPlanOfExecutionYear() == null) {
                        this.setActiveStudentCurricularPlanOfExecutionYear(registration.getActiveStudentCurricularPlan());
                    }
                } else if (academicTreasuryEvent.isForAcademicServiceRequest()) {
                    ITreasuryServiceRequest iTreasuryServiceRequest = academicTreasuryEvent.getITreasuryServiceRequest();
                    registration = iTreasuryServiceRequest.getRegistration();
                    this.setRegistrationNumber(registration.getNumber());
                    this.setDegreeType(registration.getDegree().getDegreeType().getName().getContent());
                    this.setDegreeCode(registration.getDegree().getCode());
                    this.setDegreeName(registration.getDegree().getPresentationName());
                    this.setDegreeDomainObject(registration.getDegree());
                    if (iTreasuryServiceRequest.hasExecutionYear()) {
                        executionYear = iTreasuryServiceRequest.getExecutionYear();
                        this.setExecutionYear(executionYear.getQualifiedName());
                        this.setExecutionYearDomainObject(executionYear);
                        this.fillStudentConditionsInformation(iTreasuryServiceRequest.getRegistration(), executionYear);
                        this.setActiveStudentCurricularPlanOfExecutionYear(registration.getStudentCurricularPlan(executionYear));
                    }
                    if (this.getActiveStudentCurricularPlanOfExecutionYear() == null) {
                        this.setActiveStudentCurricularPlanOfExecutionYear(registration.getActiveStudentCurricularPlan());
                    }
                } else if (academicTreasuryEvent.isForTreasuryEventTarget()) {
                    IAcademicTreasuryTarget treasuryEventTarget = (IAcademicTreasuryTarget)academicTreasuryEvent.getTreasuryEventTarget();
                    registration = treasuryEventTarget.getAcademicTreasuryTargetRegistration();
                    if (registration != null) {
                        this.setRegistrationNumber(registration.getNumber());
                        this.setDegreeType(registration.getDegree().getDegreeType().getName().getContent());
                        this.setDegreeCode(registration.getDegree().getCode());
                        this.setDegreeName(registration.getDegree().getPresentationName());
                        this.setDegreeDomainObject(registration.getDegree());
                    }
                    if ((executionYear = treasuryEventTarget.getAcademicTreasuryTargetExecutionYear()) != null) {
                        this.setExecutionYear(executionYear.getQualifiedName());
                        this.setExecutionYearDomainObject(executionYear);
                    }
                    if (treasuryEventTarget.getAcademicTreasuryTargetExecutionSemester() != null) {
                        this.setExecutionSemester(treasuryEventTarget.getAcademicTreasuryTargetExecutionSemester().getQualifiedName());
                    }
                    if (registration != null && executionYear != null) {
                        this.setActiveStudentCurricularPlanOfExecutionYear(registration.getStudentCurricularPlan(executionYear));
                    }
                    if (registration != null && this.getActiveStudentCurricularPlanOfExecutionYear() == null) {
                        this.setActiveStudentCurricularPlanOfExecutionYear(registration.getActiveStudentCurricularPlan());
                    }
                } else if (academicTreasuryEvent.isForCustomAcademicDebt()) {
                    Registration registration = academicTreasuryEvent.getRegistration();
                    executionYear = academicTreasuryEvent.getExecutionYear();
                    this.setRegistrationNumber(registration.getNumber());
                    this.setDegreeType(registration.getDegree().getDegreeType().getName().getContent());
                    this.setDegreeCode(registration.getDegree().getCode());
                    this.setDegreeName(registration.getDegree().getPresentationName());
                    this.setDegreeDomainObject(registration.getDegree());
                    this.setExecutionYear(executionYear.getQualifiedName());
                    this.setExecutionYearDomainObject(executionYear);
                    this.fillStudentConditionsInformation(registration, executionYear);
                    this.setActiveStudentCurricularPlanOfExecutionYear(registration.getStudentCurricularPlan(executionYear));
                    if (this.getActiveStudentCurricularPlanOfExecutionYear() == null) {
                        this.setActiveStudentCurricularPlanOfExecutionYear(registration.getActiveStudentCurricularPlan());
                    }
                }
            } else {
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getDegreeCode())) {
                    this.setDegreeCode(treasuryEvent.getDegreeCode());
                }
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getDegreeName())) {
                    this.setDegreeName(treasuryEvent.getDegreeName());
                }
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getExecutionYearName())) {
                    this.setExecutionYear(treasuryEvent.getExecutionYearName());
                }
            }
            if (debitEntry != null && Strings.isNullOrEmpty((String)this.getDegreeCode())) {
                this.setDegreeCode(debitEntry.getDegreeCode());
            }
            if (debitEntry != null && Strings.isNullOrEmpty((String)this.getExecutionYear())) {
                this.setExecutionYear(debitEntry.getExecutionYearName());
            }
        }
    }

    private static CurricularCourse getCurricularCourse(DebitEntry debitEntry) {
        if (debitEntry.getCurricularCourse() != null) {
            return debitEntry.getCurricularCourse();
        }
        if (debitEntry.getDebitEntry() != null) {
            return debitEntry.getDebitEntry().getCurricularCourse();
        }
        return null;
    }

    default public DebitEntry getExcessPaymentOriginDebitEntry(InvoiceEntry invoiceEntry) {
        DebitEntry originDebitEntry = null;
        if (invoiceEntry.isDebitNoteEntry()) {
            originDebitEntry = (DebitEntry)invoiceEntry;
        } else if (invoiceEntry.isCreditNoteEntry()) {
            originDebitEntry = ((CreditEntry)invoiceEntry).getDebitEntry();
        }
        return originDebitEntry;
    }

    private void fillStudentConditionsInformation(Registration registration, ExecutionYear executionYear) {
        this.setFirstTimeStudent(registration.isFirstTime(executionYear));
        this.setPartialRegime(registration.getRegimeType(executionYear) == RegistrationRegimeType.PARTIAL_TIME);
        this.setStatutes(this.statutes(registration, executionYear));
        this.setAgreement(registration.getRegistrationProtocol().getDescription());
        IngressionType ingressionType = registration.getIngressionType();
        this.setIngression(ingressionType != null ? ingressionType.getDescription() : null);
        this.setNumberOfNormalEnrolments(TuitionServices.normalEnrolmentsIncludingAnnuled(registration, executionYear).size());
        this.setNumberOfStandaloneEnrolments(TuitionServices.standaloneEnrolmentsIncludingAnnuled(registration, executionYear).size());
        this.setNumberOfExtracurricularEnrolments(TuitionServices.extracurricularEnrolmentsIncludingAnnuled(registration, executionYear).size());
    }

    private String statutes(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryConstants.statutesTypesValidOnAnyExecutionSemesterFor(registration, (ExecutionInterval)executionYear).stream().map(s -> s != null ? s.getName().getContent() : "").reduce((a, c) -> c + ", " + a).orElse(null);
    }

    public Integer getRegistrationNumber();

    public void setRegistrationNumber(Integer var1);

    public String getDegreeType();

    public void setDegreeType(String var1);

    public String getDegreeCode();

    public void setDegreeCode(String var1);

    public String getDegreeName();

    public void setDegreeName(String var1);

    public String getExecutionYear();

    public void setExecutionYear(String var1);

    public String getExecutionSemester();

    public void setExecutionSemester(String var1);

    public LocalizedString getAgreement();

    public void setAgreement(LocalizedString var1);

    public LocalizedString getIngression();

    public void setIngression(LocalizedString var1);

    public Boolean getFirstTimeStudent();

    public void setFirstTimeStudent(Boolean var1);

    public Boolean getPartialRegime();

    public void setPartialRegime(Boolean var1);

    public String getStatutes();

    public void setStatutes(String var1);

    public Integer getNumberOfNormalEnrolments();

    public void setNumberOfNormalEnrolments(Integer var1);

    public Integer getNumberOfStandaloneEnrolments();

    public void setNumberOfStandaloneEnrolments(Integer var1);

    public Integer getNumberOfExtracurricularEnrolments();

    public void setNumberOfExtracurricularEnrolments(Integer var1);

    public String getTuitionPaymentPlan();

    public void setTuitionPaymentPlan(String var1);

    public String getTuitionPaymentPlanConditions();

    public void setTuitionPaymentPlanConditions(String var1);

    public Degree getDegreeDomainObject();

    public void setDegreeDomainObject(Degree var1);

    public ExecutionYear getExecutionYearDomainObject();

    public void setExecutionYearDomainObject(ExecutionYear var1);

    public StudentCurricularPlan getActiveStudentCurricularPlanOfExecutionYear();

    public void setActiveStudentCurricularPlanOfExecutionYear(StudentCurricularPlan var1);
}

