/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.reports;

import java.util.Optional;
import java.util.function.Function;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.services.reports.AcademicDocumentPrinterInterface;
import org.fenixedu.treasury.domain.debt.DebtAccount;

public class DocumentPrinter {
    private static AcademicDocumentPrinterInterface SINGLETON;
    public static final String PDF = "application/pdf";
    public static final String ODT = "application/vnd.oasis.opendocument.text";

    public static void registerPrinterInterface(AcademicDocumentPrinterInterface printer) {
        SINGLETON = printer;
        SINGLETON.init();
    }

    private static <T> T apply(Function<AcademicDocumentPrinterInterface, T> function) {
        return Optional.ofNullable(SINGLETON).map(function).orElseThrow(() -> new RuntimeException("Feature not available"));
    }

    public static byte[] printRegistrationTuititionPaymentPlan(Registration registration, String outputMimeType) {
        return DocumentPrinter.apply(dp -> dp.printRegistrationTuititionPaymentPlan(registration, outputMimeType));
    }

    public static byte[] printRegistrationTuititionPaymentPlan(DebtAccount debtAccount, String outputMimeType) {
        return DocumentPrinter.apply(dp -> dp.printRegistrationTuititionPaymentPlan(debtAccount, outputMimeType));
    }
}

