/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.conditionRule;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionAnnotation;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.CurricularYearConditionRule_Base;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;

@TuitionConditionAnnotation(value="resources.AcademicTreasuryResources")
public class CurricularYearConditionRule
extends CurricularYearConditionRule_Base {
    public static final String BUNDLE_NAME = "resources.AcademicTreasuryResources";

    public boolean containsRule(TuitionConditionRule tuitionConditionRule) {
        if (!(tuitionConditionRule instanceof CurricularYearConditionRule)) {
            return false;
        }
        CurricularYearConditionRule rule = (CurricularYearConditionRule)((Object)tuitionConditionRule);
        return this.getCurricularYearSet().containsAll(rule.getCurricularYearSet());
    }

    public boolean isValidTo(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        return this.getCurricularYearSet().contains(CurricularYear.readByYear((Integer)registration.getCurricularYear(executionYear)));
    }

    public boolean checkRules() {
        if (this.getCurricularYearSet() == null || this.getCurricularYearSet().isEmpty()) {
            throw new DomainException(this.i18n("org.fenixedu.academictreasury.domain.tuition.conditionRule.curricularYearConditionRule.curricularYearSet.cannotBeEmpty", new String[0]), new String[0]);
        }
        return true;
    }

    protected String getBundle() {
        return BUNDLE_NAME;
    }

    public String getDescription() {
        return this.getCurricularYearSet().stream().sorted(CurricularYear.CURRICULAR_YEAR_COMPARATORY_BY_YEAR).map(c -> c.getYear().toString()).collect(Collectors.joining(", "));
    }

    public void delete() {
        this.getCurricularYearSet().clear();
        this.setTuitionPaymentPlan(null);
        this.setTuitionPaymentPlanCalculator(null);
        this.setDomainRoot(null);
        this.deleteDomainObject();
    }

    public TuitionConditionRule duplicate() {
        CurricularYearConditionRule result = new CurricularYearConditionRule();
        this.getCurricularYearSet().forEach(c -> result.addCurricularYear((CurricularYear)c));
        return result;
    }

    public void fillRuleFromImporter(TuitionPaymentPlanBean bean) {
        String[] split;
        String string = bean.getImporterRules().get(((Object)((Object)this)).getClass());
        for (String s : split = string.split("\\|")) {
            CurricularYear readByYear = this.readAllCurricularYearsSet().stream().filter(c -> c.getYear().toString().equals(s)).findFirst().orElse(null);
            if (readByYear == null) {
                throw new AcademicTreasuryDomainException("error.CurricularYearConditionRule.curricularYear.invalid", s);
            }
            this.addCurricularYear(readByYear);
        }
    }

    private Set<CurricularYear> readAllCurricularYearsSet() {
        HashSet<CurricularYear> result = new HashSet<CurricularYear>();
        for (int i = 1; i <= 10; ++i) {
            if (CurricularYear.readByYear((Integer)i) == null) {
                return result;
            }
            result.add(CurricularYear.readByYear((Integer)i));
        }
        return result;
    }
}

