/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import com.google.common.base.Strings;
import com.qubit.terra.framework.tools.excel.ExcelUtil;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.dto.reports.AbstractReportEntryBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.joda.time.DateTime;

public class TreasuryExemptionReportEntryBean
extends AbstractReportEntryBean {
    private String identification;
    private String versioningCreator;
    private DateTime creationDate;
    private String customerId;
    private String debtAccountId;
    private String customerName;
    private String identificationType;
    private String identificationNumber;
    private String vatNumber;
    private Integer studentNumber;
    private Integer registrationNumber;
    private String debitEntryId;
    private String documentNumber;
    private String debitEntryDescription;
    private String exemptedAmount;
    private String exemptionTypeCode;
    private String exemptionTypeDescription;
    private String reason;
    private String degreeType;
    private String degreeCode;
    private String degreeName;
    private String executionYear;
    private String executionSemester;
    private TreasuryExemption treasuryExemption;
    boolean completed = false;

    public static String[] getSpreadsheetHeaders() {
        return new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.versioningCreator", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.debtAccountId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.customerName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.identificationType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.identificationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.registrationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.debitEntryId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.documentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.debitEntryDescription", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.exemptedAmount", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.exemptionType.code", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.exemptionType.description", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.reason", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.degreeType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.degreeCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.degreeName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.executionYear", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.executionSemester", new String[0])};
    }

    public TreasuryExemptionReportEntryBean(TreasuryExemption treasuryExemption, DebtReportRequest request, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        String decimalSeparator = request.getDecimalSeparator();
        try {
            this.treasuryExemption = treasuryExemption;
            this.identification = treasuryExemption.getExternalId();
            this.versioningCreator = treasuryServices.versioningCreatorUsername((Object)treasuryExemption);
            this.creationDate = treasuryServices.versioningCreationDate((Object)treasuryExemption);
            this.customerId = treasuryExemption.getDebitEntry().getDebtAccount().getCustomer().getExternalId();
            this.debtAccountId = treasuryExemption.getDebitEntry().getDebtAccount().getExternalId();
            this.customerName = treasuryExemption.getDebitEntry().getDebtAccount().getCustomer().getName();
            Customer customer = treasuryExemption.getDebitEntry().getDebtAccount().getCustomer();
            if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null && ((PersonCustomer)customer).getAssociatedPerson().getIdDocumentType() != null) {
                this.identificationType = ((PersonCustomer)customer).getAssociatedPerson().getIdDocumentType().getLocalizedName();
            }
            this.identificationNumber = customer.getIdentificationNumber();
            this.vatNumber = customer.getUiFiscalNumber();
            if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null && ((PersonCustomer)customer).getAssociatedPerson().getStudent() != null) {
                this.studentNumber = ((PersonCustomer)customer).getAssociatedPerson().getStudent().getNumber();
            }
            this.debitEntryId = treasuryExemption.getDebitEntry().getExternalId();
            this.debitEntryDescription = treasuryExemption.getDebitEntry().getDescription();
            if (treasuryExemption.getDebitEntry().getFinantialDocument() != null) {
                this.documentNumber = treasuryExemption.getDebitEntry().getFinantialDocument().getUiDocumentNumber();
            }
            this.exemptedAmount = treasuryExemption.getDebitEntry().getCurrency().getValueFor(treasuryExemption.getNetAmountToExempt());
            if (",".equals(decimalSeparator)) {
                this.exemptedAmount = this.exemptedAmount.replace(".", ",");
            }
            this.exemptionTypeCode = treasuryExemption.getTreasuryExemptionType().getCode();
            this.exemptionTypeDescription = treasuryExemption.getTreasuryExemptionType().getName().getContent();
            this.reason = treasuryExemption.getReason();
            this.fillAcademicInformation((InvoiceEntry)treasuryExemption.getDebitEntry());
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(treasuryExemption, e);
        }
    }

    private void fillAcademicInformation(InvoiceEntry entry) {
        DebitEntry debitEntry;
        DebitEntry debitEntry2 = debitEntry = entry.isDebitNoteEntry() ? (DebitEntry)entry : ((CreditEntry)entry).getDebitEntry();
        if (debitEntry != null) {
            if (debitEntry.getTreasuryEvent() != null && debitEntry.getTreasuryEvent() instanceof AcademicTreasuryEvent) {
                AcademicTreasuryEvent academicTreasuryEvent = (AcademicTreasuryEvent)debitEntry.getTreasuryEvent();
                if (academicTreasuryEvent.isForRegistrationTuition()) {
                    this.registrationNumber = academicTreasuryEvent.getRegistration().getNumber();
                    this.degreeType = academicTreasuryEvent.getRegistration().getDegree().getDegreeType().getName().getContent();
                    this.degreeCode = academicTreasuryEvent.getRegistration().getDegree().getCode();
                    this.degreeName = academicTreasuryEvent.getRegistration().getDegree().getPresentationName();
                    this.executionYear = academicTreasuryEvent.getExecutionYear().getQualifiedName();
                } else if (academicTreasuryEvent.isForStandaloneTuition() || academicTreasuryEvent.isForExtracurricularTuition()) {
                    if (debitEntry.getCurricularCourse() != null) {
                        this.degreeType = debitEntry.getCurricularCourse().getDegree().getDegreeType().getName().getContent();
                        this.degreeCode = debitEntry.getCurricularCourse().getDegree().getCode();
                        this.degreeName = debitEntry.getCurricularCourse().getDegree().getPresentationName();
                    }
                    if (debitEntry.getExecutionSemester() != null) {
                        this.executionYear = debitEntry.getExecutionSemester().getExecutionYear().getQualifiedName();
                        this.executionSemester = debitEntry.getExecutionSemester().getQualifiedName();
                    }
                } else if (academicTreasuryEvent.isForImprovementTax()) {
                    if (debitEntry.getCurricularCourse() != null) {
                        this.degreeType = debitEntry.getCurricularCourse().getDegree().getDegreeType().getName().getContent();
                        this.degreeCode = debitEntry.getCurricularCourse().getDegree().getCode();
                        this.degreeName = debitEntry.getCurricularCourse().getDegree().getPresentationName();
                    }
                    if (debitEntry.getExecutionSemester() != null) {
                        this.executionYear = debitEntry.getExecutionSemester().getExecutionYear().getQualifiedName();
                        this.executionSemester = debitEntry.getExecutionSemester().getQualifiedName();
                    }
                } else if (academicTreasuryEvent.isForAcademicTax()) {
                    this.registrationNumber = academicTreasuryEvent.getRegistration().getNumber();
                    this.degreeType = academicTreasuryEvent.getRegistration().getDegree().getDegreeType().getName().getContent();
                    this.degreeCode = academicTreasuryEvent.getRegistration().getDegree().getCode();
                    this.degreeName = academicTreasuryEvent.getRegistration().getDegree().getPresentationName();
                    this.executionYear = academicTreasuryEvent.getExecutionYear().getQualifiedName();
                } else if (academicTreasuryEvent.isForAcademicServiceRequest()) {
                    ITreasuryServiceRequest iTreasuryServiceRequest = academicTreasuryEvent.getITreasuryServiceRequest();
                    this.registrationNumber = iTreasuryServiceRequest.getRegistration().getNumber();
                    this.degreeType = iTreasuryServiceRequest.getRegistration().getDegree().getDegreeType().getName().getContent();
                    this.degreeCode = iTreasuryServiceRequest.getRegistration().getDegree().getCode();
                    this.degreeName = iTreasuryServiceRequest.getRegistration().getDegree().getPresentationName();
                    if (iTreasuryServiceRequest.hasExecutionYear()) {
                        this.executionYear = iTreasuryServiceRequest.getExecutionYear().getQualifiedName();
                    }
                } else if (academicTreasuryEvent.isForTreasuryEventTarget()) {
                    IAcademicTreasuryTarget treasuryEventTarget = (IAcademicTreasuryTarget)academicTreasuryEvent.getTreasuryEventTarget();
                    if (treasuryEventTarget.getAcademicTreasuryTargetRegistration() != null) {
                        this.registrationNumber = treasuryEventTarget.getAcademicTreasuryTargetRegistration().getNumber();
                        this.degreeType = treasuryEventTarget.getAcademicTreasuryTargetRegistration().getDegree().getDegreeType().getName().getContent();
                        this.degreeCode = treasuryEventTarget.getAcademicTreasuryTargetRegistration().getDegree().getCode();
                        this.degreeName = treasuryEventTarget.getAcademicTreasuryTargetRegistration().getDegree().getPresentationName();
                    }
                    if (treasuryEventTarget.getAcademicTreasuryTargetExecutionYear() != null) {
                        this.executionYear = treasuryEventTarget.getAcademicTreasuryTargetExecutionYear().getQualifiedName();
                    }
                    if (treasuryEventTarget.getAcademicTreasuryTargetExecutionSemester() != null) {
                        this.executionSemester = treasuryEventTarget.getAcademicTreasuryTargetExecutionSemester().getQualifiedName();
                    }
                }
            } else if (debitEntry.getTreasuryEvent() != null) {
                TreasuryEvent treasuryEvent = debitEntry.getTreasuryEvent();
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getDegreeCode())) {
                    this.degreeCode = treasuryEvent.getDegreeCode();
                }
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getDegreeName())) {
                    this.degreeName = treasuryEvent.getDegreeName();
                }
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getExecutionYearName())) {
                    this.executionYear = treasuryEvent.getExecutionYearName();
                }
            }
            if (Strings.isNullOrEmpty((String)this.degreeCode)) {
                this.degreeCode = debitEntry.getDegreeCode();
            }
            if (Strings.isNullOrEmpty((String)this.executionYear)) {
                this.executionYear = debitEntry.getExecutionYearName();
            }
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            ExcelUtil.createCellWithValue((Row)row, (int)0, (String)this.identification);
            if (!this.completed) {
                ExcelUtil.createCellWithValue((Row)row, (int)1, (String)AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.versioningCreator));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.creationDate));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.customerId));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.debtAccountId));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.customerName));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.identificationType));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.identificationNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.vatNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.studentNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.registrationNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.debitEntryId));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.documentNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.debitEntryDescription));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.exemptedAmount));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.exemptionTypeCode));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.exemptionTypeDescription));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.reason));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeType));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeCode));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeName));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.executionYear));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.executionSemester));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.treasuryExemption, e);
        }
    }
}

