/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentManager;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanNoCourseGroupEnrolmentManager;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.EmolumentServices;
import org.fenixedu.academictreasury.services.FenixEduAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.services.signals.AcademicServiceRequestCancelOrRejectHandler;
import org.fenixedu.academictreasury.services.signals.ExtracurricularEnrolmentHandler;
import org.fenixedu.academictreasury.services.signals.ImprovementEnrolmentHandler;
import org.fenixedu.academictreasury.services.signals.StandaloneEnrolmentHandler;
import org.fenixedu.bennu.core.signals.Signal;

@WebListener
public class AcademicTreasuryUiInitializer
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public void contextInitialized(ServletContextEvent arg0) {
        AcademicTreasuryPlataformDependentServicesFactory.registerImplementation(new FenixEduAcademicTreasuryPlatformDependentServices());
        AcademicTreasuryUiInitializer.registerNewAcademicServiceRequestSituationHandler();
        AcademicTreasuryUiInitializer.registerAcademicServiceRequestCancelOrRejectHandler();
        AcademicTreasuryUiInitializer.registerStandaloneEnrolmentHandler();
        AcademicTreasuryUiInitializer.registerExtracurricularEnrolmentHandler();
        AcademicTreasuryUiInitializer.registerImprovementEnrolmentHandler();
    }

    private static void registerNewAcademicServiceRequestSituationHandler() {
        Signal.register((String)AcademicServiceRequest.ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT, (Object)new EmolumentServices());
    }

    private static void registerAcademicServiceRequestCancelOrRejectHandler() {
        Signal.register((String)AcademicServiceRequest.ACADEMIC_SERVICE_REQUEST_REJECT_OR_CANCEL_EVENT, (Object)new AcademicServiceRequestCancelOrRejectHandler());
    }

    private static void registerStandaloneEnrolmentHandler() {
        Signal.register((String)StudentCurricularPlanNoCourseGroupEnrolmentManager.STANDALONE_ENROLMENT, (Object)new StandaloneEnrolmentHandler());
    }

    private static void registerExtracurricularEnrolmentHandler() {
        Signal.register((String)StudentCurricularPlanNoCourseGroupEnrolmentManager.EXTRACURRICULAR_ENROLMENT, (Object)new ExtracurricularEnrolmentHandler());
    }

    private static void registerImprovementEnrolmentHandler() {
        Signal.register((String)StudentCurricularPlanEnrolmentManager.IMPROVEMENT_ENROLMENT, (Object)new ImprovementEnrolmentHandler());
    }
}

