/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.joda.time.LocalDate;

@Deprecated
public class FenixEduAcademicTreasuryPlatformDependentServices
implements IAcademicTreasuryPlatformDependentServices {
    @Override
    public Set<DegreeType> readAllDegreeTypes() {
        return DegreeType.all().collect(Collectors.toSet());
    }

    @Override
    public Set<DegreeCurricularPlan> readAllDegreeCurricularPlansSet() {
        return Degree.readAllMatching(dt -> true).stream().flatMap(d -> d.getDegreeCurricularPlansSet().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<DegreeCurricularPlan> readDegreeCurricularPlansWithExecutionDegree(ExecutionYear executionYear, DegreeType degreeType) {
        return ExecutionDegree.getAllByExecutionYearAndDegreeType((ExecutionYear)executionYear, (DegreeType[])new DegreeType[]{degreeType}).stream().map(e -> e.getDegreeCurricularPlan()).collect(Collectors.toSet());
    }

    @Override
    public Set<CurricularYear> readAllCurricularYearsSet() {
        HashSet<CurricularYear> result = new HashSet<CurricularYear>();
        for (int i = 1; i <= 10; ++i) {
            if (CurricularYear.readByYear((Integer)i) == null) {
                return result;
            }
            result.add(CurricularYear.readByYear((Integer)i));
        }
        return result;
    }

    @Override
    public Set<IngressionType> readAllIngressionTypesSet() {
        return IngressionType.findAllByPredicate(i -> true).collect(Collectors.toSet());
    }

    @Override
    public Set<RegistrationProtocol> readAllRegistrationProtocol() {
        return RegistrationProtocol.findByPredicate(p -> true).collect(Collectors.toSet());
    }

    @Override
    public Set<StatuteType> readAllStatuteTypesSet() {
        return StatuteType.readAll((Predicate[])new Predicate[]{s -> true}).collect(Collectors.toSet());
    }

    @Override
    public Set<StatuteType> readAllStatuteTypesSet(boolean active) {
        return this.readAllStatuteTypesSet().stream().filter(s -> s.getActive() == active).collect(Collectors.toSet());
    }

    @Override
    public Set<Registration> readAllRegistrations(RegistrationProtocol registrationProtocol) {
        return registrationProtocol.getRegistrationsSet();
    }

    @Override
    public Set<Registration> readAllRegistrations(IngressionType ingressionType) {
        return ingressionType.getRegistrationSet();
    }

    @Override
    public Set<Person> readAllPersonsSet() {
        return Person.readAllPersons();
    }

    @Override
    public PersonCustomer personCustomer(Person person) {
        return person.getPersonCustomer();
    }

    @Override
    public Set<PersonCustomer> inactivePersonCustomers(Person person) {
        return person.getInactivePersonCustomersSet();
    }

    @Override
    public PhysicalAddress fiscalAddress(Person person) {
        return person.getFiscalAddress();
    }

    @Override
    public String iban(Person person) {
        return person.getIban();
    }

    @Override
    public Set<AcademicTreasuryEvent> academicTreasuryEventsSet(Person person) {
        return person.getAcademicTreasuryEventSet();
    }

    @Override
    public String defaultPhoneNumber(Person person) {
        return person.getDefaultPhoneNumber();
    }

    @Override
    public String defaultMobilePhoneNumber(Person person) {
        return person.getDefaultMobilePhoneNumber();
    }

    @Override
    public List<PhysicalAddress> pendingOrValidPhysicalAddresses(Person person) {
        Comparator comparator = (o1, o2) -> {
            if (o1.isValid() && !o2.isValid()) {
                return -1;
            }
            if (!o1.isValid() && o2.isValid()) {
                return 1;
            }
            return 10 * PhysicalAddress.COMPARATOR_BY_ADDRESS.compare(o1, o2) + o1.getExternalId().compareTo(o2.getExternalId());
        };
        return person.getAllPartyContacts(PhysicalAddress.class).stream().map(PhysicalAddress.class::cast).filter(pc -> pc.isValid()).sorted(comparator).collect(Collectors.toList());
    }

    @Override
    public List<? extends PartyContact> pendingOrValidPartyContacts(Person person, Class<? extends PartyContact> partyContactType) {
        Comparator comparator = (o1, o2) -> {
            if (o1.isValid() && !o2.isValid()) {
                return -1;
            }
            if (!o1.isValid() && o2.isValid()) {
                return 1;
            }
            return o1.getExternalId().compareTo(o2.getExternalId());
        };
        return person.getAllPartyContacts(partyContactType).stream().sorted(comparator).collect(Collectors.toList());
    }

    @Override
    public void editSocialSecurityNumber(Person person, String fiscalNumber, PhysicalAddress fiscalAddress) {
        person.editSocialSecurityNumber(fiscalNumber, fiscalAddress);
    }

    @Override
    public void setFiscalAddress(PhysicalAddress physicalAddress, boolean fiscalAddress) {
        physicalAddress.setFiscalAddress(fiscalAddress);
    }

    @Override
    public PhysicalAddress createPhysicalAddress(Person person, Country countryOfResidence, String districtOfResidence, String districtSubdivisionOfResidence, String areaCode, String address) {
        PhysicalAddressData data = new PhysicalAddressData();
        data.setAddress(address);
        data.setCountryOfResidence(countryOfResidence);
        data.setDistrictOfResidence(districtOfResidence);
        data.setDistrictSubdivisionOfResidence(districtSubdivisionOfResidence);
        data.setAreaCode(areaCode);
        PhysicalAddress physicalAddress = PhysicalAddress.createPhysicalAddress((Party)person, (PhysicalAddressData)data, (PartyContactType)PartyContactType.PERSONAL, (Boolean)false);
        physicalAddress.setValid();
        return physicalAddress;
    }

    @Override
    public String fiscalCountry(Person person) {
        return person.getFiscalAddress() != null && person.getFiscalAddress().getCountryOfResidence() != null ? person.getFiscalAddress().getCountryOfResidence().getCode() : null;
    }

    @Override
    public String fiscalNumber(Person person) {
        return person.getSocialSecurityNumber();
    }

    @Override
    @Deprecated
    public boolean isFrontOfficeMember(String username, FinantialEntity finantialEntity) {
        throw new RuntimeException("deprecated");
    }

    @Override
    @Deprecated
    public boolean isBackOfficeMember(String username, FinantialEntity finantialEntity) {
        throw new RuntimeException("deprecated");
    }

    @Override
    @Deprecated
    public boolean isAllowToModifySettlements(String username, FinantialEntity finantialEntity) {
        throw new RuntimeException("deprecated");
    }

    @Override
    @Deprecated
    public boolean isAllowToModifyInvoices(String username, FinantialEntity finantialEntity) {
        throw new RuntimeException("deprecated");
    }

    @Override
    public Set<Degree> readDegrees(FinantialEntity finantialEntity) {
        if (finantialEntity.getUnit() != null) {
            return finantialEntity.getUnit().getAllSubUnits().stream().filter(u -> u.isDegreeUnit()).filter(u -> u.getDegree() != null).map(u -> u.getDegree()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public FinantialEntity finantialEntityOfDegree(Degree degree, LocalDate when) {
        Unit degreeUnit = degree.getUnit();
        if (degreeUnit == null) {
            return null;
        }
        List candidateFinantialEntities = degreeUnit.getAllParentUnits().stream().map(parent -> parent.getFinantialEntity()).filter(Objects::nonNull).sorted(FinantialEntity.COMPARE_BY_NAME).collect(Collectors.toList());
        if (candidateFinantialEntities.size() == 1) {
            return (FinantialEntity)candidateFinantialEntities.iterator().next();
        }
        if (candidateFinantialEntities.size() > 1) {
            return (FinantialEntity)candidateFinantialEntities.iterator().next();
        }
        return null;
    }

    @Override
    public Optional<FinantialEntity> finantialEntity(Unit unit) {
        return Optional.ofNullable(unit.getFinantialEntity());
    }

    @Override
    @Deprecated
    public Set<String> getFrontOfficeMemberUsernames(FinantialEntity finantialEntity) {
        throw new RuntimeException("deprecated");
    }

    @Override
    @Deprecated
    public Set<String> getBackOfficeMemberUsernames(FinantialEntity finantialEntity) {
        throw new RuntimeException("deprecated");
    }

    @Override
    public String localizedNameOfDegreeType(DegreeType degreeType) {
        return degreeType.getName().getContent();
    }

    @Override
    public String localizedNameOfDegreeType(DegreeType degreeType, Locale locale) {
        return degreeType.getName().getContent(locale);
    }

    @Override
    public String localizedNameOfStatuteType(StatuteType statuteType) {
        return statuteType.getName().getContent();
    }

    @Override
    public String localizedNameOfStatuteType(StatuteType statuteType, Locale locale) {
        return statuteType.getName().getContent(locale);
    }

    @Override
    public String localizedNameOfEnrolment(Enrolment enrolment) {
        return this.localizedNameOfEnrolment(enrolment, I18N.getLocale());
    }

    @Override
    public String localizedNameOfEnrolment(Enrolment enrolment, Locale locale) {
        return enrolment.getName().getContent(locale);
    }

    @Override
    public RegistrationDataByExecutionYear findRegistrationDataByExecutionYear(Registration registration, ExecutionYear executionYear) {
        return registration.getRegistrationDataByExecutionYearSet().stream().filter(rd -> rd.getExecutionYear() == executionYear).findAny().orElse(null);
    }

    @Override
    public IngressionType ingression(Registration registration) {
        return registration.getIngressionType();
    }

    @Override
    public RegistrationProtocol registrationProtocol(Registration registration) {
        return registration.getRegistrationProtocol();
    }

    @Override
    public RegistrationRegimeType registrationRegimeType(Registration registration, ExecutionYear executionYear) {
        return registration.getRegimeType(executionYear);
    }

    @Override
    public Set<StatuteType> statutesTypesValidOnAnyExecutionSemesterFor(Registration registration, ExecutionInterval executionInterval) {
        return Sets.newHashSet(FenixEduAcademicTreasuryPlatformDependentServices.findStatuteTypes(registration, executionInterval));
    }

    public static Collection<StatuteType> findStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        if (executionInterval instanceof ExecutionYear) {
            return FenixEduAcademicTreasuryPlatformDependentServices.findStatuteTypesByYear(registration, (ExecutionYear)executionInterval);
        }
        return FenixEduAcademicTreasuryPlatformDependentServices.findStatuteTypesByChildInterval(registration, executionInterval);
    }

    private static Collection<StatuteType> findStatuteTypesByYear(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        for (ExecutionInterval executionInterval : executionYear.getExecutionPeriodsSet()) {
            result.addAll(FenixEduAcademicTreasuryPlatformDependentServices.findStatuteTypesByChildInterval(registration, executionInterval));
        }
        return result;
    }

    private static Collection<StatuteType> findStatuteTypesByChildInterval(Registration registration, ExecutionInterval executionInterval) {
        return registration.getStudent().getStudentStatutesSet().stream().filter(s -> s.isValidInExecutionInterval(executionInterval) && (s.getRegistration() == null || s.getRegistration() == registration)).map(s -> s.getType()).collect(Collectors.toSet());
    }

    public static String getVisibleStatuteTypesDescription(Registration registration, ExecutionInterval executionInterval) {
        return FenixEduAcademicTreasuryPlatformDependentServices.findVisibleStatuteTypes(registration, executionInterval).stream().map(s -> s.getName().getContent()).distinct().collect(Collectors.joining(", "));
    }

    public static Collection<StatuteType> findVisibleStatuteTypes(Registration registration, ExecutionInterval executionInterval) {
        return FenixEduAcademicTreasuryPlatformDependentServices.findStatuteTypes(registration, executionInterval).stream().filter(s -> s.getVisible()).collect(Collectors.toSet());
    }

    @Override
    public ExecutionInterval executionSemester(Enrolment enrolment) {
        return enrolment.getExecutionInterval();
    }

    @Override
    public ExecutionInterval executionSemester(EnrolmentEvaluation enrolmentEvaluation) {
        return enrolmentEvaluation.getExecutionInterval();
    }

    @Override
    public ExecutionYear executionYearOfExecutionSemester(ExecutionInterval executionInterval) {
        return executionInterval.getExecutionYear();
    }

    @Override
    public Integer executionIntervalChildOrder(ExecutionInterval executionInterval) {
        return executionInterval.getChildOrder();
    }

    @Override
    public ExecutionInterval getExecutionIntervalByName(String s) {
        return ExecutionInterval.getExecutionInterval((String)s);
    }
}

