/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.coursefunctioncost;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;

public class CourseFunctionCostBean
implements ITreasuryBean {
    private CompetenceCourse competenceCourses;
    private DegreeCurricularPlan degreeCurricularPlan;
    private ExecutionYear executionYear;
    private BigDecimal functionCost;
    private List<TreasuryTupleDataSourceBean> executionYearDataSource;
    private List<TreasuryTupleDataSourceBean> degreeCurricularPlanDataSource;
    private List<TreasuryTupleDataSourceBean> competenceCoursesDataSource;

    public CourseFunctionCostBean() {
        this.updateData();
    }

    public void updateData() {
        this.executionYearDataSource = ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).collect(Collectors.toList()).stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getQualifiedName())).collect(Collectors.toList());
        if (this.executionYear == null) {
            this.degreeCurricularPlanDataSource = Lists.newArrayList();
            this.competenceCoursesDataSource = Lists.newArrayList();
            return;
        }
        List result = ExecutionDegree.getAllByExecutionYear((ExecutionYear)this.getExecutionYear()).stream().map(e -> e.getDegreeCurricularPlan()).map(dcp -> new TreasuryTupleDataSourceBean(dcp.getExternalId(), dcp.getPresentationName(this.getExecutionYear()))).collect(Collectors.toList());
        this.degreeCurricularPlanDataSource = result.stream().sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        if (this.degreeCurricularPlan == null) {
            this.competenceCoursesDataSource = Lists.newArrayList();
            return;
        }
        this.competenceCoursesDataSource = this.degreeCurricularPlan.getCompetenceCourses().stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getNameI18N().getContent())).sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
    }

    public CompetenceCourse getCompetenceCourses() {
        return this.competenceCourses;
    }

    public void setCompetenceCourses(CompetenceCourse value) {
        this.competenceCourses = value;
    }

    public List<TreasuryTupleDataSourceBean> getCompetenceCoursesDataSource() {
        return this.competenceCoursesDataSource;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan;
    }

    public void setDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        this.degreeCurricularPlan = degreeCurricularPlan;
    }

    public List<TreasuryTupleDataSourceBean> getDegreeCurricularPlanDataSource() {
        return this.degreeCurricularPlanDataSource;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear value) {
        this.executionYear = value;
    }

    public List<TreasuryTupleDataSourceBean> getExecutionYearDataSource() {
        return this.executionYearDataSource;
    }

    public BigDecimal getFunctionCost() {
        return this.functionCost;
    }

    public void setFunctionCost(BigDecimal value) {
        this.functionCost = value;
    }
}

