/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.tuition;

import java.math.BigDecimal;
import org.fenixedu.treasury.util.TreasuryConstants;

class TreasuryExemptionMoneyBox {
    BigDecimal maximumNetAmountForExemption;
    BigDecimal availableNetAmountForExemption;

    TreasuryExemptionMoneyBox(BigDecimal maximumNetAmountForExemption, BigDecimal availableNetAmountForExemption) {
        this.maximumNetAmountForExemption = maximumNetAmountForExemption;
        this.availableNetAmountForExemption = availableNetAmountForExemption;
    }

    void addToAvailableNetAmountForExemption(BigDecimal netAmount) {
        this.availableNetAmountForExemption = this.availableNetAmountForExemption.add(netAmount);
        this.availableNetAmountForExemption = this.availableNetAmountForExemption.min(this.maximumNetAmountForExemption);
    }

    void subtractFromCurrentNetAmount(BigDecimal netAmount) {
        this.availableNetAmountForExemption = this.availableNetAmountForExemption.subtract(netAmount);
        this.availableNetAmountForExemption = this.availableNetAmountForExemption.max(BigDecimal.ZERO);
    }

    TreasuryExemptionMoneyBox mergeBySumming(TreasuryExemptionMoneyBox o) {
        return new TreasuryExemptionMoneyBox(this.maximumNetAmountForExemption.add(o.maximumNetAmountForExemption), this.availableNetAmountForExemption.add(o.availableNetAmountForExemption));
    }

    TreasuryExemptionMoneyBox mergeByChoosingTheGreaterMaximumAmount(TreasuryExemptionMoneyBox o) {
        if (TreasuryConstants.isGreaterOrEqualThan((BigDecimal)o.maximumNetAmountForExemption, (BigDecimal)this.maximumNetAmountForExemption)) {
            return o;
        }
        return this;
    }

    boolean isAvailableNetAmountForExemptionPositive() {
        return TreasuryConstants.isPositive((BigDecimal)this.availableNetAmountForExemption);
    }

    static TreasuryExemptionMoneyBox zero() {
        return new TreasuryExemptionMoneyBox(BigDecimal.ZERO, BigDecimal.ZERO);
    }
}

