/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import com.qubit.terra.framework.tools.excel.ExcelUtil;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.AbstractReportEntryBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentCodeTransaction;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.joda.time.DateTime;

public class SibsTransactionDetailEntryBean
extends AbstractReportEntryBean {
    private String identification;
    private String versioningCreator;
    private DateTime creationDate;
    private DateTime whenProcessed;
    private DateTime whenRegistered;
    private String amountPayed;
    private String sibsEntityReferenceCode;
    private String sibsPaymentReferenceCode;
    private String sibsTransactionId;
    private String debtAccountId;
    private String customerId;
    private String businessIdentification;
    private String fiscalNumber;
    private String customerName;
    private String settlementDocumentNumber;
    private String comments;
    private SibsPaymentCodeTransaction sibsTransactionDetail;
    boolean completed = false;

    public static String[] getSpreadsheetHeaders() {
        return new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.versioningCreator", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.whenProcessed", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.whenRegistered", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.amountPayed", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.sibsEntityReferenceCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.sibsPaymentReferenceCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.sibsTransactionId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.debtAccountId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.businessIdentification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.fiscalNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.customerName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.settlementDocumentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.comments", new String[0])};
    }

    public SibsTransactionDetailEntryBean(SibsPaymentCodeTransaction detail, DebtReportRequest request, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        String decimalSeparator = request.getDecimalSeparator();
        try {
            this.sibsTransactionDetail = detail;
            this.identification = detail.getExternalId();
            this.versioningCreator = treasuryServices.versioningCreatorUsername((Object)detail);
            this.creationDate = treasuryServices.versioningCreationDate((Object)detail);
            this.whenProcessed = detail.getSibsProcessingDate();
            this.whenRegistered = detail.getPaymentDate();
            this.amountPayed = detail.getPaidAmount() != null ? detail.getPaidAmount().toString() : "";
            this.sibsEntityReferenceCode = detail.getSibsEntityReferenceCode();
            this.sibsPaymentReferenceCode = detail.getSibsPaymentReferenceCode();
            this.sibsTransactionId = detail.getSibsTransactionId();
            this.debtAccountId = detail.getPaymentRequest().getDebtAccount().getExternalId();
            this.customerId = detail.getPaymentRequest().getDebtAccount().getCustomer().getExternalId();
            this.businessIdentification = detail.getPaymentRequest().getDebtAccount().getCustomer().getBusinessIdentification();
            this.fiscalNumber = detail.getPaymentRequest().getDebtAccount().getCustomer().getUiFiscalNumber();
            this.customerName = detail.getPaymentRequest().getDebtAccount().getCustomer().getName();
            this.settlementDocumentNumber = String.join((CharSequence)",", detail.getSettlementNotesSet().stream().map(s -> s.getUiDocumentNumber()).collect(Collectors.toSet()));
            this.comments = detail.getComments();
            if (",".equals(decimalSeparator)) {
                this.amountPayed = this.amountPayed.replace(".", ",");
            }
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.sibsTransactionDetail, e);
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            ExcelUtil.createCellWithValue((Row)row, (int)0, (String)this.identification);
            if (!this.completed) {
                ExcelUtil.createCellWithValue((Row)row, (int)1, (String)AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.versioningCreator));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.creationDate));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.whenProcessed));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.whenRegistered));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.amountPayed));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.sibsEntityReferenceCode));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.sibsPaymentReferenceCode));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.sibsTransactionId));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.debtAccountId));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.customerId));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.businessIdentification));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.fiscalNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.customerName));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.settlementDocumentNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.comments));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.sibsTransactionDetail, e);
        }
    }
}

