/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reports;

import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequestResultErrorsFile_Base;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

public class DebtReportRequestResultErrorsFile
extends DebtReportRequestResultErrorsFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "text/plain";

    public DebtReportRequestResultErrorsFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    protected DebtReportRequestResultErrorsFile(DebtReportRequest request, byte[] content) {
        this();
        this.setDebtReportRequest(request);
        String filename = AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequestResultErrorsFile.filename", new DateTime().toString("YYYYMMddHHmmss"));
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        services.createFile((IGenericFile)this, filename, CONTENT_TYPE, content);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDebtReportRequest() == null) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequestResultErrorsFile.debtReportRequest.required", new String[0]);
        }
    }

    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember((String)username);
    }

    public void delete() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        this.setDomainRoot(null);
        this.setDebtReportRequest(null);
        services.deleteFile((IGenericFile)this);
        super.deleteDomainObject();
    }

    public static DebtReportRequestResultErrorsFile create(DebtReportRequest request, byte[] content) {
        return new DebtReportRequestResultErrorsFile(request, content);
    }

    public static Stream<DebtReportRequestResultErrorsFile> findAll() {
        return FenixFramework.getDomainRoot().getDebtReportRequestResultErrorsFilesSet().stream();
    }
}

