/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.strategies;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationProcessingResult;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry;
import org.fenixedu.academictreasury.domain.debtGeneration.IAcademicDebtGenerationRuleStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreatePaymentReferencesStrategy$callable$process;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreatePaymentReferencesStrategy$callable$process$1;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.ProductGroup;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreatePaymentReferencesStrategy
implements IAcademicDebtGenerationRuleStrategy {
    private static Logger logger;
    private static final List<String> MESSAGES_TO_IGNORE;
    public static final Advice advice$process;
    public static final Advice advice$process$1;

    @Override
    public boolean isAppliedOnTuitionDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnAcademicTaxDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnOtherDebitEntries() {
        return true;
    }

    @Override
    public boolean isToCreateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToAggregateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToCloseDebitNote() {
        return false;
    }

    @Override
    public boolean isToCreatePaymentReferenceCodes() {
        return true;
    }

    @Override
    public boolean isEntriesRequired() {
        return true;
    }

    @Override
    public boolean isToAlignAcademicTaxesDueDate() {
        return true;
    }

    @Override
    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule academicDebtGenerationRule) {
        return (List)advice$process.perform((Callable)new CreatePaymentReferencesStrategy$callable$process(this, academicDebtGenerationRule));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$process(CreatePaymentReferencesStrategy this_, AcademicDebtGenerationRule rule) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        ArrayList resultList = Lists.newArrayList();
        for (DegreeCurricularPlan degreeCurricularPlan : rule.getDegreeCurricularPlansSet()) {
            for (Registration registration : degreeCurricularPlan.getRegistrations()) {
                if (registration.getStudentCurricularPlan(rule.getExecutionYear()) == null || !rule.getDegreeCurricularPlansSet().contains(registration.getStudentCurricularPlan(rule.getExecutionYear()).getDegreeCurricularPlan())) continue;
                AcademicDebtGenerationProcessingResult result = new AcademicDebtGenerationProcessingResult(rule, registration);
                resultList.add(result);
                try {
                    this_.processDebtsForRegistration(rule, registration);
                    result.markProcessingEndDateTime();
                }
                catch (AcademicTreasuryDomainException e) {
                    result.markException(e);
                    if (MESSAGES_TO_IGNORE.contains(e.getMessage())) continue;
                    logger.debug(e.getMessage());
                }
                catch (TreasuryDomainException e) {
                    result.markException((Exception)((Object)e));
                    logger.debug(e.getMessage());
                }
                catch (Exception e) {
                    result.markException(e);
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }

    @Override
    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        return (List)advice$process$1.perform((Callable)new CreatePaymentReferencesStrategy$callable$process$1(this, academicDebtGenerationRule, registration));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$process(CreatePaymentReferencesStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        AcademicDebtGenerationProcessingResult result = new AcademicDebtGenerationProcessingResult(rule, registration);
        try {
            if (!rule.isRuleToApply(registration)) {
                return Lists.newArrayList();
            }
            if (registration.getStudentCurricularPlan(rule.getExecutionYear()) == null) {
                return Lists.newArrayList();
            }
            if (!rule.getDegreeCurricularPlansSet().contains(registration.getStudentCurricularPlan(rule.getExecutionYear()).getDegreeCurricularPlan())) {
                return Lists.newArrayList();
            }
            this_.processDebtsForRegistration(rule, registration);
            result.markProcessingEndDateTime();
        }
        catch (AcademicTreasuryDomainException e) {
            result.markException(e);
            if (!MESSAGES_TO_IGNORE.contains(e.getMessage())) {
                logger.info(e.getMessage());
            }
        }
        catch (TreasuryDomainException e) {
            result.markException((Exception)((Object)e));
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            result.markException(e);
            e.printStackTrace();
        }
        return Lists.newArrayList((Object[])new AcademicDebtGenerationProcessingResult[]{result});
    }

    private void processDebtsForRegistration(AcademicDebtGenerationRule rule, Registration registration) {
        if (!rule.isRuleToApply(registration)) {
            return;
        }
        Set<DebitEntry> debitEntries = CreatePaymentReferencesStrategy.grabDebitEntries(rule, registration);
        if (!this.isGrabbedDebitEntriesMatchAllProductsReferencedInRule(rule, debitEntries)) {
            return;
        }
        if (debitEntries.stream().filter(d -> d.getFinantialDocument() == null || d.getFinantialDocument().isAnnulled()).count() > 0L) {
            DebitEntry debitEntryWithoutDebitNote = (DebitEntry)debitEntries.stream().filter(d -> d.getFinantialDocument() == null || d.getFinantialDocument().isAnnulled()).iterator().next();
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debitEntry.with.none.or.annuled.finantial.document", debitEntryWithoutDebitNote.getDescription());
        }
        if (SibsPaymentRequest.findRequestedByDebitEntriesSet(debitEntries).count() > 0L || SibsPaymentRequest.findCreatedByDebitEntriesSet(debitEntries).count() > 0L) {
            return;
        }
        if (this.referencedCustomers(debitEntries).size() > 1) {
            throw new AcademicTreasuryDomainException("error.CreatePaymentReferencesStrategy.more.than.one.referenced.customers", new String[0]);
        }
        BigDecimal amount = debitEntries.stream().map(d -> d.getOpenAmount()).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
        if (rule.isAppliedMinimumAmountForPaymentCode() && TreasuryConstants.isLessThan((BigDecimal)amount, (BigDecimal)rule.getMinimumAmountForPaymentCode())) {
            throw new AcademicTreasuryDomainException("error.CreatePaymentReferencesStrategy.amount.is.less.than.minimumAmountForPaymentCode", new String[0]);
        }
        DebtAccount debtAccount = debitEntries.iterator().next().getDebtAccount();
        ISibsPaymentCodePoolService.getDefaultDigitalPaymentPlatform((FinantialEntity)rule.getFinantialEntity()).createSibsPaymentRequest(debtAccount, debitEntries, Collections.emptySet());
        if (rule.getAcademicTaxDueDateAlignmentType() != null) {
            FenixFramework.atomic(() -> rule.getAcademicTaxDueDateAlignmentType().applyDueDate(rule, debitEntries));
        }
    }

    private Set<Customer> referencedCustomers(Set<DebitEntry> debitEntries) {
        return debitEntries.stream().map(DebitEntry::getDebitNote).map(d -> d.getPayorDebtAccount() != null ? d.getPayorDebtAccount().getCustomer() : d.getDebtAccount().getCustomer()).collect(Collectors.toSet());
    }

    private boolean isGrabbedDebitEntriesMatchAllProductsReferencedInRule(AcademicDebtGenerationRule rule, Set<DebitEntry> grabbedDebitEntries) {
        Set productsFromRuleSet = rule.getAcademicDebtGenerationRuleEntriesSet().stream().map(e -> e.getProduct()).collect(Collectors.toSet());
        Set productsFromGrabbedDebitEntries = grabbedDebitEntries.stream().map(d -> d.getProduct()).collect(Collectors.toSet());
        return Sets.difference(productsFromRuleSet, productsFromGrabbedDebitEntries).isEmpty();
    }

    public static Set<DebitEntry> grabDebitEntries(AcademicDebtGenerationRule rule, Registration registration) {
        HashSet debitEntries = Sets.newHashSet();
        AcademicTreasurySettings academicTreasurySettings = AcademicTreasurySettings.getInstance();
        ProductGroup tuitionProductGroup = academicTreasurySettings.getTuitionProductGroup();
        for (AcademicDebtGenerationRuleEntry entry : rule.getAcademicDebtGenerationRuleEntriesSet()) {
            Product product = entry.getProduct();
            if (tuitionProductGroup == product.getProductGroup()) {
                Optional<TuitionPaymentPlanGroup> groupForExtracurricular = TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular();
                Optional<TuitionPaymentPlanGroup> groupForStandalone = TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone();
                if (groupForExtracurricular.isPresent() && groupForExtracurricular.get().getCurrentProduct() == product) {
                    debitEntries.addAll(CreatePaymentReferencesStrategy.grabDebitEntriesForNonCurricularGroupGroupTuition(rule, registration, entry, groupForExtracurricular.get()));
                    continue;
                }
                if (groupForStandalone.isPresent() && groupForStandalone.get().getCurrentProduct() == product) {
                    debitEntries.addAll(CreatePaymentReferencesStrategy.grabDebitEntriesForNonCurricularGroupGroupTuition(rule, registration, entry, groupForStandalone.get()));
                    continue;
                }
                DebitEntry grabbedDebitEntry = CreatePaymentReferencesStrategy.grabDebitEntryForRegistrationTuition(rule, registration, entry);
                if (grabbedDebitEntry == null) continue;
                debitEntries.add(grabbedDebitEntry);
                continue;
            }
            if (AcademicTax.findUnique(product).isPresent()) {
                DebitEntry grabbedDebitEntry = CreatePaymentReferencesStrategy.grabDebitEntryForAcademicTax(rule, registration, entry);
                if (grabbedDebitEntry == null) continue;
                debitEntries.add(grabbedDebitEntry);
                continue;
            }
            if (entry.getProduct() != TreasurySettings.getInstance().getInterestProduct()) continue;
            debitEntries.addAll(CreatePaymentReferencesStrategy.grabInterestDebitEntries(rule, registration, entry));
        }
        return debitEntries.stream().filter(de -> !TreasuryDebtProcessMainService.isBlockingPaymentInFrontend((InvoiceEntry)de)).collect(Collectors.toSet());
    }

    private static Collection<? extends DebitEntry> grabDebitEntriesForNonCurricularGroupGroupTuition(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry, TuitionPaymentPlanGroup tuitionPaymentPlanGroup) {
        PersonCustomer customer = registration.getPerson().getPersonCustomer();
        if (customer == null) {
            return null;
        }
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = null;
        if (tuitionPaymentPlanGroup.isForExtracurricular()) {
            t = TuitionServices.findAcademicTreasuryEventTuitionForExtracurricular(registration, executionYear);
        } else if (tuitionPaymentPlanGroup.isForStandalone()) {
            t = TuitionServices.findAcademicTreasuryEventTuitionForStandalone(registration, executionYear);
        }
        if (t == null) {
            return Collections.emptySet();
        }
        return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t, product).filter(d -> d.isInDebt()).filter(d -> SibsPaymentRequest.findCreatedByDebitEntry((DebitEntry)d).count() == 0L && SibsPaymentRequest.findRequestedByDebitEntry((DebitEntry)d).count() == 0L).collect(Collectors.toSet());
    }

    private static DebitEntry grabDebitEntryForAcademicTax(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        AcademicTax academicTax;
        PersonCustomer customer = registration.getPerson().getPersonCustomer();
        if (customer == null) {
            return null;
        }
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax = AcademicTax.findUnique(product).get());
        if (t != null && t.isChargedWithDebitEntry()) {
            return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t).filter(d -> d.isInDebt()).findFirst().orElse(null);
        }
        return null;
    }

    private static DebitEntry grabDebitEntryForRegistrationTuition(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        PersonCustomer customer = registration.getPerson().getPersonCustomer();
        if (customer == null) {
            return null;
        }
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        if (TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear) == null) {
            return null;
        }
        AcademicTreasuryEvent t = TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear);
        if (!t.isChargedWithDebitEntry(product)) {
            return null;
        }
        return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t, product).filter(d -> d.isInDebt()).findFirst().orElse(null);
    }

    private static Set<DebitEntry> grabInterestDebitEntries(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        if (AcademicTreasurySettings.getInstance().getTuitionProductGroup() == entry.getProduct().getProductGroup()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.entry.is.tuition", new String[0]);
        }
        if (AcademicTax.findUnique(entry.getProduct()).isPresent()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.entry.is.academicTax", new String[0]);
        }
        FinantialEntity finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(registration.getDegree(), new LocalDate());
        if (finantialEntity == null) {
            return Collections.emptySet();
        }
        PersonCustomer personCustomer = registration.getPerson().getPersonCustomer();
        if (personCustomer == null) {
            return Collections.emptySet();
        }
        if (!DebtAccount.findUnique((FinantialInstitution)finantialEntity.getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
            return Collections.emptySet();
        }
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialEntity.getFinantialInstitution(), (Customer)personCustomer).get();
        HashSet<DebitEntry> result = new HashSet<DebitEntry>();
        for (DebitEntry debitEntry : DebitEntry.findActive((DebtAccount)debtAccount, (Product)entry.getProduct()).collect(Collectors.toSet())) {
            if (!debitEntry.isInDebt() || debitEntry.isAnnulled() || SibsPaymentRequest.findRequestedByDebitEntry((DebitEntry)debitEntry).count() > 0L || SibsPaymentRequest.findCreatedByDebitEntry((DebitEntry)debitEntry).count() > 0L) continue;
            result.add(debitEntry);
        }
        return result;
    }

    static {
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$process$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        logger = LoggerFactory.getLogger(CreatePaymentReferencesStrategy.class);
        MESSAGES_TO_IGNORE = Lists.newArrayList((Object[])new String[]{"error.AcademicDebtGenerationRule.debitEntry.with.none.or.annuled.finantial.document"});
    }
}

