/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.personcustomer;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.EnrolmentTest;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academictreasury.base.FenixFrameworkRunner;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.tuition.TuitionPaymentPlanTestsUtilities;
import org.fenixedu.academictreasury.util.AcademicTreasuryBootstrapper;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.CustomerType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;

@RunWith(value=FenixFrameworkRunner.class)
public class TestPersonCustomerFindUnique {
    @BeforeClass
    public static void init() {
        try {
            FenixFramework.getTransactionManager().withTransaction(() -> {
                new Country(new LocalizedString(new Locale("pt"), "Portugal"), new LocalizedString(new Locale("pt"), "Portugal"), "PT", "PRT");
                EnrolmentTest.initEnrolments();
                TuitionPaymentPlanTestsUtilities.startUp();
                AcademicTreasuryBootstrapper.bootstrap();
                TestPersonCustomerFindUnique.createVariousPersonCustomers();
                return null;
            }, (Atomic)new AtomicInstance(Atomic.TxMode.WRITE, true));
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static void createVariousPersonCustomers() {
        Person person = Student.readStudentByNumber((Integer)1).getPerson();
        PhysicalAddress physicalAddress = TestPersonCustomerFindUnique.createDefaultPhysicalAddress(person);
        person.editSocialSecurityNumber("504024850", physicalAddress);
        person.editSocialSecurityNumber("999999990", physicalAddress);
        person.editSocialSecurityNumber("123456789", physicalAddress);
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "999999990");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "999999990");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "999999990");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "504024850");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "504024850");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "504024850");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "504024850");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "123456789");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "123456789");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "123456789");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "507113810");
        TestPersonCustomerFindUnique.createInactivePersonCustomer(person, physicalAddress, "507113810");
    }

    public static PersonCustomer createInactivePersonCustomer(Person person, PhysicalAddress fiscalAddress, String fiscalNumber) {
        PersonCustomer result = new PersonCustomer();
        result.setPersonForInactivePersonCustomer(person);
        result.setFromPersonMerge(true);
        result.setCustomerType((CustomerType)CustomerType.findByCode((String)"STUDENT").iterator().next());
        result.setAddressCountryCode(fiscalAddress.getCountryOfResidence().getCode());
        result.setFiscalNumber(fiscalNumber);
        result.checkRules();
        return result;
    }

    @Test
    public void testChangeCustomerFromPersonMerge() {
        Person person = Student.readStudentByNumber((Integer)1).getPerson();
        PhysicalAddress physicalAddress = person.getPhysicalAddresses().stream().filter(a -> "PT".equals(PersonCustomer.addressCountryCode((PhysicalAddress)a))).findFirst().get();
        person.editSocialSecurityNumber("507113810", physicalAddress);
        Assert.assertEquals((Object)true, (Object)((PersonCustomer)PersonCustomer.findUnique((Person)person, (String)"PT", (String)"507113810").get()).isFromPersonMerge());
        Assert.assertEquals(Optional.of(person.getPersonCustomer()), (Object)PersonCustomer.findUnique((Person)person, (String)"PT", (String)"507113810"));
    }

    @Test
    public void testIsNotFromPersonMerge() {
        Person person = Student.readStudentByNumber((Integer)1).getPerson();
        PhysicalAddress physicalAddress = person.getPhysicalAddresses().stream().filter(a -> "PT".equals(PersonCustomer.addressCountryCode((PhysicalAddress)a))).findFirst().get();
        person.editSocialSecurityNumber("504024850", physicalAddress);
        Assert.assertEquals((Object)false, (Object)((PersonCustomer)PersonCustomer.findUnique((Person)person, (String)"PT", (String)"504024850").get()).isFromPersonMerge());
        person.editSocialSecurityNumber("999999990", physicalAddress);
        Assert.assertEquals((Object)false, (Object)((PersonCustomer)PersonCustomer.findUnique((Person)person, (String)"PT", (String)"999999990").get()).isFromPersonMerge());
        person.editSocialSecurityNumber("123456789", physicalAddress);
        Assert.assertEquals((Object)false, (Object)((PersonCustomer)PersonCustomer.findUnique((Person)person, (String)"PT", (String)"123456789").get()).isFromPersonMerge());
    }

    @Test
    public void testChangeNIF() {
        Person person = Student.readStudentByNumber((Integer)1).getPerson();
        PhysicalAddress physicalAddress = person.getPhysicalAddresses().stream().filter(a -> "PT".equals(PersonCustomer.addressCountryCode((PhysicalAddress)a))).findFirst().get();
        person.editSocialSecurityNumber("503021202", physicalAddress);
        Assert.assertEquals(Optional.of(person.getPersonCustomer()), (Object)PersonCustomer.findUnique((Person)person, (String)"PT", (String)"503021202"));
        person.editSocialSecurityNumber("999999990", physicalAddress);
        Assert.assertEquals(Optional.of(person.getPersonCustomer()), (Object)PersonCustomer.findUnique((Person)person, (String)"PT", (String)"999999990"));
        person.editSocialSecurityNumber("123456789", physicalAddress);
        Assert.assertEquals(Optional.of(person.getPersonCustomer()), (Object)PersonCustomer.findUnique((Person)person, (String)"PT", (String)"123456789"));
    }

    @Test
    public void testFindUnique() {
        Person person = Student.readStudentByNumber((Integer)1).getPerson();
        List.of("504024850", "999999990", "123456789").forEach(nif -> {
            Optional opt1 = PersonCustomer.findUnique((Person)person, (String)"PT", (String)nif);
            Optional<? extends PersonCustomer> opt2 = this._findUnique(person, "PT", (String)nif, PersonCustomer.OLD_AND_DEPRECATED_SORT_BY_PERSON_MERGE);
            Assert.assertEquals((Object)opt1, opt2);
        });
        Assert.assertEquals(Optional.of(person.getPersonCustomer()), (Object)PersonCustomer.findUnique((Person)person, (String)"PT", (String)"123456789"));
    }

    @Test
    public void testFindAndSortList() {
        Person person = Student.readStudentByNumber((Integer)1).getPerson();
        List.of("504024850", "999999990", "123456789").forEach(nif -> {
            List listA = PersonCustomer.find((Person)person, (String)"PT", (String)nif).sorted(PersonCustomer.IMPROVED_SORT_BY_PERSON_MERGE).collect(Collectors.toList());
            List listB = PersonCustomer.find((Person)person, (String)"PT", (String)nif).sorted(PersonCustomer.OLD_AND_DEPRECATED_SORT_BY_PERSON_MERGE).collect(Collectors.toList());
            Assert.assertEquals(listB, listA);
        });
    }

    private Optional<? extends PersonCustomer> _findUnique(Person person, String fiscalCountryCode, String fiscalNumber, Comparator<PersonCustomer> personComparator) {
        return PersonCustomer.find((Person)person, (String)fiscalCountryCode, (String)fiscalNumber).sorted(personComparator).findFirst();
    }

    private static PhysicalAddress createDefaultPhysicalAddress(Person person) {
        PhysicalAddress result = TestPersonCustomerFindUnique.createPhysicalAddress(person, Country.readByTwoLetterCode((String)"PT"), "unknownAddress", "unknownAddress", "0000-000", "unknownAddress");
        result.setValid();
        return result;
    }

    private static PhysicalAddress createPhysicalAddress(Person person, Country countryOfResidence, String districtOfResidence, String districtSubdivisionOfResidence, String areaCode, String address) {
        PhysicalAddressData data = new PhysicalAddressData();
        data.setAddress(address);
        data.setCountryOfResidence(countryOfResidence);
        data.setDistrictOfResidence(districtOfResidence);
        data.setDistrictSubdivisionOfResidence(districtSubdivisionOfResidence);
        data.setAreaCode(areaCode);
        PhysicalAddress physicalAddress = PhysicalAddress.createPhysicalAddress((Party)person, (PhysicalAddressData)data, (PartyContactType)PartyContactType.PERSONAL, (Boolean)false);
        physicalAddress.setValid();
        return physicalAddress;
    }
}

