/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituation_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.emoluments.ServiceRequestMapEntry;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff;
import org.fenixedu.academictreasury.dto.academictax.AcademicDebitEntryBean;
import org.fenixedu.academictreasury.services.EmolumentServices$callable$createAcademicServiceRequestEmolument;
import org.fenixedu.academictreasury.services.EmolumentServices$callable$createAcademicServiceRequestEmolument$1;
import org.fenixedu.academictreasury.services.EmolumentServices$callable$createAcademicServiceRequestEmolumentForDefaultFinantialEntity;
import org.fenixedu.academictreasury.services.EmolumentServices$callable$createAcademicServiceRequestEmolumentForDefaultFinantialEntity$1;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EmolumentServices {
    public static final Advice advice$createAcademicServiceRequestEmolumentForDefaultFinantialEntity = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicServiceRequestEmolumentForDefaultFinantialEntity$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicServiceRequestEmolument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicServiceRequestEmolument$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static Stream<Product> findEmoluments(FinantialEntity finantialEntity) {
        if (AcademicTreasurySettings.getInstance().getEmolumentsProductGroup() == null) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.emoluments.product.group.not.defined", new String[0]);
        }
        return AcademicTreasurySettings.getInstance().getEmolumentsProductGroup().getProductsSet().stream().filter(l -> l.getFinantialInstitutionsSet().contains(finantialEntity.getFinantialInstitution()));
    }

    @Subscribe
    public void newAcademicServiceRequestSituationEvent(DomainObjectEvent<AcademicServiceRequest> event) {
        this.newAcademicServiceRequestSituationEvent((AcademicServiceRequest)event.getInstance());
    }

    public boolean newAcademicServiceRequestSituationEvent(AcademicServiceRequest academicServiceRequest) {
        if (!(academicServiceRequest instanceof ITreasuryServiceRequest)) {
            return false;
        }
        ITreasuryServiceRequest iTreasuryServiceRequest = (ITreasuryServiceRequest)academicServiceRequest;
        if (!Boolean.TRUE.equals(iTreasuryServiceRequest.getServiceRequestType().getPayable())) {
            return false;
        }
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest);
        if (serviceRequestMapEntry == null) {
            return false;
        }
        if (!academicServiceRequest.getAcademicServiceRequestSituationsSet().stream().map(AcademicServiceRequestSituation_Base::getAcademicServiceRequestSituationType).collect(Collectors.toSet()).contains(serviceRequestMapEntry.getCreateEventOnSituation())) {
            return false;
        }
        LocalDate when = EmolumentServices.possibleDebtDateOnAcademicService(iTreasuryServiceRequest);
        FinantialEntity finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(iTreasuryServiceRequest.getRegistration().getDegree(), when);
        return EmolumentServices.createAcademicServiceRequestEmolument(finantialEntity, iTreasuryServiceRequest, when);
    }

    public static AcademicTreasuryEvent findAcademicTreasuryEvent(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return AcademicTreasuryEvent.findUnique(iTreasuryServiceRequest).orElse(null);
    }

    public static AcademicTariff findTariffForAcademicServiceRequestForDefaultFinantialEntity(ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate when) {
        FinantialEntity finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(iTreasuryServiceRequest.getRegistration().getDegree(), when);
        return EmolumentServices.findTariffForAcademicServiceRequest(finantialEntity, iTreasuryServiceRequest, when);
    }

    public static AcademicTariff findTariffForAcademicServiceRequest(FinantialEntity finantialEntity, ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate when) {
        Degree degree = iTreasuryServiceRequest.getRegistration().getDegree();
        CycleType cycleType = iTreasuryServiceRequest.getCycleType();
        Product product = ServiceRequestMapEntry.findProduct(iTreasuryServiceRequest);
        if (iTreasuryServiceRequest.hasCycleType()) {
            return AcademicTariff.findMatch(finantialEntity, product, degree, cycleType, when.toDateTimeAtStartOfDay());
        }
        return AcademicTariff.findMatch(finantialEntity, product, degree, when.toDateTimeAtStartOfDay());
    }

    public static AcademicDebitEntryBean calculateForAcademicServiceRequestForDefaultFinantialEntity(ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate debtDate) {
        FinantialEntity finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(iTreasuryServiceRequest.getRegistration().getDegree(), debtDate);
        return EmolumentServices.calculateForAcademicServiceRequest(finantialEntity, iTreasuryServiceRequest, debtDate);
    }

    public static AcademicDebitEntryBean calculateForAcademicServiceRequest(FinantialEntity finantialEntity, ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate debtDate) {
        PersonCustomer personCustomer;
        if (!Boolean.TRUE.equals(iTreasuryServiceRequest.getServiceRequestType().getPayable())) {
            return null;
        }
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest);
        if (serviceRequestMapEntry == null) {
            return null;
        }
        Person person = iTreasuryServiceRequest.getPerson();
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, addressFiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", new String[]{addressFiscalCountryCode, fiscalNumber});
        }
        AcademicTariff academicTariff = EmolumentServices.findTariffForAcademicServiceRequest(finantialEntity, iTreasuryServiceRequest, debtDate);
        if (academicTariff == null) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.tariff.not.found", debtDate.toString("dd/MM/yyyy"));
        }
        LocalizedString debitEntryName = academicTariff.academicServiceRequestDebitEntryName(iTreasuryServiceRequest);
        LocalDate dueDate = academicTariff.dueDate(debtDate);
        Vat vat = academicTariff.vat(debtDate);
        int numberOfUnits = AcademicTreasuryEvent.numberOfUnits(iTreasuryServiceRequest);
        int numberOfPages = AcademicTreasuryEvent.numberOfPages(iTreasuryServiceRequest);
        Locale language = AcademicTreasuryEvent.language(iTreasuryServiceRequest);
        boolean urgentRequest = AcademicTreasuryEvent.urgentRequest(iTreasuryServiceRequest);
        BigDecimal amount = academicTariff.amountToPay(numberOfUnits, numberOfPages, language, urgentRequest);
        return new AcademicDebitEntryBean(debitEntryName, dueDate, vat.getTaxRate(), amount);
    }

    public static boolean createAcademicServiceRequestEmolumentForDefaultFinantialEntity(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return (Boolean)advice$createAcademicServiceRequestEmolumentForDefaultFinantialEntity.perform((Callable)new EmolumentServices$callable$createAcademicServiceRequestEmolumentForDefaultFinantialEntity(iTreasuryServiceRequest));
    }

    static /* synthetic */ boolean advised$createAcademicServiceRequestEmolumentForDefaultFinantialEntity(ITreasuryServiceRequest iTreasuryServiceRequest) {
        LocalDate when = EmolumentServices.possibleDebtDateOnAcademicService(iTreasuryServiceRequest);
        return EmolumentServices.createAcademicServiceRequestEmolumentForDefaultFinantialEntity(iTreasuryServiceRequest, when);
    }

    public static boolean createAcademicServiceRequestEmolumentForDefaultFinantialEntity(ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate localDate) {
        return (Boolean)advice$createAcademicServiceRequestEmolumentForDefaultFinantialEntity$1.perform((Callable)new EmolumentServices$callable$createAcademicServiceRequestEmolumentForDefaultFinantialEntity$1(iTreasuryServiceRequest, localDate));
    }

    static /* synthetic */ boolean advised$createAcademicServiceRequestEmolumentForDefaultFinantialEntity(ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate when) {
        FinantialEntity finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(iTreasuryServiceRequest.getRegistration().getDegree(), when);
        return EmolumentServices.createAcademicServiceRequestEmolument(finantialEntity, iTreasuryServiceRequest, when);
    }

    public static boolean createAcademicServiceRequestEmolument(FinantialEntity finantialEntity, ITreasuryServiceRequest iTreasuryServiceRequest) {
        return (Boolean)advice$createAcademicServiceRequestEmolument.perform((Callable)new EmolumentServices$callable$createAcademicServiceRequestEmolument(finantialEntity, iTreasuryServiceRequest));
    }

    static /* synthetic */ boolean advised$createAcademicServiceRequestEmolument(FinantialEntity finantialEntity, ITreasuryServiceRequest iTreasuryServiceRequest) {
        LocalDate when = EmolumentServices.possibleDebtDateOnAcademicService(iTreasuryServiceRequest);
        return EmolumentServices.createAcademicServiceRequestEmolument(finantialEntity, iTreasuryServiceRequest, when);
    }

    @Deprecated
    public static boolean createAcademicServiceRequestEmolument(FinantialEntity finantialEntity, ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate localDate) {
        return (Boolean)advice$createAcademicServiceRequestEmolument$1.perform((Callable)new EmolumentServices$callable$createAcademicServiceRequestEmolument$1(finantialEntity, iTreasuryServiceRequest, localDate));
    }

    static /* synthetic */ boolean advised$createAcademicServiceRequestEmolument(FinantialEntity finantialEntity, ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate when) {
        AcademicTreasuryEvent academicTresuryEvent;
        PersonCustomer personCustomer;
        if (!Boolean.TRUE.equals(iTreasuryServiceRequest.getServiceRequestType().getPayable())) {
            return false;
        }
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest);
        if (serviceRequestMapEntry == null) {
            return false;
        }
        Person person = iTreasuryServiceRequest.getPerson();
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, addressFiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", new String[0]);
        }
        AcademicTariff academicTariff = EmolumentServices.findTariffForAcademicServiceRequest(finantialEntity, iTreasuryServiceRequest, when);
        if (academicTariff == null) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.tariff.not.found", when.toString("dd/MM/yyyy"));
        }
        FinantialInstitution finantialInstitution = finantialEntity.getFinantialInstitution();
        if (!DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).isPresent()) {
            DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)personCustomer);
        }
        if (EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest) == null) {
            AcademicTreasuryEvent.createForAcademicServiceRequest(iTreasuryServiceRequest);
        }
        if ((academicTresuryEvent = EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest)).isChargedWithDebitEntry()) {
            return false;
        }
        DebtAccount personDebtAccount = DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).orElse(null);
        DebitEntry debitEntry = academicTariff.createDebitEntryForAcademicServiceRequest(personDebtAccount, academicTresuryEvent);
        if (debitEntry == null) {
            return false;
        }
        if (TreasuryConstants.isEqual((BigDecimal)debitEntry.getOpenAmount(), (BigDecimal)BigDecimal.ZERO)) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.academicServiceRequest.amount.equals.to.zero", new String[0]);
        }
        DocumentNumberSeries defaultDocumentNumberSeries = DocumentNumberSeries.findUniqueDefaultSeries((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialEntity)finantialEntity);
        DebitNote debitNote = DebitNote.create((FinantialEntity)academicTariff.getFinantialEntity(), (DebtAccount)personDebtAccount, null, (DocumentNumberSeries)defaultDocumentNumberSeries, (DateTime)new DateTime(), (LocalDate)new LocalDate(), null, Collections.emptyMap(), null, null);
        debitNote.addDebitNoteEntries(Collections.singletonList(debitEntry));
        if (AcademicTreasurySettings.getInstance().isCloseServiceRequestEmolumentsWithDebitNote()) {
            debitNote.closeDocument();
        }
        if (serviceRequestMapEntry.getGeneratePaymentCode()) {
            ISibsPaymentCodePoolService platform = ISibsPaymentCodePoolService.getDefaultDigitalPaymentPlatform((FinantialEntity)finantialEntity);
            if (platform == null) {
                throw new AcademicTreasuryDomainException("error.EmolumentServices.academicServiceRequest.paymentCodePool.is.required", new String[0]);
            }
            platform.createSibsPaymentRequest(debitEntry.getDebtAccount(), Collections.singleton(debitEntry), Collections.emptySet());
        }
        return true;
    }

    public static LocalDate possibleDebtDateOnAcademicService(ITreasuryServiceRequest iTreasuryServiceRequest) {
        if (!Boolean.TRUE.equals(iTreasuryServiceRequest.getServiceRequestType().getPayable())) {
            return null;
        }
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest);
        if (serviceRequestMapEntry == null) {
            return null;
        }
        AcademicServiceRequestSituationType createEventOnSituation = serviceRequestMapEntry.getCreateEventOnSituation();
        if (iTreasuryServiceRequest.getSituationByType(createEventOnSituation) == null) {
            return iTreasuryServiceRequest.getRequestDate().toLocalDate();
        }
        return iTreasuryServiceRequest.getSituationByType(createEventOnSituation).getCreationDate().toLocalDate();
    }

    public static boolean removeDebitEntryForAcademicService(ITreasuryServiceRequest iTreasuryServiceRequest) {
        if (EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest) == null) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest);
        if (!academicTreasuryEvent.isChargedWithDebitEntry()) {
            return false;
        }
        DebitEntry debitEntry = academicTreasuryEvent.findActiveAcademicServiceRequestDebitEntry().get();
        DebitNote debitNote = (DebitNote)debitEntry.getFinantialDocument();
        if (!debitEntry.isProcessedInDebitNote()) {
            debitEntry.annulDebitEntry(AcademicTreasuryConstants.academicTreasuryBundle("label.EmolumentServices.removeDebitEntryForAcademicService.reason", new String[0]));
            debitEntry.delete();
            return true;
        }
        if (debitEntry.getCreditEntriesSet().isEmpty()) {
            debitNote.anullDebitNoteWithCreditNote(AcademicTreasuryConstants.academicTreasuryBundle("label.EmolumentServices.removeDebitEntryForAcademicService.reason", new String[0]), false);
            return true;
        }
        return false;
    }

    public static AcademicDebitEntryBean calculateForCustomAcademicDebt(FinantialEntity finantialEntity, Product product, Registration registration, ExecutionYear executionYear, int numberOfUnits, int numberOfPages, boolean urgentRequest, LocalDate debtDate) {
        AcademicTariff academicTariff = AcademicTariff.findMatch(finantialEntity, product, registration.getDegree(), debtDate.toDateTimeAtStartOfDay());
        if (academicTariff == null) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.tariff.not.found", debtDate.toString("dd/MM/yyyy"));
        }
        LocalizedString debitEntryName = AcademicTreasuryEvent.nameForCustomAcademicDebt(product, registration, executionYear);
        LocalDate dueDate = academicTariff.dueDate(debtDate);
        Vat vat = academicTariff.vat(debtDate);
        BigDecimal amount = academicTariff.amountToPay(numberOfUnits, numberOfPages, null, urgentRequest);
        return new AcademicDebitEntryBean(debitEntryName, dueDate, vat.getTaxRate(), amount);
    }

    public static boolean createCustomAcademicDebtForDefaultFinantialEntity(Product product, Registration registration, ExecutionYear executionYear, int numberOfUnits, int numberOfPages, boolean urgentRequest, LocalDate when) {
        FinantialEntity finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(registration.getDegree(), when);
        return EmolumentServices.createCustomAcademicDebt(finantialEntity, product, registration, executionYear, numberOfUnits, numberOfPages, urgentRequest, when);
    }

    public static boolean createCustomAcademicDebt(FinantialEntity finantialEntity, Product product, Registration registration, ExecutionYear executionYear, int numberOfUnits, int numberOfPages, boolean urgentRequest, LocalDate when) {
        PersonCustomer personCustomer;
        String fiscalNumber;
        String addressFiscalCountryCode;
        Person person = registration.getPerson();
        if (!PersonCustomer.findUnique(person, addressFiscalCountryCode = PersonCustomer.addressCountryCode(person), fiscalNumber = PersonCustomer.fiscalNumber(person)).isPresent()) {
            PersonCustomer.create(person, addressFiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", new String[]{addressFiscalCountryCode, fiscalNumber});
        }
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialEntity.getFinantialInstitution(), (Customer)personCustomer).get();
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.createForCustomAcademicDebt(product, registration, executionYear, numberOfUnits, numberOfPages, urgentRequest, when, null);
        AcademicTariff academicTariff = AcademicTariff.findMatch(finantialEntity, product, registration.getDegree(), when.toDateTimeAtStartOfDay());
        if (academicTariff == null) {
            return false;
        }
        academicTariff.createDebitEntryForCustomAcademicDebt(debtAccount, academicTreasuryEvent, when);
        return true;
    }
}

