/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.integration.tuitioninfo.exporter;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.integration.ERPTuitionInfoExportOperation;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfo;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.IERPTuitionInfoExporter;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.exporter.ERPTuitionInfoExporterForSAP$callable$createSaftExportOperation;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.exporter.ERPTuitionInfoExporterForSAP$callable$export;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.exporter.ERPTuitionInfoExporterForSAP$callable$writeContentToExportOperation;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.document.ERPCustomerFieldsBean;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.domain.integration.IntegrationOperationLogBean;
import org.fenixedu.treasury.domain.integration.OperationFile;
import org.fenixedu.treasury.generated.sources.saft.sap.AddressStructurePT;
import org.fenixedu.treasury.generated.sources.saft.sap.AuditFile;
import org.fenixedu.treasury.generated.sources.saft.sap.Header;
import org.fenixedu.treasury.generated.sources.saft.sap.OrderReferences;
import org.fenixedu.treasury.generated.sources.saft.sap.PaymentMethod;
import org.fenixedu.treasury.generated.sources.saft.sap.Product;
import org.fenixedu.treasury.generated.sources.saft.sap.SAFTPTPaymentType;
import org.fenixedu.treasury.generated.sources.saft.sap.SAFTPTSettlementType;
import org.fenixedu.treasury.generated.sources.saft.sap.SAFTPTSourceBilling;
import org.fenixedu.treasury.generated.sources.saft.sap.SAFTPTSourcePayment;
import org.fenixedu.treasury.generated.sources.saft.sap.SourceDocuments;
import org.fenixedu.treasury.generated.sources.saft.sap.Tax;
import org.fenixedu.treasury.generated.sources.saft.sap.TaxTable;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.services.integration.erp.SaftConfig;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentStatusWS;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationInput;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationOutput;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ERPTuitionInfoExporterForSAP
implements IERPTuitionInfoExporter {
    private static Logger logger;
    public static final Advice advice$export;
    public static final Advice advice$createSaftExportOperation;
    public static final Advice advice$writeContentToExportOperation;

    @Override
    public ERPTuitionInfoExportOperation export(ERPTuitionInfo eRPTuitionInfo) {
        return (ERPTuitionInfoExportOperation)((Object)advice$export.perform((Callable)new ERPTuitionInfoExporterForSAP$callable$export(this, eRPTuitionInfo)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPTuitionInfoExportOperation advised$export(ERPTuitionInfoExporterForSAP this_, ERPTuitionInfo erpTuitionInfo) {
        FinantialInstitution institution = erpTuitionInfo.getDocumentNumberSeries().getSeries().getFinantialInstitution();
        if (!institution.getErpIntegrationConfiguration().isIntegratedDocumentsExportationEnabled() && !erpTuitionInfo.isPendingToExport()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoExporterForSAP.export.not.pending", new String[0]);
        }
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPTuitionInfoExportOperation operation = this_.createSaftExportOperation(erpTuitionInfo, null, institution, new DateTime());
        try {
            logBean.appendIntegrationLog(AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoExporterForSAP.starting.finantialdocuments.integration", new String[0]));
            String xml = this_.generateERPFile(erpTuitionInfo);
            logBean.appendIntegrationLog(AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoExporterForSAP.erp.xml.content.generated", new String[0]));
            this_.writeContentToExportOperation(xml, operation);
            boolean success = this_.sendDocumentsInformationToIntegration(operation);
            operation.setSuccess(success);
            logBean.appendIntegrationLog(AcademicTreasuryConstants.academicTreasuryBundle("label.ERPTuitionInfoExporterForSAP.finished.finantialdocuments.integration", new String[0]));
        }
        catch (Exception ex) {
            this_.writeError(operation, logBean, ex);
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return operation;
    }

    private String generateERPFile(ERPTuitionInfo erpTuitionInfo) {
        FinantialInstitution institution = erpTuitionInfo.getDocumentNumberSeries().getSeries().getFinantialInstitution();
        AuditFile auditFile = new AuditFile();
        Header header = this.createSAFTHeader(erpTuitionInfo.getBeginDate().toDateTimeAtStartOfDay(), erpTuitionInfo.getEndDate().toDateTimeAtStartOfDay(), institution, "1.0.3");
        auditFile.setHeader(header);
        AuditFile.MasterFiles masterFiles = new AuditFile.MasterFiles();
        auditFile.setMasterFiles(masterFiles);
        List productList = masterFiles.getProduct();
        HashMap<String, Product> productMap = new HashMap<String, Product>();
        HashSet productCodes = new HashSet();
        List customerList = masterFiles.getCustomer();
        HashMap<String, ERPCustomerFieldsBean> customerMap = new HashMap<String, ERPCustomerFieldsBean>();
        TaxTable taxTable = new TaxTable();
        masterFiles.setTaxTable(taxTable);
        for (Vat vat : institution.getVatsSet()) {
            if (!vat.isActiveNow()) continue;
            taxTable.getTaxTableEntry().add(SAPExporter.convertVATtoTaxTableEntry((Vat)vat, (FinantialInstitution)institution));
        }
        SourceDocuments sourceDocuments = new SourceDocuments();
        auditFile.setSourceDocuments(sourceDocuments);
        SourceDocuments.SalesInvoices invoices = new SourceDocuments.SalesInvoices();
        SourceDocuments.WorkingDocuments workingDocuments = new SourceDocuments.WorkingDocuments();
        SourceDocuments.Payments paymentsDocuments = new SourceDocuments.Payments();
        BigInteger numberOfWorkingDocuments = BigInteger.ZERO;
        BigDecimal totalDebitOfWorkingDocuments = BigDecimal.ZERO;
        BigDecimal totalCreditOfWorkingDocuments = BigDecimal.ZERO;
        invoices.setNumberOfEntries(BigInteger.ZERO);
        invoices.setTotalCredit(BigDecimal.ZERO);
        invoices.setTotalDebit(BigDecimal.ZERO);
        SourceDocuments.WorkingDocuments.WorkDocument workDocument = this.convertToSAFTWorkDocument(erpTuitionInfo, customerMap, productMap);
        workingDocuments.getWorkDocument().add(workDocument);
        if (erpTuitionInfo.isDebit()) {
            totalDebitOfWorkingDocuments = totalDebitOfWorkingDocuments.add(workDocument.getDocumentTotals().getNetTotal());
        } else if (erpTuitionInfo.isCredit()) {
            totalCreditOfWorkingDocuments = totalCreditOfWorkingDocuments.add(workDocument.getDocumentTotals().getNetTotal()).abs();
        }
        numberOfWorkingDocuments = numberOfWorkingDocuments.add(BigInteger.ONE);
        workingDocuments.setNumberOfEntries(numberOfWorkingDocuments);
        workingDocuments.setTotalCredit(totalCreditOfWorkingDocuments.setScale(2, RoundingMode.HALF_EVEN));
        workingDocuments.setTotalDebit(totalDebitOfWorkingDocuments.setScale(2, RoundingMode.HALF_EVEN));
        sourceDocuments.setWorkingDocuments(workingDocuments);
        paymentsDocuments.setNumberOfEntries(BigInteger.ZERO);
        paymentsDocuments.setTotalCredit(BigDecimal.ZERO);
        paymentsDocuments.setTotalDebit(BigDecimal.ZERO);
        paymentsDocuments.setNumberOfEntries(BigInteger.ZERO);
        sourceDocuments.setPayments(paymentsDocuments);
        for (ERPCustomerFieldsBean customerBean : customerMap.values()) {
            org.fenixedu.treasury.generated.sources.saft.sap.Customer customer = SAPExporter.convertCustomerToSAFTCustomer((ERPCustomerFieldsBean)customerBean);
            customerList.add(customer);
        }
        for (Product product : productMap.values()) {
            productList.add(product);
        }
        String xml = SAPExporter.exportAuditFileToXML((AuditFile)auditFile);
        return xml;
    }

    private Header createSAFTHeader(DateTime startDate, DateTime endDate, FinantialInstitution finantialInstitution, String auditVersion) {
        Header header = new Header();
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            header.setAuditFileVersion(auditVersion);
            header.setIdProcesso(finantialInstitution.getErpIntegrationConfiguration().getErpIdProcess());
            header.setBusinessName(finantialInstitution.getCompanyName());
            header.setCompanyName(finantialInstitution.getName());
            AddressStructurePT companyAddress = null;
            companyAddress = SAPExporter.convertFinantialInstitutionAddressToAddressPT((String)finantialInstitution.getAddress(), (String)finantialInstitution.getZipCode(), (String)(finantialInstitution.getMunicipality() != null ? finantialInstitution.getMunicipality().getLocalizedName(new Locale("pt")) : "---"), (String)finantialInstitution.getAddress());
            header.setCompanyAddress(companyAddress);
            header.setCompanyID(finantialInstitution.getFiscalNumber());
            header.setCurrencyCode((Object)finantialInstitution.getCurrency().getCode());
            DateTime now = new DateTime();
            header.setDateCreated(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)now));
            header.setEndDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)endDate));
            header.setFiscalYear(endDate.getYear());
            header.setProductCompanyTaxID(SaftConfig.PRODUCT_COMPANY_TAX_ID());
            header.setProductID(SaftConfig.PRODUCT_ID());
            header.setProductVersion(SaftConfig.PRODUCT_VERSION());
            header.setSoftwareCertificateNumber(BigInteger.valueOf(0L));
            header.setStartDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)startDate));
            header.setTaxAccountingBasis("P");
            header.setTaxEntity("Global");
            try {
                header.setTaxRegistrationNumber(Integer.parseInt(finantialInstitution.getFiscalNumber()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid Fiscal Number.");
            }
            return header;
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private SourceDocuments.WorkingDocuments.WorkDocument convertToSAFTWorkDocument(ERPTuitionInfo erpTuitionInfo, Map<String, ERPCustomerFieldsBean> baseCustomers, Map<String, Product> baseProducts) {
        ERPCustomerFieldsBean customerBean = ERPCustomerFieldsBean.fillFromCustomer((Customer)erpTuitionInfo.getCustomer());
        SourceDocuments.WorkingDocuments.WorkDocument workDocument = new SourceDocuments.WorkingDocuments.WorkDocument();
        if (baseCustomers.containsKey(customerBean.getCustomerId())) {
            ERPCustomerFieldsBean customer = baseCustomers.get(customerBean.getCustomerId());
            if (!customer.getCustomerFiscalNumber().equals(customerBean.getCustomerFiscalNumber())) {
                throw new TreasuryDomainException("error.SAPExporter.customer.registered.with.different.fiscalNumber", new String[0]);
            }
        } else {
            baseCustomers.put(customerBean.getCustomerId(), customerBean);
        }
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            DateTime documentDate = erpTuitionInfo.getCreationDate();
            workDocument.setDueDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)documentDate));
            workDocument.setHash(Strings.repeat((String)"0", (int)172));
            workDocument.setSystemEntryDate(SAPExporter.convertToXMLDateTime((DatatypeFactory)dataTypeFactory, (DateTime)documentDate));
            workDocument.setWorkDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)documentDate));
            workDocument.setCertificationDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)erpTuitionInfo.getCreationDate()));
            workDocument.setDocumentNumber(erpTuitionInfo.getUiDocumentNumber());
            workDocument.setCustomerID(erpTuitionInfo.getCustomer().getCode());
            SourceDocuments.WorkingDocuments.WorkDocument.DocumentStatus status = new SourceDocuments.WorkingDocuments.WorkDocument.DocumentStatus();
            status.setWorkStatus("N");
            status.setWorkStatusDate(SAPExporter.convertToXMLDateTime((DatatypeFactory)dataTypeFactory, (DateTime)documentDate));
            status.setSourceID(TreasuryPlataformDependentServicesFactory.implementation().versioningCreatorUsername((Object)erpTuitionInfo));
            status.setSourceBilling(SAFTPTSourceBilling.P);
            workDocument.setDocumentStatus(status);
            SourceDocuments.WorkingDocuments.WorkDocument.DocumentTotals docTotals = new SourceDocuments.WorkingDocuments.WorkDocument.DocumentTotals();
            docTotals.setGrossTotal(erpTuitionInfo.getTuitionDeltaAmount().setScale(2, RoundingMode.HALF_EVEN).abs());
            docTotals.setNetTotal(erpTuitionInfo.getTuitionDeltaAmount().setScale(2, RoundingMode.HALF_EVEN).abs());
            docTotals.setTaxPayable(erpTuitionInfo.getTuitionDeltaAmount().setScale(2, RoundingMode.HALF_EVEN).abs());
            workDocument.setDocumentTotals(docTotals);
            workDocument.setWorkType("DC");
            workDocument.setPeriod(Integer.valueOf(documentDate.getMonthOfYear()));
            String creator = TreasuryPlataformDependentServicesFactory.implementation().versioningCreatorUsername((Object)erpTuitionInfo);
            workDocument.setSourceID(!Strings.isNullOrEmpty((String)creator) ? creator : "");
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        List productLines = workDocument.getLine();
        SourceDocuments.WorkingDocuments.WorkDocument.Line line = this.convertToSAFTWorkDocumentLine(erpTuitionInfo, baseProducts);
        line.setLineNumber(BigInteger.ONE);
        productLines.add(line);
        return workDocument;
    }

    private SourceDocuments.WorkingDocuments.WorkDocument.Line convertToSAFTWorkDocumentLine(ERPTuitionInfo erpTuitionInfo, Map<String, Product> baseProducts) {
        SourceDocuments.WorkingDocuments.WorkDocument.Line line = new SourceDocuments.WorkingDocuments.WorkDocument.Line();
        DateTime documentDate = erpTuitionInfo.getCreationDate();
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            Product currentProduct = null;
            ERPTuitionInfoType tuitionInfoType = erpTuitionInfo.getErpTuitionInfoType();
            if (tuitionInfoType.getErpTuitionInfoProduct().getCode() != null && baseProducts.containsKey(tuitionInfoType.getErpTuitionInfoProduct().getCode())) {
                currentProduct = baseProducts.get(tuitionInfoType.getErpTuitionInfoProduct().getCode());
            } else {
                currentProduct = this.convertERPTuitionInfoTypeToSAFTProduct(tuitionInfoType);
                baseProducts.put(currentProduct.getProductCode(), currentProduct);
            }
            XMLGregorianCalendar documentDateCalendar = null;
            documentDateCalendar = SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)documentDate);
            if (erpTuitionInfo.isCredit()) {
                line.setCreditAmount(erpTuitionInfo.getTuitionDeltaAmount().setScale(2, RoundingMode.HALF_EVEN).abs());
            } else if (erpTuitionInfo.isDebit()) {
                line.setDebitAmount(erpTuitionInfo.getTuitionDeltaAmount().setScale(2, RoundingMode.HALF_EVEN));
            }
            line.setDescription(tuitionInfoType.getErpTuitionInfoProduct().getName());
            List orderReferences = line.getOrderReferences();
            line.setMetadata(this.fillMetadata(erpTuitionInfo, dataTypeFactory));
            if (erpTuitionInfo.getFirstERPTuitionInfo() != null) {
                ERPTuitionInfo firstERPTuitionInfo = erpTuitionInfo.getFirstERPTuitionInfo();
                OrderReferences reference = new OrderReferences();
                reference.setOriginatingON(firstERPTuitionInfo.getUiDocumentNumber());
                reference.setOrderDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)erpTuitionInfo.getFirstERPTuitionInfo().getCreationDate()));
                reference.setLineNumber(BigInteger.ONE);
                orderReferences.add(reference);
            }
            line.setProductCode(currentProduct.getProductCode());
            line.setProductDescription(currentProduct.getProductDescription());
            line.setQuantity(BigDecimal.ONE);
            line.setSettlementAmount(BigDecimal.ZERO);
            line.setTax(this.getSAFTWorkingDocumentsTax(erpTuitionInfo));
            line.setTaxPointDate(documentDateCalendar);
            line.setTaxExemptionReason("M07-Isento Artigo 9.\u00ba do CIVA (Ou similar)");
            line.setUnitOfMeasure("Unidade");
            line.setUnitPrice(erpTuitionInfo.getTuitionDeltaAmount().setScale(2, RoundingMode.HALF_EVEN).abs());
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return line;
    }

    private Product convertERPTuitionInfoTypeToSAFTProduct(ERPTuitionInfoType tuitionInfoType) {
        Product p = new Product();
        p.setProductCode(tuitionInfoType.getErpTuitionInfoProduct().getCode());
        p.setProductDescription(tuitionInfoType.getErpTuitionInfoProduct().getName());
        p.setProductGroup(AcademicTreasurySettings.getInstance().getTuitionProductGroup().getName().getContent());
        p.setProductNumberCode(p.getProductCode());
        p.setProductType("S");
        return p;
    }

    private SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata fillMetadata(ERPTuitionInfo erpTuitionInfo, DatatypeFactory dataTypeFactory) {
        HashMap metadataPropertiesMap = Maps.newHashMap();
        metadataPropertiesMap.put("TOTAL_TUITION_AMOUNT", erpTuitionInfo.getTuitionTotalAmount().toString());
        if (erpTuitionInfo.getLastSuccessfulSentERPTuitionInfo() != null) {
            metadataPropertiesMap.put("LAST_SUCCESSFUL_EXPORTATION", erpTuitionInfo.getLastSuccessfulSentERPTuitionInfo().getUiDocumentNumber());
        } else {
            metadataPropertiesMap.put("LAST_SUCCESSFUL_EXPORTATION", "");
        }
        metadataPropertiesMap.put("START_DATE", erpTuitionInfo.getBeginDate().toString("yyyy-MM-dd"));
        metadataPropertiesMap.put("END_DATE", erpTuitionInfo.getEndDate().toString("yyyy-MM-dd"));
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        Type stringStringMapType = new TypeToken<Map<String, String>>(){}.getType();
        String json = gson.toJson((Object)metadataPropertiesMap, stringStringMapType);
        SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata metadata = new SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata();
        metadata.setDescription(json);
        return metadata;
    }

    private Tax getSAFTWorkingDocumentsTax(ERPTuitionInfo erpTuitionInfo) {
        Tax tax = new Tax();
        tax.setTaxCode("ISE");
        tax.setTaxCountryRegion("PT");
        tax.setTaxPercentage(BigDecimal.ZERO);
        tax.setTaxType("IVA");
        return tax;
    }

    private ERPTuitionInfoExportOperation createSaftExportOperation(ERPTuitionInfo eRPTuitionInfo, byte[] byArray, FinantialInstitution finantialInstitution, DateTime dateTime) {
        return (ERPTuitionInfoExportOperation)((Object)advice$createSaftExportOperation.perform((Callable)new ERPTuitionInfoExporterForSAP$callable$createSaftExportOperation(this, eRPTuitionInfo, byArray, finantialInstitution, dateTime)));
    }

    static /* synthetic */ ERPTuitionInfoExportOperation advised$createSaftExportOperation(ERPTuitionInfoExporterForSAP this_, ERPTuitionInfo erpTuitionInfo, byte[] data, FinantialInstitution institution, DateTime when) {
        String filename = institution.getFiscalNumber() + "_" + when.toString() + ".xml";
        ERPTuitionInfoExportOperation operation = ERPTuitionInfoExportOperation.create(erpTuitionInfo, data, filename, institution, null, when);
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendDocumentsInformationToIntegration(ERPTuitionInfoExportOperation operation) throws MalformedURLException {
        FinantialInstitution institution = operation.getFinantialInstitution();
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        try {
            DocumentsInformationOutput sendInfoOnlineResult;
            boolean success = true;
            ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
            if (erpIntegrationConfiguration == null) {
                throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
            }
            if (!erpIntegrationConfiguration.getActive()) {
                logBean.appendErrorLog(TreasuryConstants.treasuryBundle((String)"info.ERPExporter.configuration.inactive", (String[])new String[0]));
                boolean bl = false;
                return bl;
            }
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle((String)"info.ERPExporter.sending.inforation", (String[])new String[0]));
            IERPExternalService service = erpIntegrationConfiguration.getERPExternalServiceImplementation();
            DocumentsInformationInput input = new DocumentsInformationInput();
            if (operation.getFile().getSize() <= erpIntegrationConfiguration.getMaxSizeBytesToExportOnline()) {
                input.setData(operation.getFile().getContent());
                sendInfoOnlineResult = service.sendInfoOnline(institution, input);
                operation.setErpOperationId(sendInfoOnlineResult.getRequestId());
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle((String)"info.ERPExporter.sucess.sending.inforation.online", (String[])new String[]{sendInfoOnlineResult.getRequestId()}));
                for (DocumentStatusWS status : sendInfoOnlineResult.getDocumentStatus()) {
                    if (status.isIntegratedWithSuccess()) {
                        ERPTuitionInfo tuitionInfo = ERPTuitionInfo.findUniqueByDocumentNumber(status.getDocumentNumber()).orElse(null);
                        if (tuitionInfo != null) {
                            String message = TreasuryConstants.treasuryBundle((String)"info.ERPExporter.sucess.integrating.document", (String[])new String[]{tuitionInfo.getUiDocumentNumber()});
                            logBean.appendIntegrationLog(message);
                            tuitionInfo.markIntegratedWithSuccess(message);
                            continue;
                        }
                        success = false;
                        logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle((String)"info.ERPExporter.error.integrating.document", (String[])new String[]{status.getDocumentNumber(), status.getErrorDescription()}));
                        logBean.appendErrorLog(TreasuryConstants.treasuryBundle((String)"info.ERPExporter.error.integrating.document", (String[])new String[]{status.getDocumentNumber(), status.getErrorDescription()}));
                        continue;
                    }
                    success = false;
                    logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle((String)"info.ERPExporter.error.integrating.document", (String[])new String[]{status.getDocumentNumber(), status.getErrorDescription()}));
                    logBean.appendErrorLog(TreasuryConstants.treasuryBundle((String)"info.ERPExporter.error.integrating.document", (String[])new String[]{status.getDocumentNumber(), status.getErrorDescription()}));
                }
                for (String m : sendInfoOnlineResult.getOtherMessages()) {
                    logBean.appendIntegrationLog(m);
                }
            } else {
                throw new TreasuryDomainException("error.ERPExporter.sendDocumentsInformationToIntegration.maxSizeBytesToExportOnline.exceeded", new String[0]);
            }
            logBean.defineSoapInboundMessage(sendInfoOnlineResult.getSoapInboundMessage());
            logBean.defineSoapOutboundMessage(sendInfoOnlineResult.getSoapOutboundMessage());
            boolean bl = success;
            return bl;
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
    }

    private void writeError(ERPTuitionInfoExportOperation operation, IntegrationOperationLogBean logBean, Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        t.printStackTrace(writer);
        logBean.appendErrorLog(out.toString());
        operation.setProcessed(true);
    }

    private void writeContentToExportOperation(String string, ERPTuitionInfoExportOperation eRPTuitionInfoExportOperation) {
        Object object = advice$writeContentToExportOperation.perform((Callable)new ERPTuitionInfoExporterForSAP$callable$writeContentToExportOperation(this, string, eRPTuitionInfoExportOperation));
    }

    static /* synthetic */ void advised$writeContentToExportOperation(ERPTuitionInfoExporterForSAP this_, String content, ERPTuitionInfoExportOperation operation) {
        byte[] bytes = null;
        try {
            bytes = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String fileName = operation.getFinantialInstitution().getFiscalNumber() + "_" + operation.getExecutionDate().toString("ddMMyyyy_hhmm") + ".xml";
        OperationFile binaryStream = new OperationFile(fileName, bytes);
        if (operation.getFile() != null) {
            operation.getFile().delete();
        }
        operation.setFile(binaryStream);
    }

    private SourceDocuments.Payments.Payment convertToSAFTPaymentDocument(ERPTuitionInfo erpTuitionInfo) {
        SourceDocuments.Payments.Payment payment = new SourceDocuments.Payments.Payment();
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            DateTime documentDate = erpTuitionInfo.getCreationDate();
            payment.setSystemEntryDate(SAPExporter.convertToXMLDateTime((DatatypeFactory)dataTypeFactory, (DateTime)documentDate));
            payment.setTransactionDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)documentDate));
            payment.setPaymentType(SAFTPTPaymentType.RG);
            payment.setPaymentRefNo(erpTuitionInfo.getUiSettlementDocumentNumberForERP());
            payment.setFinantialTransactionReference("");
            payment.setSourceID(" ");
            payment.setCustomerID(erpTuitionInfo.getCustomer().getCode());
            SourceDocuments.Payments.Payment.DocumentStatus status = new SourceDocuments.Payments.Payment.DocumentStatus();
            status.setPaymentStatus("N");
            status.setPaymentStatusDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)erpTuitionInfo.getCreationDate()));
            String creator = TreasuryPlataformDependentServicesFactory.implementation().versioningCreatorUsername((Object)erpTuitionInfo);
            status.setSourceID(!Strings.isNullOrEmpty((String)creator) ? creator : " ");
            status.setReason("");
            status.setSourcePayment(SAFTPTSourcePayment.P);
            payment.setDocumentStatus(status);
            PaymentMethod voidMethod = new PaymentMethod();
            voidMethod.setPaymentAmount(BigDecimal.ZERO);
            voidMethod.setPaymentDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)erpTuitionInfo.getCreationDate()));
            voidMethod.setPaymentMechanism("OU");
            voidMethod.setPaymentMethodReference("");
            payment.getPaymentMethod().add(voidMethod);
            payment.setSettlementType(SAFTPTSettlementType.NN);
            SourceDocuments.Payments.Payment.DocumentTotals docTotals = new SourceDocuments.Payments.Payment.DocumentTotals();
            SourceDocuments.Payments.Payment.Line line = new SourceDocuments.Payments.Payment.Line();
            line.setLineNumber(BigInteger.ONE);
            SourceDocuments.Payments.Payment.Line.SourceDocumentID sourceDocument = new SourceDocuments.Payments.Payment.Line.SourceDocumentID();
            sourceDocument.setLineNumber(BigInteger.ONE);
            sourceDocument.setOriginatingON(erpTuitionInfo.getFirstERPTuitionInfo().getUiDocumentNumber());
            sourceDocument.setInvoiceDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)erpTuitionInfo.getCreationDate()));
            sourceDocument.setDescription(erpTuitionInfo.getErpTuitionInfoType().getErpTuitionInfoProduct().getName());
            line.getSourceDocumentID().add(sourceDocument);
            line.setSettlementAmount(BigDecimal.ZERO);
            line.setDebitAmount(erpTuitionInfo.getTuitionDeltaAmount().abs());
            payment.getLine().add(line);
            line = new SourceDocuments.Payments.Payment.Line();
            line.setLineNumber(new BigInteger("2"));
            sourceDocument = new SourceDocuments.Payments.Payment.Line.SourceDocumentID();
            sourceDocument.setLineNumber(BigInteger.ONE);
            sourceDocument.setOriginatingON(erpTuitionInfo.getUiDocumentNumber());
            sourceDocument.setInvoiceDate(SAPExporter.convertToXMLDate((DatatypeFactory)dataTypeFactory, (DateTime)erpTuitionInfo.getCreationDate()));
            sourceDocument.setDescription(erpTuitionInfo.getErpTuitionInfoType().getErpTuitionInfoProduct().getName());
            line.getSourceDocumentID().add(sourceDocument);
            line.setSettlementAmount(BigDecimal.ZERO);
            line.setCreditAmount(erpTuitionInfo.getTuitionDeltaAmount().abs());
            payment.getLine().add(line);
            docTotals.setGrossTotal(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_EVEN));
            docTotals.setNetTotal(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_EVEN));
            docTotals.setTaxPayable(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_EVEN));
            payment.setDocumentTotals(docTotals);
            payment.setPeriod(Integer.valueOf(erpTuitionInfo.getCreationDate().getMonthOfYear()));
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return payment;
    }

    static {
        advice$export = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$createSaftExportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$writeContentToExportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(SAPExporter.class);
    }
}

