/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import com.google.common.base.Strings;
import com.qubit.terra.framework.tools.excel.ExcelUtil;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.IFinantialReportEntryCommonMethods;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporterUtils;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class DebtReportEntryBean
implements SpreadsheetRow,
IFinantialReportEntryCommonMethods {
    public static String[] SPREADSHEET_DEBIT_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.entryType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.versioningCreator", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.entryDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.dueDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.debtAccountId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.identificationType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.identificationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.email", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.personalEmail", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.address", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.registrationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.executionYear", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.executionSemester", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.productCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.invoiceEntryDescription", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentExportationPending", new String[0]), "", AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.amountToPay", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.openAmountToPay", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.openAmountWithInterestToDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.pendingInterestAmount", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.payorDebtAcount.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.payorDebtAcount.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.agreement", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.ingression", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.firstTimeStudent", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.partialRegime", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.statutes", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfNormalEnrolments", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfStandaloneEnrolments", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfExtracurricularEnrolments", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.tuitionPaymentPlan", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.tuitionPaymentPlanConditions", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentAnnuled", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentAnnuledReason", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.closeDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.openAmountAtERPStartDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.exportedInLegacyERP", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.legacyERPCertificateDocumentReference", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.erpCertificationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.erpCertificateDocumentReference", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.originSettlementNoteForAdvancedCredit", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.code", new String[0])};
    public static String[] SPREADSHEET_CREDIT_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.entryType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.versioningCreator", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.entryDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.dueDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.debtAccountId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.identificationType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.identificationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.email", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.personalEmail", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.address", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.registrationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.executionYear", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.executionSemester", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.productCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.invoiceEntryDescription", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentExportationPending", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.debitEntry.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.amountToCredit", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.openAmountToCredit", new String[0]), "", "", AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.payorDebtAcount.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.payorDebtAcount.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.agreement", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.ingression", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.firstTimeStudent", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.partialRegime", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.statutes", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfNormalEnrolments", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfStandaloneEnrolments", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfExtracurricularEnrolments", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.tuitionPaymentPlan", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.tuitionPaymentPlanConditions", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentAnnuled", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentAnnuledReason", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.closeDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.openAmountAtERPStartDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.exportedInLegacyERP", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.legacyERPCertificateDocumentReference", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.erpCertificationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.erpCertificateDocumentReference", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.originSettlementNoteForAdvancedCredit", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.code", new String[0])};
    private InvoiceEntry invoiceEntry;
    private boolean completed = false;
    private String identification;
    private String code;
    private String entryType;
    private String versioningCreator;
    private DateTime creationDate;
    private DateTime entryDate;
    private LocalDate dueDate;
    private String customerId;
    private String debtAccountId;
    private String name;
    private String identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String institutionalOrDefaultEmail;
    private String emailForSendingEmails;
    private String personalEmail;
    private String address;
    private Integer studentNumber;
    private Integer registrationNumber;
    private String degreeType;
    private String degreeCode;
    private String degreeName;
    private LocalizedString registrationMajorDcpGroupName;
    private LocalizedString registrationMinorDcpGroupName;
    private String executionYear;
    private String executionSemester;
    private String productCode;
    private String invoiceEntryDescription;
    private String documentNumber;
    private Boolean documentExportationPending;
    private Boolean annuled;
    private String annuledReason;
    private String debitEntryIdentification;
    private BigDecimal amountToPay;
    private BigDecimal netExemptedAmount;
    private BigDecimal openAmountToPay;
    private BigDecimal openAmountWithInterestToDate;
    private BigDecimal pendingInterestAmount;
    private String payorDebtAccountVatNumber;
    private String payorDebtAccountName;
    private LocalizedString agreement;
    private LocalizedString ingression;
    private Boolean firstTimeStudent;
    private Boolean partialRegime;
    private String statutes;
    private Integer numberOfNormalEnrolments;
    private Integer numberOfStandaloneEnrolments;
    private Integer numberOfExtracurricularEnrolments;
    private String tuitionPaymentPlan;
    private String tuitionPaymentPlanConditions;
    private DateTime closeDate;
    private BigDecimal openAmountAtERPStartDate;
    private Boolean exportedInLegacyERP;
    private String legacyERPCertificateDocumentReference;
    private LocalDate erpCertificationDate;
    private String erpCertificateDocumentReference;
    private String erpCustomerId;
    private String erpPayorCustomerId;
    private String certifiedDocumentNumber;
    private LocalDate certifiedDocumentDate;
    private String originSettlementNoteForAdvancedCredit;
    private String decimalSeparator;
    private String documentObservations;
    private String documentTermsAndConditions;
    private String finantialEntityCode;
    private LocalizedString finantialEntityName;
    private Degree degreeDomainObject;
    private ExecutionYear executionYearDomainObject;
    private String emptyColumnOne;
    private String emptyColumnTwo;

    public DebtReportEntryBean(InvoiceEntry entry, DebtReportRequest request, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        this.decimalSeparator = request != null ? request.getDecimalSeparator() : ".";
        Currency currency = entry.getDebtAccount().getFinantialInstitution().getCurrency();
        this.invoiceEntry = entry;
        try {
            this.identification = entry.getExternalId();
            this.code = entry.getCode();
            this.entryType = this.entryType(entry);
            this.creationDate = treasuryServices.versioningCreationDate((Object)entry);
            this.versioningCreator = treasuryServices.versioningCreatorUsername((Object)entry);
            this.entryDate = entry.getEntryDateTime();
            this.dueDate = entry.getDueDate();
            this.payorDebtAccountVatNumber = "";
            this.payorDebtAccountName = "";
            if (entry.getFinantialDocument() != null && ((Invoice)entry.getFinantialDocument()).getPayorDebtAccount() != null) {
                this.payorDebtAccountVatNumber = ((Invoice)entry.getFinantialDocument()).getPayorDebtAccount().getCustomer().getUiFiscalNumber();
                this.payorDebtAccountName = ((Invoice)entry.getFinantialDocument()).getPayorDebtAccount().getCustomer().getName();
            }
            this.fillStudentInformation(entry);
            this.productCode = entry.getProduct().getCode();
            this.invoiceEntryDescription = entry.getDescription();
            if (entry.getFinantialDocument() != null) {
                this.documentNumber = entry.getFinantialDocument().getUiDocumentNumber();
                this.documentExportationPending = entry.getFinantialDocument().isDocumentToExport();
                this.documentObservations = entry.getFinantialDocument().getDocumentObservations();
                this.documentTermsAndConditions = entry.getFinantialDocument().getDocumentTermsAndConditions();
            }
            this.annuled = entry.isAnnulled();
            if (this.annuled.booleanValue() && entry.getFinantialDocument() != null) {
                this.annuledReason = entry.getFinantialDocument().getAnnulledReason();
            }
            if (entry.isCreditNoteEntry() && ((CreditEntry)entry).getDebitEntry() != null) {
                this.debitEntryIdentification = ((CreditEntry)entry).getDebitEntry().getExternalId();
            }
            this.amountToPay = Currency.getValueWithScale((BigDecimal)entry.getAmountWithVat());
            this.openAmountToPay = Currency.getValueWithScale((BigDecimal)entry.getOpenAmount());
            this.openAmountWithInterestToDate = Currency.getValueWithScale((BigDecimal)entry.getOpenAmountWithInterests());
            this.pendingInterestAmount = Currency.getValueWithScale((BigDecimal)entry.getOpenAmountWithInterests().subtract(entry.getOpenAmount()));
            this.netExemptedAmount = entry.getNetExemptedAmount();
            if (entry.getFinantialEntity() != null) {
                this.finantialEntityCode = entry.getFinantialEntity().getCode();
                this.finantialEntityName = entry.getFinantialEntity().getName();
            }
            this.fillERPInformation(entry);
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(entry, e);
        }
    }

    private void fillERPInformation(InvoiceEntry entry) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        Currency currency = entry.getDebtAccount().getFinantialInstitution().getCurrency();
        this.closeDate = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getCloseDate() : null;
        this.openAmountAtERPStartDate = Currency.getValueWithScale((BigDecimal)SAPExporterUtils.openAmountAtDate((InvoiceEntry)entry, (DateTime)SAPExporter.ERP_INTEGRATION_START_DATE));
        this.exportedInLegacyERP = entry.getFinantialDocument() != null ? entry.getFinantialDocument().isExportedInLegacyERP() : false;
        this.legacyERPCertificateDocumentReference = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getLegacyERPCertificateDocumentReference() : null;
        this.erpCertificationDate = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getErpCertificationDate() : null;
        this.erpCertificateDocumentReference = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getErpCertificateDocumentReference() : null;
        this.erpCustomerId = entry.getDebtAccount().getCustomer().getErpCustomerId();
        if (entry.getFinantialDocument() != null && ((Invoice)entry.getFinantialDocument()).getPayorDebtAccount() != null) {
            this.erpPayorCustomerId = ((Invoice)entry.getFinantialDocument()).getPayorDebtAccount().getCustomer().getErpCustomerId();
        }
        if (entry.getFinantialDocument() != null && entry.getFinantialDocument().isCreditNote() && ((CreditNote)entry.getFinantialDocument()).isAdvancePayment()) {
            AdvancedPaymentCreditNote advancedCreditNote = (AdvancedPaymentCreditNote)entry.getFinantialDocument();
            String string = this.originSettlementNoteForAdvancedCredit = advancedCreditNote.getAdvancedPaymentSettlementNote() != null ? advancedCreditNote.getAdvancedPaymentSettlementNote().getUiDocumentNumber() : "";
        }
        if (entry.getFinantialDocument() != null && treasuryServices.hasCertifiedDocument(entry.getFinantialDocument())) {
            this.erpCertificationDate = treasuryServices.getCertifiedDocumentDate(entry.getFinantialDocument());
            this.erpCertificateDocumentReference = treasuryServices.getCertifiedDocumentNumber(entry.getFinantialDocument());
        }
        if (entry.getFinantialDocument() != null && treasuryServices.hasCertifiedDocument(entry.getFinantialDocument())) {
            this.certifiedDocumentDate = treasuryServices.getCertifiedDocumentDate(entry.getFinantialDocument());
            this.certifiedDocumentNumber = treasuryServices.getCertifiedDocumentNumber(entry.getFinantialDocument());
        }
    }

    private void fillStudentInformation(InvoiceEntry entry) {
        Customer customer = entry.getDebtAccount().getCustomer();
        this.customerId = customer.getExternalId();
        this.debtAccountId = entry.getDebtAccount().getExternalId();
        this.name = customer.getName();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null && ((PersonCustomer)customer).getAssociatedPerson().getIdDocumentType() != null) {
            this.identificationType = ((PersonCustomer)customer).getAssociatedPerson().getIdDocumentType().getLocalizedName();
        }
        this.identificationNumber = customer.getIdentificationNumber();
        this.vatNumber = customer.getUiFiscalNumber();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null) {
            Person person = ((PersonCustomer)customer).getAssociatedPerson();
            this.institutionalOrDefaultEmail = person.getInstitutionalOrDefaultEmailAddressValue();
            this.emailForSendingEmails = person.getEmailForSendingEmails();
            this.personalEmail = DebtReportEntryBean.personalEmail(person) != null ? DebtReportEntryBean.personalEmail(person).getValue() : "";
        }
        this.address = customer.getUiCompleteAddress();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null && ((PersonCustomer)customer).getAssociatedPerson().getStudent() != null) {
            this.studentNumber = ((PersonCustomer)customer).getAssociatedPerson().getStudent().getNumber();
        }
        this.fillAcademicInformation(entry);
    }

    static EmailAddress personalEmail(Person person) {
        return DebtReportEntryBean.pendingOrValidPartyContacts(person, EmailAddress.class).stream().map(EmailAddress.class::cast).filter(e -> Boolean.TRUE.equals(e.getActive())).filter(e -> e.getType() == PartyContactType.PERSONAL).filter(e -> e.getCurrentPartyContact() == null).findFirst().orElse(null);
    }

    private static List<? extends PartyContact> pendingOrValidPartyContacts(Person person, Class<? extends PartyContact> partyContactType) {
        Comparator comparator = (o1, o2) -> {
            if (o1.isValid() && !o2.isValid()) {
                return -1;
            }
            if (!o1.isValid() && o2.isValid()) {
                return 1;
            }
            return o1.getExternalId().compareTo(o2.getExternalId());
        };
        return person.getAllPartyContacts(partyContactType).stream().sorted(comparator).collect(Collectors.toList());
    }

    private String entryType(InvoiceEntry entry) {
        if (entry.isDebitNoteEntry()) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.debitNoteEntry", new String[0]);
        }
        if (entry.isCreditNoteEntry()) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.creditNoteEntry", new String[0]);
        }
        return null;
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            ExcelUtil.createCellWithValue((Row)row, (int)0, (String)this.valueOrEmpty(this.identification));
            if (!this.completed) {
                ExcelUtil.createCellWithValue((Row)row, (int)1, (String)AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            if (this.invoiceEntry.isDebitNoteEntry()) {
                String value;
                int i = 1;
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.entryType));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.versioningCreator));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.creationDate));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.entryDate.toString("yyyy/MM/dd HH:mm:ss"));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.dueDate.toString("yyyy/MM/dd"));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.customerId));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.debtAccountId));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.name));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.identificationType));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.identificationNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.vatNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.institutionalOrDefaultEmail));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.personalEmail));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.address));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.studentNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.registrationNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeType));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeCode));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeName));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.executionYear));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.executionSemester));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.productCode));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.invoiceEntryDescription));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.documentNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.documentExportationPending));
                ++i;
                String string = value = this.amountToPay != null ? this.amountToPay.toString() : "";
                if (",".equals(this.decimalSeparator)) {
                    value = value.replace(".", ",");
                }
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(value));
                String string2 = value = this.openAmountToPay != null ? this.openAmountToPay.toString() : "";
                if (",".equals(this.decimalSeparator)) {
                    value = value.replace(".", ",");
                }
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(value));
                String string3 = value = this.openAmountWithInterestToDate != null ? this.openAmountWithInterestToDate.toString() : "";
                if (",".equals(this.decimalSeparator)) {
                    value = value.replace(".", ",");
                }
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(value));
                String string4 = value = this.pendingInterestAmount != null ? this.pendingInterestAmount.toString() : "0";
                if (",".equals(this.decimalSeparator)) {
                    value = value.replace(".", ",");
                }
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(value));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.payorDebtAccountVatNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.payorDebtAccountName));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.agreement));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.ingression));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.firstTimeStudent));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.partialRegime));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.statutes));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.numberOfNormalEnrolments));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.numberOfStandaloneEnrolments));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.numberOfExtracurricularEnrolments));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.tuitionPaymentPlan));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.tuitionPaymentPlanConditions));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.annuled));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.annuledReason));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.closeDate));
                String string5 = value = this.openAmountAtERPStartDate != null ? this.openAmountAtERPStartDate.toString() : "";
                if (",".equals(this.decimalSeparator)) {
                    value = value.replace(".", ",");
                }
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(value));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.exportedInLegacyERP));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.legacyERPCertificateDocumentReference));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.erpCertificationDate));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.erpCertificateDocumentReference));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.originSettlementNoteForAdvancedCredit));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.code));
            } else if (this.invoiceEntry.isCreditNoteEntry()) {
                String value;
                int i = 1;
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.entryType));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.versioningCreator));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.creationDate));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.entryDate.toString("yyyy/MM/dd HH:mm:ss"));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.dueDate.toString("yyyy/MM/dd"));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.customerId));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.debtAccountId));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.name));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.identificationType));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.identificationNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.vatNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.institutionalOrDefaultEmail));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.personalEmail));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.address));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.studentNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.registrationNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeType));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeCode));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeName));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.executionYear));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.executionSemester));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.productCode));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.invoiceEntryDescription));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.documentNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.documentExportationPending));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.debitEntryIdentification));
                String string = value = this.amountToPay != null ? this.amountToPay.toString() : "";
                if (",".equals(this.decimalSeparator)) {
                    value = value.replace(".", ",");
                }
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(value));
                String string6 = value = this.openAmountToPay != null ? this.openAmountToPay.toString() : "";
                if (",".equals(this.decimalSeparator)) {
                    value = value.replace(".", ",");
                }
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(value));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)"");
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)"");
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.payorDebtAccountVatNumber));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.payorDebtAccountName));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.agreement));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.ingression));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.firstTimeStudent));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.partialRegime));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.statutes));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.numberOfNormalEnrolments));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.numberOfStandaloneEnrolments));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.numberOfExtracurricularEnrolments));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.tuitionPaymentPlan));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.tuitionPaymentPlanConditions));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.annuled));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.annuledReason));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.closeDate));
                String string7 = value = this.openAmountAtERPStartDate != null ? this.openAmountAtERPStartDate.toString() : "";
                if (",".equals(this.decimalSeparator)) {
                    value = value.replace(".", ",");
                }
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(value));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.exportedInLegacyERP));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.legacyERPCertificateDocumentReference));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.erpCertificationDate));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.erpCertificateDocumentReference));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.originSettlementNoteForAdvancedCredit));
                ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.code));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.invoiceEntry, e);
        }
    }

    private String valueOrEmpty(LocalDate value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd");
    }

    private String valueOrEmpty(DateTime value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd HH:mm:ss");
    }

    private String valueOrEmpty(Boolean value) {
        if (value == null) {
            return "";
        }
        return AcademicTreasuryConstants.academicTreasuryBundle(value != false ? "label.yes" : "label.no", new String[0]);
    }

    private String valueOrEmpty(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String valueOrEmpty(LocalizedString value) {
        if (value == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)value.getContent())) {
            return "";
        }
        return value.getContent();
    }

    private String valueOrEmpty(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return "";
    }

    public DebitEntry getAssociatedDebitEntry() {
        return this.invoiceEntry.isDebitNoteEntry() ? (DebitEntry)this.invoiceEntry : null;
    }

    public CreditEntry getAssociatedCreditEntry() {
        return this.invoiceEntry.isCreditNoteEntry() ? (CreditEntry)this.invoiceEntry : null;
    }

    public Person getAssociatedPerson() {
        if (!this.invoiceEntry.getDebtAccount().getCustomer().isPersonCustomer()) {
            return null;
        }
        PersonCustomer personCustomer = (PersonCustomer)this.invoiceEntry.getDebtAccount().getCustomer();
        return personCustomer.getAssociatedPerson();
    }

    public InvoiceEntry getInvoiceEntry() {
        return this.invoiceEntry;
    }

    public void setInvoiceEntry(InvoiceEntry invoiceEntry) {
        this.invoiceEntry = invoiceEntry;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getEntryType() {
        return this.entryType;
    }

    public void setEntryType(String entryType) {
        this.entryType = entryType;
    }

    public String getVersioningCreator() {
        return this.versioningCreator;
    }

    public void setVersioningCreator(String versioningCreator) {
        this.versioningCreator = versioningCreator;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime creationDate) {
        this.creationDate = creationDate;
    }

    public DateTime getEntryDate() {
        return this.entryDate;
    }

    public void setEntryDate(DateTime entryDate) {
        this.entryDate = entryDate;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getDebtAccountId() {
        return this.debtAccountId;
    }

    public void setDebtAccountId(String debtAccountId) {
        this.debtAccountId = debtAccountId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(String identificationType) {
        this.identificationType = identificationType;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public String getInstitutionalOrDefaultEmail() {
        return this.institutionalOrDefaultEmail;
    }

    public void setInstitutionalOrDefaultEmail(String institutionalOrDefaultEmail) {
        this.institutionalOrDefaultEmail = institutionalOrDefaultEmail;
    }

    public String getEmailForSendingEmails() {
        return this.emailForSendingEmails;
    }

    public void setEmailForSendingEmails(String emailForSendingEmails) {
        this.emailForSendingEmails = emailForSendingEmails;
    }

    public String getPersonalEmail() {
        return this.personalEmail;
    }

    public void setPersonalEmail(String personalEmail) {
        this.personalEmail = personalEmail;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    @Override
    public Integer getRegistrationNumber() {
        return this.registrationNumber;
    }

    @Override
    public void setRegistrationNumber(Integer registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    @Override
    public String getDegreeType() {
        return this.degreeType;
    }

    @Override
    public void setDegreeType(String degreeType) {
        this.degreeType = degreeType;
    }

    @Override
    public String getDegreeCode() {
        return this.degreeCode;
    }

    @Override
    public void setDegreeCode(String degreeCode) {
        this.degreeCode = degreeCode;
    }

    @Override
    public String getDegreeName() {
        return this.degreeName;
    }

    @Override
    public void setDegreeName(String degreeName) {
        this.degreeName = degreeName;
    }

    @Override
    public String getExecutionYear() {
        return this.executionYear;
    }

    @Override
    public void setExecutionYear(String executionYear) {
        this.executionYear = executionYear;
    }

    @Override
    public String getExecutionSemester() {
        return this.executionSemester;
    }

    @Override
    public void setExecutionSemester(String executionSemester) {
        this.executionSemester = executionSemester;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getInvoiceEntryDescription() {
        return this.invoiceEntryDescription;
    }

    public void setInvoiceEntryDescription(String invoiceEntryDescription) {
        this.invoiceEntryDescription = invoiceEntryDescription;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Boolean getDocumentExportationPending() {
        return this.documentExportationPending;
    }

    public void setDocumentExportationPending(Boolean documentExportationPending) {
        this.documentExportationPending = documentExportationPending;
    }

    public Boolean getAnnuled() {
        return this.annuled;
    }

    public void setAnnuled(Boolean annuled) {
        this.annuled = annuled;
    }

    public String getAnnuledReason() {
        return this.annuledReason;
    }

    public void setAnnuledReason(String annuledReason) {
        this.annuledReason = annuledReason;
    }

    public String getDebitEntryIdentification() {
        return this.debitEntryIdentification;
    }

    public void setDebitEntryIdentification(String debitEntryIdentification) {
        this.debitEntryIdentification = debitEntryIdentification;
    }

    public BigDecimal getAmountToPay() {
        return this.amountToPay;
    }

    public void setAmountToPay(BigDecimal amountToPay) {
        this.amountToPay = amountToPay;
    }

    public BigDecimal getNetExemptedAmount() {
        return this.netExemptedAmount;
    }

    public void setNetExemptedAmount(BigDecimal netExemptedAmount) {
        this.netExemptedAmount = netExemptedAmount;
    }

    public BigDecimal getOpenAmountToPay() {
        return this.openAmountToPay;
    }

    public void setOpenAmountToPay(BigDecimal openAmountToPay) {
        this.openAmountToPay = openAmountToPay;
    }

    public BigDecimal getOpenAmountWithInterestToDate() {
        return this.openAmountWithInterestToDate;
    }

    public void setOpenAmountWithInterestToDate(BigDecimal openAmountWithInterestToDate) {
        this.openAmountWithInterestToDate = openAmountWithInterestToDate;
    }

    public BigDecimal getPendingInterestAmount() {
        return this.pendingInterestAmount;
    }

    public void setPendingInterestAmount(BigDecimal pendingInterestAmount) {
        this.pendingInterestAmount = pendingInterestAmount;
    }

    public String getPayorDebtAccountVatNumber() {
        return this.payorDebtAccountVatNumber;
    }

    public void setPayorDebtAccountVatNumber(String payorDebtAccountVatNumber) {
        this.payorDebtAccountVatNumber = payorDebtAccountVatNumber;
    }

    public String getPayorDebtAccountName() {
        return this.payorDebtAccountName;
    }

    public void setPayorDebtAccountName(String payorDebtAccountName) {
        this.payorDebtAccountName = payorDebtAccountName;
    }

    @Override
    public LocalizedString getAgreement() {
        return this.agreement;
    }

    @Override
    public void setAgreement(LocalizedString agreement) {
        this.agreement = agreement;
    }

    @Override
    public LocalizedString getIngression() {
        return this.ingression;
    }

    @Override
    public void setIngression(LocalizedString ingression) {
        this.ingression = ingression;
    }

    @Override
    public Boolean getFirstTimeStudent() {
        return this.firstTimeStudent;
    }

    @Override
    public void setFirstTimeStudent(Boolean firstTimeStudent) {
        this.firstTimeStudent = firstTimeStudent;
    }

    @Override
    public Boolean getPartialRegime() {
        return this.partialRegime;
    }

    @Override
    public void setPartialRegime(Boolean partialRegime) {
        this.partialRegime = partialRegime;
    }

    @Override
    public String getStatutes() {
        return this.statutes;
    }

    @Override
    public void setStatutes(String statutes) {
        this.statutes = statutes;
    }

    @Override
    public Integer getNumberOfNormalEnrolments() {
        return this.numberOfNormalEnrolments;
    }

    @Override
    public void setNumberOfNormalEnrolments(Integer numberOfNormalEnrolments) {
        this.numberOfNormalEnrolments = numberOfNormalEnrolments;
    }

    @Override
    public Integer getNumberOfStandaloneEnrolments() {
        return this.numberOfStandaloneEnrolments;
    }

    @Override
    public void setNumberOfStandaloneEnrolments(Integer numberOfStandaloneEnrolments) {
        this.numberOfStandaloneEnrolments = numberOfStandaloneEnrolments;
    }

    @Override
    public Integer getNumberOfExtracurricularEnrolments() {
        return this.numberOfExtracurricularEnrolments;
    }

    @Override
    public void setNumberOfExtracurricularEnrolments(Integer numberOfExtracurricularEnrolments) {
        this.numberOfExtracurricularEnrolments = numberOfExtracurricularEnrolments;
    }

    @Override
    public String getTuitionPaymentPlan() {
        return this.tuitionPaymentPlan;
    }

    @Override
    public void setTuitionPaymentPlan(String tuitionPaymentPlan) {
        this.tuitionPaymentPlan = tuitionPaymentPlan;
    }

    @Override
    public String getTuitionPaymentPlanConditions() {
        return this.tuitionPaymentPlanConditions;
    }

    @Override
    public void setTuitionPaymentPlanConditions(String tuitionPaymentPlanConditions) {
        this.tuitionPaymentPlanConditions = tuitionPaymentPlanConditions;
    }

    public DateTime getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(DateTime closeDate) {
        this.closeDate = closeDate;
    }

    public BigDecimal getOpenAmountAtERPStartDate() {
        return this.openAmountAtERPStartDate;
    }

    public void setOpenAmountAtERPStartDate(BigDecimal openAmountAtERPStartDate) {
        this.openAmountAtERPStartDate = openAmountAtERPStartDate;
    }

    public Boolean getExportedInLegacyERP() {
        return this.exportedInLegacyERP;
    }

    public void setExportedInLegacyERP(Boolean exportedInLegacyERP) {
        this.exportedInLegacyERP = exportedInLegacyERP;
    }

    public String getLegacyERPCertificateDocumentReference() {
        return this.legacyERPCertificateDocumentReference;
    }

    public void setLegacyERPCertificateDocumentReference(String legacyERPCertificateDocumentReference) {
        this.legacyERPCertificateDocumentReference = legacyERPCertificateDocumentReference;
    }

    public LocalDate getErpCertificationDate() {
        return this.erpCertificationDate;
    }

    public void setErpCertificationDate(LocalDate erpCertificationDate) {
        this.erpCertificationDate = erpCertificationDate;
    }

    public String getErpCertificateDocumentReference() {
        return this.erpCertificateDocumentReference;
    }

    public void setErpCertificateDocumentReference(String erpCertificateDocumentReference) {
        this.erpCertificateDocumentReference = erpCertificateDocumentReference;
    }

    public String getErpCustomerId() {
        return this.erpCustomerId;
    }

    public void setErpCustomerId(String erpCustomerId) {
        this.erpCustomerId = erpCustomerId;
    }

    public String getErpPayorCustomerId() {
        return this.erpPayorCustomerId;
    }

    public void setErpPayorCustomerId(String erpPayorCustomerId) {
        this.erpPayorCustomerId = erpPayorCustomerId;
    }

    public String getCertifiedDocumentNumber() {
        return this.certifiedDocumentNumber;
    }

    public void setCertifiedDocumentNumber(String certifiedDocumentNumber) {
        this.certifiedDocumentNumber = certifiedDocumentNumber;
    }

    public LocalDate getCertifiedDocumentDate() {
        return this.certifiedDocumentDate;
    }

    public void setCertifiedDocumentDate(LocalDate certifiedDocumentDate) {
        this.certifiedDocumentDate = certifiedDocumentDate;
    }

    public String getOriginSettlementNoteForAdvancedCredit() {
        return this.originSettlementNoteForAdvancedCredit;
    }

    public void setOriginSettlementNoteForAdvancedCredit(String originSettlementNoteForAdvancedCredit) {
        this.originSettlementNoteForAdvancedCredit = originSettlementNoteForAdvancedCredit;
    }

    public String getDocumentObservations() {
        return this.documentObservations;
    }

    public void setDocumentObservations(String documentObservations) {
        this.documentObservations = documentObservations;
    }

    public String getDocumentTermsAndConditions() {
        return this.documentTermsAndConditions;
    }

    public void setDocumentTermsAndConditions(String documentTermsAndConditions) {
        this.documentTermsAndConditions = documentTermsAndConditions;
    }

    public String getFinantialEntityCode() {
        return this.finantialEntityCode;
    }

    public void setFinantialEntityCode(String finantialEntityCode) {
        this.finantialEntityCode = finantialEntityCode;
    }

    public LocalizedString getFinantialEntityName() {
        return this.finantialEntityName;
    }

    public void setFinantialEntityName(LocalizedString finantialEntityName) {
        this.finantialEntityName = finantialEntityName;
    }

    @Override
    public Degree getDegreeDomainObject() {
        return this.degreeDomainObject;
    }

    @Override
    public void setDegreeDomainObject(Degree degree) {
        this.degreeDomainObject = degree;
    }

    @Override
    public ExecutionYear getExecutionYearDomainObject() {
        return this.executionYearDomainObject;
    }

    @Override
    public void setExecutionYearDomainObject(ExecutionYear executionYear) {
        this.executionYearDomainObject = executionYear;
    }

    public String getEmptyColumnOne() {
        return this.emptyColumnOne;
    }

    public void setEmptyColumnOne(String emptyColumnOne) {
        this.emptyColumnOne = emptyColumnOne;
    }

    public String getEmptyColumnTwo() {
        return this.emptyColumnTwo;
    }

    public void setEmptyColumnTwo(String emptyColumnTwo) {
        this.emptyColumnTwo = emptyColumnTwo;
    }
}

