/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.services.evaluation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices;
import org.fenixedu.academic.dto.evaluation.markSheet.report.CompetenceCourseSeasonReport;
import org.fenixedu.academic.dto.evaluation.markSheet.report.ExecutionCourseSeasonReport;
import org.fenixedu.academic.services.evaluation.MarkSheetStatusReportService$callable$iterateCompetenceCoursesBlock;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class MarkSheetStatusReportService {
    private static final int THREAD_BLOCK_SIZE = 10;
    public static final Advice advice$iterateCompetenceCoursesBlock = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

    public static List<ExecutionCourseSeasonReport> getReportsForExecutionCourse(ExecutionCourse executionCourse) {
        ArrayList result = Lists.newArrayList();
        for (EvaluationSeason season : EvaluationSeasonServices.findByActive(true).collect(Collectors.toList())) {
            ArrayListMultimap reportsByEvaluationDate = ArrayListMultimap.create();
            for (CompetenceCourseSeasonReport competenceCourseSeasonReport : MarkSheetStatusReportService.iterateCompetenceCourses(executionCourse.getExecutionPeriod(), executionCourse.getCompetenceCourses(), Sets.newHashSet((Object[])new EvaluationSeason[]{season}))) {
                reportsByEvaluationDate.put((Object)competenceCourseSeasonReport.getEvaluationDate(), (Object)competenceCourseSeasonReport);
            }
            for (Map.Entry entry : reportsByEvaluationDate.asMap().entrySet()) {
                ExecutionCourseSeasonReport report = new ExecutionCourseSeasonReport(executionCourse, season, (LocalDate)entry.getKey(), (Collection)entry.getValue());
                if (report.getTotalStudents() <= 0) continue;
                result.add(report);
            }
        }
        return result;
    }

    public static List<CompetenceCourseSeasonReport> getReportsForCompetenceCourses(ExecutionInterval executionInterval) {
        return MarkSheetStatusReportService.getReportsForCompetenceCourses(executionInterval, EvaluationSeasonServices.findByActive(true).collect(Collectors.toSet()));
    }

    public static List<CompetenceCourseSeasonReport> getReportsForCompetenceCourses(ExecutionInterval executionInterval, Set<EvaluationSeason> seasons) {
        Stream<CompetenceCourse> allCompetenceCourses = Stream.concat(executionInterval.getAssociatedExecutionCoursesSet().stream().flatMap(eC -> eC.getCompetenceCourses().stream()), executionInterval.getEnrolmentEvaluationsSet().stream().map(eE -> eE.getEnrolment().getCurricularCourse().getCompetenceCourse()));
        return MarkSheetStatusReportService.iterateCompetenceCourses(executionInterval, allCompetenceCourses.collect(Collectors.toSet()), seasons);
    }

    private static List<CompetenceCourseSeasonReport> iterateCompetenceCourses(ExecutionInterval interval, Set<CompetenceCourse> competenceCourses, Set<EvaluationSeason> seasons) {
        List errors = Collections.synchronizedList(new ArrayList());
        List<CompetenceCourseSeasonReport> result = Collections.synchronizedList(new ArrayList());
        ArrayList<CompetenceCourse> toProcess = new ArrayList<CompetenceCourse>(competenceCourses);
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors() / 4, 1));
        int startIndex = 0;
        while (startIndex < toProcess.size()) {
            int endIndex = Math.min(startIndex + 10, toProcess.size());
            List block = toProcess.subList(startIndex, endIndex);
            executor.submit(() -> {
                try {
                    result.addAll(MarkSheetStatusReportService.iterateCompetenceCoursesBlock(interval, block, seasons));
                }
                catch (Throwable e) {
                    errors.add(e.getCause() != null ? e.getCause() : e);
                }
            });
            startIndex = endIndex;
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            throw new RuntimeException(errors.stream().map(Throwable::getMessage).distinct().collect(Collectors.joining("\n")));
        }
        return result;
    }

    private static List<CompetenceCourseSeasonReport> iterateCompetenceCoursesBlock(ExecutionInterval executionInterval, Collection<CompetenceCourse> collection, Set<EvaluationSeason> set) {
        return (List)advice$iterateCompetenceCoursesBlock.perform((Callable)new MarkSheetStatusReportService$callable$iterateCompetenceCoursesBlock(executionInterval, collection, set));
    }

    static /* synthetic */ List<CompetenceCourseSeasonReport> advised$iterateCompetenceCoursesBlock(ExecutionInterval interval, Collection<CompetenceCourse> toProcess, Set<EvaluationSeason> seasons) {
        return toProcess.stream().flatMap(iter -> MarkSheetStatusReportService.getReportsForCompetenceCourse(interval, iter, seasons).stream()).toList();
    }

    public static List<CompetenceCourseSeasonReport> getReportsForCompetenceCourse(ExecutionInterval interval, CompetenceCourse toProcess, Set<EvaluationSeason> seasons) {
        return seasons.stream().map(s -> MarkSheetStatusReportService.generateReport(interval, toProcess, s)).filter(r -> r.getTotalStudents() > 0).collect(Collectors.toList());
    }

    private static CompetenceCourseSeasonReport generateReport(ExecutionInterval interval, CompetenceCourse toProcess, EvaluationSeason season) {
        CompetenceCourseSeasonReport result = new CompetenceCourseSeasonReport(toProcess, season, interval, null);
        AtomicInteger notEvaluatedStudents = new AtomicInteger();
        toProcess.getExecutionCoursesByExecutionPeriod(interval).forEach(i -> notEvaluatedStudents.addAndGet(CompetenceCourseMarkSheet.getExecutionCourseEnrolmentsNotInAnyMarkSheet(interval, toProcess, i, season, null, Set.of()).size()));
        result.setNotEvaluatedStudents(notEvaluatedStudents.get());
        HashSet enrolments = Sets.newHashSet();
        toProcess.getAssociatedCurricularCoursesSet().forEach(i -> enrolments.addAll(i.getEnrolmentsByAcademicInterval(interval.getAcademicInterval())));
        for (EnrolmentEvaluation evaluation : interval.getEnrolmentEvaluationsSet()) {
            if (evaluation.getEvaluationSeason() != season || evaluation.getEnrolment().getCurricularCourse().getCompetenceCourse() != toProcess) continue;
            enrolments.add(evaluation.getEnrolment());
        }
        int evaluatedStudents = 0;
        for (Enrolment enrolment : enrolments) {
            Optional evaluation = enrolment.getEnrolmentEvaluation(season, interval, null);
            if (!evaluation.isPresent() || ((EnrolmentEvaluation)evaluation.get()).getCompetenceCourseMarkSheet() == null) continue;
            ++evaluatedStudents;
        }
        result.setEvaluatedStudents(evaluatedStudents);
        for (CompetenceCourseMarkSheet ccm : CompetenceCourseMarkSheet.findBy(interval, toProcess, null, season, null, null, null, null).collect(Collectors.toSet())) {
            if (ccm.getEnrolmentEvaluationSet().isEmpty() && ccm.getExecutionCourseEnrolmentsNotInAnyMarkSheet().isEmpty()) continue;
            if (ccm.isConfirmed()) {
                result.incMarksheetsConfirmed();
                continue;
            }
            if (ccm.isEdition()) {
                result.incMarksheetsInEdition();
                continue;
            }
            if (!ccm.isSubmitted()) continue;
            result.incMarksheetsSubmitted();
        }
        return result;
    }
}

