/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.season.rule;

import java.util.Collection;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.degreeStructure.CourseLoadType;
import org.fenixedu.academic.domain.evaluation.season.rule.EvaluationSeasonRule;
import org.fenixedu.academic.domain.evaluation.season.rule.EvaluationSeasonShiftType_Base;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.commons.i18n.LocalizedString;

public class EvaluationSeasonShiftType
extends EvaluationSeasonShiftType_Base {
    public static EvaluationSeasonRule create(EvaluationSeason season, Collection<CourseLoadType> courseLoadTypes) {
        EvaluationSeasonShiftType result = new EvaluationSeasonShiftType();
        result.init(season);
        result.getCourseLoadTypesSet().addAll(courseLoadTypes);
        return result;
    }

    public boolean isUpdatable() {
        return true;
    }

    public LocalizedString getDescriptionI18N() {
        LocalizedString.Builder builder = AcademicExtensionsUtil.bundleI18N(((Object)((Object)this)).getClass().getSimpleName(), new String[0]).builder();
        builder.append(this.getCourseLoadTypesSet().stream().map(i -> String.format("%s [%s]", i.getName().getContent(), i.getInitials().getContent())).collect(Collectors.joining("; ")), ": ");
        return builder.build();
    }

    public void delete() {
        this.getCourseLoadTypesSet().clear();
        super.delete();
    }
}

