/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.config;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.evaluation.config.MarkSheetSettings$callable$create;
import org.fenixedu.academic.domain.evaluation.config.MarkSheetSettings$callable$edit;
import org.fenixedu.academic.domain.evaluation.config.MarkSheetSettings_Base;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.organizationalStructure.Unit_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MarkSheetSettings
extends MarkSheetSettings_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected MarkSheetSettings() {
        this.setRoot(Bennu.getInstance());
    }

    public static void init() {
        Unit unit = UnitUtils.readInstitutionUnit();
        if (unit != null && MarkSheetSettings.findAll().findAny().isEmpty()) {
            MarkSheetSettings.create(unit);
        }
    }

    @Deprecated
    public static MarkSheetSettings getInstance() {
        return MarkSheetSettings.findAll().findFirst().orElseGet(() -> MarkSheetSettings.create(UnitUtils.readInstitutionUnit()));
    }

    public static MarkSheetSettings create(Unit unit) {
        return (MarkSheetSettings)((Object)advice$create.perform((Callable)new MarkSheetSettings$callable$create(unit)));
    }

    static /* synthetic */ MarkSheetSettings advised$create(Unit unit) {
        MarkSheetSettings markSheetSettings = new MarkSheetSettings();
        markSheetSettings.setUnit(unit);
        return markSheetSettings;
    }

    public void edit(boolean bl, int n, boolean bl2, boolean bl3) {
        Object object = advice$edit.perform((Callable)new MarkSheetSettings$callable$edit(this, bl, n, bl2, bl3));
    }

    static /* synthetic */ void advised$edit(MarkSheetSettings this_, boolean allowTeacherToChooseCertifier, int requiredNumberOfShifts, boolean limitCertifierToResponsibleTeacher, boolean limitCreationToResponsibleTeacher) {
        super.setAllowTeacherToChooseCertifier(allowTeacherToChooseCertifier);
        super.setRequiredNumberOfShifts(requiredNumberOfShifts);
        super.setLimitCertifierToResponsibleTeacher(limitCertifierToResponsibleTeacher);
        super.setLimitCreationToResponsibleTeacher(limitCreationToResponsibleTeacher);
    }

    public void setUnit(Unit unit) {
        if (unit == null) {
            throw new AcademicExtensionsDomainException("error.MarkSheetSettings.unit.required", new String[0]);
        }
        if (unit.getMarkSheetSettings() != null && unit.getMarkSheetSettings() != this) {
            throw new AcademicExtensionsDomainException("error.MarkSheetSettings.unit.already.has.markSheetSettings", new String[0]);
        }
        super.setUnit(unit);
    }

    public void delete() {
        if (this.getTemplateFile() != null) {
            this.getTemplateFile().delete();
        }
        super.setUnit(null);
        super.setRoot(null);
        super.deleteDomainObject();
    }

    public boolean isNotAllowedShifts() {
        return this.getRequiredNumberOfShifts() == 0;
    }

    public boolean isMarkSheetTemplateCodeDefined() {
        return StringUtils.isNotBlank((CharSequence)this.getMarkSheetTemplateCode());
    }

    public static Stream<MarkSheetSettings> findAll() {
        return Bennu.getInstance().getMarkSheetSettingsSet().stream();
    }

    public static Optional<MarkSheetSettings> findByCompetenceCourse(CompetenceCourse competenceCourse) {
        return Optional.ofNullable(competenceCourse).map(CompetenceCourse::getCompetenceCourseGroupUnit).flatMap(groupUnit -> Optional.ofNullable(groupUnit.getMarkSheetSettings()).or(() -> {
            List parentUnits = groupUnit.getParentUnitsPath();
            Collections.reverse(parentUnits);
            return parentUnits.stream().map(Unit_Base::getMarkSheetSettings).filter(Objects::nonNull).findFirst();
        }));
    }
}

