/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.Collection;
import java.util.HashSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.curricularRules.BlockEnrolmentByPreviousEnrolmentConditions;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnroledOptionalEnrolment;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;

public class BlockEnrolmentByPreviousEnrolmentConditionsExecutor
extends CurricularRuleExecutor {
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate degreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (!this.canApplyRule(enrolmentContext, curricularRule) || !degreeModuleToEvaluate.isLeaf()) {
            return RuleResult.createNA((DegreeModule)degreeModuleToEvaluate.getDegreeModule());
        }
        BlockEnrolmentByPreviousEnrolmentConditions rule = (BlockEnrolmentByPreviousEnrolmentConditions)curricularRule;
        if (rule.hasPreviousEnrolmentMatchingConditions(enrolmentContext.getRegistration(), this.getCurricularCoursesToCheck(rule, degreeModuleToEvaluate), degreeModuleToEvaluate.getExecutionInterval())) {
            String message = AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.BlockEnrolmentByPreviousEnrolmentConditionsExecutor.error.found.previous.enrolments.matching.conditions", degreeModuleToEvaluate.getName(), rule.getPreviousEnrolmentState().getDescription());
            return degreeModuleToEvaluate.isEnroled() ? RuleResult.createImpossibleWithLiteralMessage((DegreeModule)degreeModuleToEvaluate.getDegreeModule(), (String)message) : RuleResult.createFalseWithLiteralMessage((DegreeModule)degreeModuleToEvaluate.getDegreeModule(), (String)message);
        }
        return RuleResult.createTrue((DegreeModule)degreeModuleToEvaluate.getDegreeModule());
    }

    protected RuleResult executeEnrolmentPrefilter(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (!this.canApplyRule(enrolmentContext, curricularRule) || !sourceDegreeModuleToEvaluate.isLeaf()) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        BlockEnrolmentByPreviousEnrolmentConditions rule = (BlockEnrolmentByPreviousEnrolmentConditions)curricularRule;
        if (rule.hasPreviousEnrolmentMatchingConditions(enrolmentContext.getRegistration(), this.getCurricularCoursesToCheck(rule, sourceDegreeModuleToEvaluate), sourceDegreeModuleToEvaluate.getExecutionInterval())) {
            return RuleResult.createFalse((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    private Collection<CurricularCourse> getCurricularCoursesToCheck(BlockEnrolmentByPreviousEnrolmentConditions rule, IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        if (degreeModuleToEvaluate instanceof OptionalDegreeModuleToEnrol) {
            result.addAll(rule.expandCurricularCourses(((OptionalDegreeModuleToEnrol)degreeModuleToEvaluate).getCurricularCourse()));
        } else if (degreeModuleToEvaluate instanceof EnroledOptionalEnrolment) {
            result.add((CurricularCourse)((EnroledOptionalEnrolment)degreeModuleToEvaluate).getOptionalCurricularCourse());
        }
        result.addAll(rule.expandCurricularCourses((CurricularCourse)degreeModuleToEvaluate.getDegreeModule()));
        return result;
    }
}

