/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.IntStream;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsInCurricularPeriod$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsInCurricularPeriod_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreditsInCurricularPeriod
extends CreditsInCurricularPeriod_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected CreditsInCurricularPeriod() {
    }

    public static CreditsInCurricularPeriod createForYearInterval(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer yearMin, Integer yearMax) {
        return CreditsInCurricularPeriod.create(configuration, credits, null, yearMin, yearMax);
    }

    private static CreditsInCurricularPeriod create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n, Integer n2, Integer n3) {
        return (CreditsInCurricularPeriod)((Object)advice$create.perform((Callable)new CreditsInCurricularPeriod$callable$create(curricularPeriodConfiguration, bigDecimal, n, n2, n3)));
    }

    static /* synthetic */ CreditsInCurricularPeriod advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer semester, Integer yearMin, Integer yearMax) {
        CreditsInCurricularPeriod result = new CreditsInCurricularPeriod();
        result.init(configuration, credits, semester, yearMin, yearMax);
        return result;
    }

    private void init(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer semester, Integer yearMin, Integer yearMax) {
        super.init(configuration, credits, semester);
        this.setYearMin(yearMin);
        this.setYearMax(yearMax);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getYearMin() == null) {
            throw new DomainException("error." + ((Object)((Object)this)).getClass().getSimpleName() + ".yearMin.required", new String[0]);
        }
    }

    private boolean isForYear() {
        return this.getYearMin() != null && this.getYearMax() != null && this.getYearMin().intValue() == this.getYearMax().intValue();
    }

    public String getLabel() {
        BigDecimal credits = this.getCredits();
        if (this.getSemester() != null) {
            return this.getStatuteTypesLabelPrefix() + BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName() + ".semester"), (String[])new String[]{credits.toString(), this.getSemester().toString(), this.getYearMin().toString()});
        }
        if (this.isForYear()) {
            return this.getStatuteTypesLabelPrefix() + BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName() + ".year"), (String[])new String[]{credits.toString(), this.getYearMin().toString()});
        }
        int configurationYear = this.getConfiguration().getCurricularPeriod().getChildOrder();
        int degreeDuration = this.getConfiguration().getDegreeCurricularPlan().getDegreeDuration();
        boolean simple = credits.equals(BigDecimal.ZERO) && this.getYearMin() == configurationYear + 1 && this.getYearMax() == degreeDuration;
        return this.getStatuteTypesLabelPrefix() + BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName() + (simple ? ".simple" : "")), (String[])new String[]{credits.toString(), this.getYearMin().toString(), this.getYearMax().toString()});
    }

    public RuleResult execute(EnrolmentContext enrolmentContext) {
        if (!this.isToEvaluate(enrolmentContext)) {
            return this.createNA();
        }
        Map<Integer, BigDecimal> creditsByYear = CurricularPeriodServices.mapYearCreditsForPeriods(enrolmentContext, this.getAcademicPeriodOrdersSet());
        BigDecimal total = IntStream.rangeClosed(this.getYearMin(), this.getYearMax()).boxed().map(year -> creditsByYear.getOrDefault(year, BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return total.compareTo(this.getCredits()) <= 0 ? this.createTrue() : this.createFalseLabelled(total);
    }

    private boolean isToEvaluate(EnrolmentContext enrolmentContext) {
        if (!this.hasValidStatute(enrolmentContext)) {
            return false;
        }
        if (this.getApplyToFlunkedStudents() != null && this.getApplyToFlunkedStudents() != RegistrationServices.isFlunkedUsingCurricularYear(enrolmentContext.getRegistration(), enrolmentContext.getExecutionYear())) {
            return false;
        }
        return this.getApplyToPartialRegime() == null || this.getApplyToPartialRegime().booleanValue() == enrolmentContext.getRegistration().isPartialRegime(enrolmentContext.getExecutionYear());
    }
}

