/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.gradingTable;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableSettings$callable$getInstance;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableSettings_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GradingTableSettings
extends GradingTableSettings_Base {
    private static final Integer DEFAULT_MIN_SAMPLE_SIZE;
    private static final Integer DEFAULT_MIN_PAST_YEARS;
    private static final Integer DEFAULT_MAX_PAST_YEARS;
    public static final Advice advice$getInstance;

    private GradingTableSettings() {
        this.setBennu(Bennu.getInstance());
    }

    private GradingTableSettings(Integer minSampleSize, Integer minPastYears, Integer maxPastYears) {
        this();
        this.setMinSampleSize(minSampleSize);
        this.setMinPastYears(minPastYears);
        this.setMaxPastYears(maxPastYears);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getMinSampleSize() == null) {
            throw new AcademicExtensionsDomainException("error.GradingTableSettings.minSampleSize.required", new String[0]);
        }
        if (this.getMinPastYears() == null) {
            throw new AcademicExtensionsDomainException("error.GradingTableSettings.minPastYears.required", new String[0]);
        }
        if (this.getMaxPastYears() == null) {
            throw new AcademicExtensionsDomainException("error.GradingTableSettings.maxPastYears.required", new String[0]);
        }
        if (this.getMinSampleSize().compareTo(DEFAULT_MIN_SAMPLE_SIZE) < 0) {
            throw new AcademicExtensionsDomainException("error.GradingTableSettings.minSampleSize.invalid", new String[0]);
        }
        if (this.getMaxPastYears().compareTo(this.getMinPastYears()) < 0) {
            throw new AcademicExtensionsDomainException("error.GradingTableSettings.maxPastYears.invalid", new String[0]);
        }
    }

    public static GradingTableSettings getInstance() {
        return (GradingTableSettings)((Object)advice$getInstance.perform((Callable)new GradingTableSettings$callable$getInstance()));
    }

    static /* synthetic */ GradingTableSettings advised$getInstance() {
        GradingTableSettings settings = Bennu.getInstance().getGradingTableSettings();
        if (settings == null) {
            settings = new GradingTableSettings(DEFAULT_MIN_SAMPLE_SIZE, DEFAULT_MIN_PAST_YEARS, DEFAULT_MAX_PAST_YEARS);
        }
        return settings;
    }

    public static int getMinimumSampleSize() {
        return GradingTableSettings.getInstance().getMinSampleSize() == null ? DEFAULT_MIN_SAMPLE_SIZE : GradingTableSettings.getInstance().getMinSampleSize();
    }

    public static int getMinimumPastYears() {
        return GradingTableSettings.getInstance().getMinPastYears() == null ? DEFAULT_MIN_PAST_YEARS : GradingTableSettings.getInstance().getMinPastYears();
    }

    public static int getMaximumPastYears() {
        return GradingTableSettings.getInstance().getMaxPastYears() == null ? DEFAULT_MAX_PAST_YEARS : GradingTableSettings.getInstance().getMaxPastYears();
    }

    public void edit(Integer minSampleSize, Integer minPastYears, Integer maxPastYears) {
        this.setMinSampleSize(minSampleSize);
        this.setMinPastYears(minPastYears);
        this.setMaxPastYears(maxPastYears);
        this.checkRules();
    }

    public static Set<DegreeType> getApplicableDegreeTypes() {
        return GradingTableSettings.getInstance().getApplicableDegreeTypesSet();
    }

    static {
        advice$getInstance = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        DEFAULT_MIN_SAMPLE_SIZE = 30;
        DEFAULT_MIN_PAST_YEARS = 3;
        DEFAULT_MAX_PAST_YEARS = 5;
    }
}

