/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.gradingTable;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.curriculum.grade.GradeScale;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.student.gradingTable.CourseGradingTable_Base;
import org.fenixedu.academic.domain.student.gradingTable.DefaultGradingTable;
import org.fenixedu.academic.domain.student.gradingTable.GradingTable;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableData;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableGenerator;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableSettings;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.fenixframework.CallableWithoutException;

public class CourseGradingTable
extends CourseGradingTable_Base {
    public void delete() {
        this.setCompetenceCourse(null);
        this.setCurriculumLine(null);
        super.delete();
    }

    public static Stream<CourseGradingTable> findAll() {
        return Bennu.getInstance().getGradingTablesSet().stream().filter(CourseGradingTable.class::isInstance).map(CourseGradingTable.class::cast);
    }

    public static Set<CourseGradingTable> find(ExecutionYear ey) {
        return CourseGradingTable.find(ey, false);
    }

    public static Set<CourseGradingTable> find(ExecutionYear ey, boolean includeLegacy) {
        return ey.getGradingTablesSet().stream().filter(CourseGradingTable.class::isInstance).map(CourseGradingTable.class::cast).filter(cgt -> includeLegacy || cgt.getCurriculumLine() == null).collect(Collectors.toSet());
    }

    public static CourseGradingTable find(ExecutionYear ey, CompetenceCourse cc) {
        return cc == null ? null : (CourseGradingTable)cc.getCourseGradingTablesSet().stream().filter(cgt -> cgt.getCurriculumLine() == null).filter(cgt -> cgt.getExecutionYear() == ey).findAny().orElse(null);
    }

    public static CourseGradingTable find(CurriculumLine line) {
        EnrolmentEvaluation evaluation;
        String grade;
        String string = grade = ((ICurriculumEntry)line).getGrade().isEmpty() ? "-" : ((ICurriculumEntry)line).getGrade().getValue();
        if (line.getCourseGradingTable() != null && line.getCourseGradingTable().getEctsGrade(grade) != null) {
            return line.getCourseGradingTable();
        }
        ExecutionYear year = line.getExecutionYear();
        if (line instanceof Enrolment && (evaluation = ((Enrolment)line).getFinalEnrolmentEvaluation()) != null) {
            year = evaluation.getExecutionPeriod().getExecutionYear();
        }
        return CourseGradingTable.find(year, line.getCurricularCourse().getCompetenceCourse());
    }

    public static String getEctsGrade(ICurriculumEntry entry) {
        CourseGradingTable table;
        CurriculumLine line;
        String grade = entry.getGrade().isEmpty() ? "-" : entry.getGrade().getValue();
        String ectsGrade = null;
        if (entry instanceof ExternalEnrolment) {
            ExternalEnrolment externalEnrolment = (ExternalEnrolment)entry;
            ectsGrade = externalEnrolment.getEctsGrade() != null && !externalEnrolment.getEctsGrade().isEmpty() ? externalEnrolment.getEctsGrade().getValue() : DefaultGradingTable.getDefaultGradingTable().getEctsGrade(grade);
        } else if (entry instanceof CurriculumLine && (line = (CurriculumLine)entry).getCurricularCourse() != null && (table = CourseGradingTable.find(line)) != null) {
            ectsGrade = table.getEctsGrade(grade);
        }
        return ectsGrade != null ? ectsGrade : "-";
    }

    public static boolean isApplicable(CurriculumLine line) {
        return GradingTableSettings.getApplicableDegreeTypes().contains(line.getCurricularCourse().getDegreeType());
    }

    public static Set<CourseGradingTable> generate(final ExecutionYear executionYear) {
        HashSet<CourseGradingTable> allTables = new HashSet<CourseGradingTable>();
        for (final CompetenceCourse cc : Bennu.getInstance().getCompetenceCoursesSet()) {
            if (!cc.hasActiveScopesInExecutionYear(executionYear).booleanValue()) continue;
            CourseGradingTable table = CourseGradingTable.find(executionYear, cc);
            if (table == null) {
                CallableWithoutException<CourseGradingTable> workerLogic = new CallableWithoutException<CourseGradingTable>(){

                    public CourseGradingTable call() {
                        CourseGradingTable table = new CourseGradingTable();
                        table.setExecutionYear(executionYear);
                        table.setCompetenceCourse(cc);
                        table.compileData();
                        return table;
                    }
                };
                GradingTable.GeneratorWorker<CourseGradingTable> worker = new GradingTable.GeneratorWorker<CourseGradingTable>(workerLogic);
                worker.start();
                try {
                    worker.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                allTables.add(worker.getTable());
                continue;
            }
            allTables.add(table);
        }
        return allTables;
    }

    public void compileData() {
        GradingTableData tableData = new GradingTableData();
        this.setData(tableData);
        List<Enrolment> harvestEnrolmentsUsedInSample = this.harvestEnrolmentsUsedInSample();
        List<BigDecimal> sample = harvestEnrolmentsUsedInSample.stream().map(e -> e.getGrade()).filter(e -> this.isNumeric((Grade)e)).map(e -> e.getNumericValue().setScale(0, RoundingMode.HALF_UP)).collect(Collectors.toList());
        String harvestEnrolmentsUsedInSampleData = harvestEnrolmentsUsedInSample.stream().map(e -> this.enrolmentStringData((Enrolment)e)).reduce((a, c) -> a + "\n" + c).orElseGet(() -> "");
        this.setStudentSampleData(harvestEnrolmentsUsedInSampleData);
        if (sample.isEmpty()) {
            GradingTableGenerator.defaultData((GradingTable)((Object)this));
            this.setCopied(true);
        } else {
            GradingTableGenerator.generateTableDataImprovement((GradingTable)((Object)this), sample);
        }
        this.checkUniquenessOfTable();
    }

    private void checkUniquenessOfTable() {
        if (CourseGradingTable.find(this.getExecutionYear()).stream().anyMatch(t -> t != this && t.getCompetenceCourse() == this.getCompetenceCourse())) {
            throw new AcademicExtensionsDomainException("error.CourseGradingTable.already.exists", this.getExecutionYear().getQualifiedName(), this.getCompetenceCourse().getCode() + " - " + this.getCompetenceCourse().getName());
        }
    }

    private boolean isNumeric(Grade grade) {
        if (grade == null) {
            return false;
        }
        try {
            Double.parseDouble(grade.getValue());
            return grade.getNumericValue() != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String enrolmentStringData(Enrolment e) {
        Integer studentNumber = e.getStudent().getNumber();
        String studentName = e.getStudent().getName();
        String competenceCourseCode = e.getCurricularCourse().getCompetenceCourse().getCode();
        String executionYearName = e.getExecutionYear().getQualifiedName();
        Integer finalGrade = this.isNumeric(e.getGrade()) ? e.getGrade().getNumericValue().setScale(0, RoundingMode.HALF_UP).intValue() : 0;
        return String.format("%s\t%s\t%s\t%s\t%s", studentNumber, studentName, competenceCourseCode, executionYearName, finalGrade);
    }

    private List<Enrolment> harvestEnrolmentsUsedInSample() {
        ArrayList<Enrolment> sample = new ArrayList<Enrolment>();
        int coveredYears = 0;
        boolean sampleReady = false;
        ExecutionYear samplingYear = this.getExecutionYear().getPrevious() instanceof ExecutionYear ? (ExecutionYear)this.getExecutionYear().getPrevious() : null;
        GradeScale gradeScale = null;
        while (samplingYear != null) {
            for (CurricularCourse curricularCourse : this.getCompetenceCourse().getAssociatedCurricularCoursesSet()) {
                if (!GradingTableSettings.getApplicableDegreeTypes().contains(curricularCourse.getDegreeType())) continue;
                List enrolmentsByExecutionYear = curricularCourse.getEnrolmentsByExecutionYear(samplingYear);
                for (Enrolment enrolment : enrolmentsByExecutionYear) {
                    if (!enrolment.isApproved() || !enrolment.getGrade().isNumeric()) continue;
                    if (gradeScale != null) {
                        if (enrolment.getGrade().getGradeScale() != gradeScale) {
                            throw new DomainException("error.CourseGradingTable.harvestEnrolmentsUsedInSample.gradeScale.mismatch", new String[0]);
                        }
                    } else {
                        gradeScale = enrolment.getGrade().getGradeScale();
                    }
                    sample.add(enrolment);
                }
            }
            sampleReady = ++coveredYears >= GradingTableSettings.getMinimumPastYears() && sample.size() >= GradingTableSettings.getMinimumSampleSize() && coveredYears <= GradingTableSettings.getMaximumPastYears();
            samplingYear = coveredYears < GradingTableSettings.getMaximumPastYears() && !sampleReady && samplingYear.getPrevious() instanceof ExecutionYear ? (ExecutionYear)samplingYear.getPrevious() : null;
        }
        return sampleReady ? sample : Collections.emptyList();
    }
}

