/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.mobility;

import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.mobility.MobilityProgrammeLevel_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;

public class MobilityProgrammeLevel
extends MobilityProgrammeLevel_Base {
    private MobilityProgrammeLevel() {
        this.setBennu(Bennu.getInstance());
    }

    protected MobilityProgrammeLevel(String code, LocalizedString name, boolean otherLevel) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setOtherLevel(otherLevel);
    }

    public boolean isOtherLevel() {
        return this.getOtherLevel();
    }

    public static MobilityProgrammeLevel create(String code, LocalizedString name, boolean otherLevel) {
        return new MobilityProgrammeLevel(code, name, otherLevel);
    }

    public boolean isDeletable() {
        return this.getMobilityRegistrationInformationsSet().isEmpty() && this.getMobilityRegistrationInformationsForOriginSet().isEmpty();
    }

    public void delete() {
        if (!this.isDeletable()) {
            throw new AcademicExtensionsDomainException("error.MobilityProgrammeLevel.cannot.delete", new String[0]);
        }
        this.setBennu(null);
        super.deleteDomainObject();
    }
}

