/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.mobility;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.mobility.MobilityActivityType$callable$create;
import org.fenixedu.academic.domain.student.mobility.MobilityActivityType$callable$delete;
import org.fenixedu.academic.domain.student.mobility.MobilityActivityType$callable$edit;
import org.fenixedu.academic.domain.student.mobility.MobilityActivityType_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MobilityActivityType
extends MobilityActivityType_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected MobilityActivityType() {
        this.setBennu(Bennu.getInstance());
    }

    protected MobilityActivityType(String code, LocalizedString name, boolean active) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setActive(active);
    }

    public void setCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            throw new AcademicExtensionsDomainException("error.MobilityActivityType.code.required", new String[0]);
        }
        MobilityActivityType foundByCode = MobilityActivityType.findByCode(code);
        if (foundByCode != null && foundByCode != this) {
            throw new AcademicExtensionsDomainException("error.MobilityActivityType.code.duplicated", new String[0]);
        }
        super.setCode(code);
    }

    public void setName(LocalizedString name) {
        if (name == null || Strings.isNullOrEmpty((String)name.getContent())) {
            throw new AcademicExtensionsDomainException("error.MobilityActivityType.name.required", new String[0]);
        }
        super.setName(name);
    }

    public boolean isActive() {
        return this.getActive();
    }

    public void edit(String string, LocalizedString localizedString, boolean bl) {
        Object object = advice$edit.perform((Callable)new MobilityActivityType$callable$edit(this, string, localizedString, bl));
    }

    static /* synthetic */ void advised$edit(MobilityActivityType this_, String code, LocalizedString name, boolean active) {
        this_.setCode(code);
        this_.setName(name);
        this_.setActive(active);
    }

    public static final MobilityActivityType create(String string, LocalizedString localizedString, boolean bl) {
        return (MobilityActivityType)((Object)advice$create.perform((Callable)new MobilityActivityType$callable$create(string, localizedString, bl)));
    }

    static final /* synthetic */ MobilityActivityType advised$create(String code, LocalizedString name, boolean active) {
        return new MobilityActivityType(code, name, active);
    }

    public static Set<MobilityActivityType> findAll() {
        return Bennu.getInstance().getMobilityActivityTypesSet();
    }

    public static Set<MobilityActivityType> findAllActive() {
        return Sets.filter(MobilityActivityType.findAll(), (Predicate)new Predicate<MobilityActivityType>(){

            public boolean apply(MobilityActivityType arg) {
                return arg.isActive();
            }
        });
    }

    public static final MobilityActivityType findByCode(String code) {
        MobilityActivityType result = null;
        Set<MobilityActivityType> readAll = MobilityActivityType.findAll();
        for (MobilityActivityType mobilityActivityType : readAll) {
            if (code.equals(mobilityActivityType.getCode()) && result != null) {
                throw new AcademicExtensionsDomainException("error.MobilityActivityType.code.duplicated", new String[0]);
            }
            if (!code.equals(mobilityActivityType.getCode())) continue;
            result = mobilityActivityType;
        }
        return result;
    }

    public boolean isDeletable() {
        return this.getMobilityRegistrationInformationsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new MobilityActivityType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(MobilityActivityType this_) {
        if (!this_.isDeletable()) {
            throw new AcademicExtensionsDomainException("error.MobilityActivityType.cannot.delete", new String[0]);
        }
        this_.setBennu(null);
        this_.deleteDomainObject();
    }
}

