/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.EnrolmentsInCurricularYear$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.EnrolmentsInCurricularYear_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EnrolmentsInCurricularYear
extends EnrolmentsInCurricularYear_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected EnrolmentsInCurricularYear() {
    }

    public RuleResult execute(Curriculum curriculum) {
        ExecutionYear executionYear = curriculum.getExecutionYear() == null ? ExecutionYear.findCurrent((AcademicCalendarRootEntry)curriculum.getStudentCurricularPlan().getRegistration().getDegree().getCalendar()) : curriculum.getExecutionYear();
        int curricularYear = this.getYearMin();
        if (curriculum.getStudentCurricularPlan().getEnrolmentsByExecutionYear(executionYear).stream().filter(x -> CurricularPeriodServices.getCurricularYear((CurriculumLine)x) == curricularYear).count() >= this.getValue().longValue()) {
            return this.createTrue();
        }
        return this.createFalseLabelled();
    }

    public String getLabel() {
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName()), (String[])new String[]{this.getValue().toString(), String.valueOf(this.getYearMin())});
    }

    public static EnrolmentsInCurricularYear create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n) {
        return (EnrolmentsInCurricularYear)((Object)advice$create.perform((Callable)new EnrolmentsInCurricularYear$callable$create(curricularPeriodConfiguration, bigDecimal, n)));
    }

    static /* synthetic */ EnrolmentsInCurricularYear advised$create(CurricularPeriodConfiguration configuration, BigDecimal value, Integer year) {
        EnrolmentsInCurricularYear result = new EnrolmentsInCurricularYear();
        result.init(configuration, value, year, year);
        return result;
    }
}

