/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.gradingTable;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionInformation;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionServices;
import org.fenixedu.academic.domain.student.gradingTable.GradingTable;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableData;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableGenerator;
import org.fenixedu.academic.domain.student.gradingTable.GradingTableSettings;
import org.fenixedu.academic.domain.student.gradingTable.InstitutionGradingTable_Base;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;

@Deprecated
public class InstitutionGradingTable
extends InstitutionGradingTable_Base {
    private InstitutionGradingTable() {
    }

    public static Stream<InstitutionGradingTable> findAll() {
        return Bennu.getInstance().getGradingTablesSet().stream().filter(InstitutionGradingTable.class::isInstance).map(InstitutionGradingTable.class::cast);
    }

    public static InstitutionGradingTable find(ExecutionYear ey) {
        return ey.getGradingTablesSet().stream().filter(InstitutionGradingTable.class::isInstance).map(InstitutionGradingTable.class::cast).findAny().orElse(null);
    }

    public static InstitutionGradingTable generate(ExecutionYear executionYear) {
        if (InstitutionGradingTable.find(executionYear) != null) {
            return null;
        }
        throw new RuntimeException("deprecated");
    }

    public void compileData() {
        GradingTableData tableData = new GradingTableData();
        this.setData(tableData);
        Set<RegistrationConclusionBean> harvestSample = this.harvestSample();
        List<BigDecimal> sample = harvestSample.stream().map(s -> new BigDecimal(s.getFinalGrade().getNumericValue().setScale(0, RoundingMode.HALF_UP).intValue())).collect(Collectors.toList());
        String harvestConclusionUsedInSampleData = harvestSample.stream().map(e -> this.registrationConclusionBeanStringData((RegistrationConclusionBean)e)).reduce((a, c) -> a + "\n" + c).orElseGet(() -> "");
        this.setStudentSampleData(harvestConclusionUsedInSampleData);
        if (sample != null) {
            GradingTableGenerator.generateTableDataImprovement((GradingTable)((Object)this), sample);
        } else {
            GradingTableGenerator.defaultData((GradingTable)((Object)this));
            this.setCopied(true);
        }
        this.checkUniquenessOfTable();
    }

    private String registrationConclusionBeanStringData(RegistrationConclusionBean e) {
        Integer studentNumber = e.getRegistration().getNumber();
        String studentName = e.getRegistration().getStudent().getName();
        String degreeCode = e.getRegistration().getDegree().getCode();
        String conclusionExecutionYearName = e.getConclusionYear().getQualifiedName();
        Integer finalGrade = e.getFinalGrade().getNumericValue().setScale(0, RoundingMode.HALF_UP).intValue();
        return String.format("%s\t%s\t%s\t%s\t%s", studentNumber, studentName, degreeCode, conclusionExecutionYearName, finalGrade);
    }

    private void checkUniquenessOfTable() {
        InstitutionGradingTable existing = InstitutionGradingTable.find(this.getExecutionYear());
        if (existing != null && existing != this) {
            throw new AcademicExtensionsDomainException("error.InstitutionGradingTable.already.exists", this.getExecutionYear().getQualifiedName());
        }
    }

    private Set<RegistrationConclusionBean> harvestSample() {
        HashSet<RegistrationConclusionBean> sampleData = new HashSet<RegistrationConclusionBean>();
        int coveredYears = 0;
        boolean sampleOK = false;
        Map<ExecutionYear, Set<RegistrationConclusionBean>> conclusionsMap = this.collectConclusions();
        for (ExecutionYear year = this.getExecutionYear().getPreviousExecutionYear(); year != null; year = year.getPreviousExecutionYear()) {
            if (conclusionsMap.get(year) != null) {
                for (RegistrationConclusionBean bean : conclusionsMap.get(year)) {
                    Integer finalAverage;
                    if (!bean.getFinalGrade().isNumeric() || (finalAverage = Integer.valueOf(bean.getFinalGrade().getNumericValue() != null ? bean.getFinalGrade().getNumericValue().setScale(0, RoundingMode.HALF_UP).intValue() : 0)) == 0) continue;
                    sampleData.add(bean);
                }
            }
            if (++coveredYears >= GradingTableSettings.getMinimumPastYears() && sampleData.size() >= GradingTableSettings.getMinimumSampleSize()) {
                sampleOK = true;
                break;
            }
            if (coveredYears == GradingTableSettings.getMaximumPastYears()) break;
        }
        return sampleOK ? sampleData : null;
    }

    private Map<ExecutionYear, Set<RegistrationConclusionBean>> collectConclusions() {
        LinkedHashMap<ExecutionYear, Set<RegistrationConclusionBean>> conclusionsMap = new LinkedHashMap<ExecutionYear, Set<RegistrationConclusionBean>>();
        HashSet<Registration> batch = new HashSet<Registration>();
        for (Registration registration : Bennu.getInstance().getRegistrationsSet()) {
            if (registration.getStudentCurricularPlansSet().isEmpty() || !GradingTableSettings.getApplicableDegreeTypes().contains(registration.getDegreeType())) continue;
            batch.add(registration);
            if (batch.size() < 500) continue;
            this.processBatch(batch, conclusionsMap);
            batch.clear();
            if (!this.isDenseEnough(conclusionsMap)) continue;
            break;
        }
        if (!batch.isEmpty()) {
            this.processBatch(batch, conclusionsMap);
        }
        return conclusionsMap;
    }

    private void processBatch(final Set<Registration> batch, Map<ExecutionYear, Set<RegistrationConclusionBean>> conclusionsMap) {
        Callable<Set<RegistrationConclusionInformation>> workerLogic = new Callable<Set<RegistrationConclusionInformation>>(){

            @Override
            public Set<RegistrationConclusionInformation> call() throws Exception {
                HashSet<RegistrationConclusionInformation> conclusions = new HashSet<RegistrationConclusionInformation>();
                for (Registration reg : batch) {
                    for (RegistrationConclusionInformation info : RegistrationConclusionServices.inferConclusion(reg)) {
                        if (!info.isConcluded()) continue;
                        conclusions.add(info);
                    }
                }
                return conclusions;
            }
        };
        HarvesterWorker worker = new HarvesterWorker(workerLogic);
        worker.start();
        try {
            worker.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (RegistrationConclusionInformation conclusion : worker.getConclusions()) {
            ExecutionYear conclusionYear = conclusion.getRegistrationConclusionBean().getConclusionYear();
            if (!conclusionsMap.containsKey(conclusionYear)) {
                conclusionsMap.put(conclusionYear, new HashSet());
            }
            conclusionsMap.get(conclusionYear).add(conclusion.getRegistrationConclusionBean());
        }
    }

    private boolean isDenseEnough(Map<ExecutionYear, Set<RegistrationConclusionBean>> conclusionsMap) {
        int yearsSweeped = 0;
        for (ExecutionYear year = this.getExecutionYear().getPreviousExecutionYear(); year != null; year = year.getPreviousExecutionYear()) {
            if (conclusionsMap.get(year) != null && conclusionsMap.get(year).size() < 2 * GradingTableSettings.getMinimumSampleSize()) {
                return false;
            }
            if (++yearsSweeped < 2 * GradingTableSettings.getMinimumPastYears()) continue;
            return true;
        }
        return false;
    }

    private class HarvesterWorker
    extends Thread {
        private Callable<Set<RegistrationConclusionInformation>> logic;
        private Set<RegistrationConclusionInformation> conclusions;

        public HarvesterWorker(Callable<Set<RegistrationConclusionInformation>> logic) {
            this.logic = logic;
        }

        @Override
        public void run() {
            try {
                this.conclusions = (Set)FenixFramework.getTransactionManager().withTransaction(this.logic, new Atomic(){

                    public Class<? extends Annotation> annotationType() {
                        return null;
                    }

                    public boolean flattenNested() {
                        return true;
                    }

                    public Atomic.TxMode mode() {
                        return Atomic.TxMode.READ;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        Set<RegistrationConclusionInformation> getConclusions() {
            return this.conclusions;
        }
    }
}

