/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import com.google.common.base.Predicate;
import java.math.BigDecimal;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurriculumModuleServices {
    public static final Logger logger = LoggerFactory.getLogger(CurriculumModuleServices.class);

    @Deprecated
    public static BigDecimal getCreditsConcluded(CurriculumGroup toInspect, ExecutionInterval interval) {
        if (interval instanceof ExecutionYear) {
            return BigDecimal.valueOf(toInspect.getCreditsConcluded((ExecutionYear)ExecutionInterval.assertExecutionIntervalType(ExecutionYear.class, (ExecutionInterval)interval)));
        }
        return CurriculumModuleServices.getCreditsConcludedChildInterval(toInspect, interval);
    }

    @Deprecated
    private static BigDecimal getCreditsConcludedChildInterval(CurriculumGroup toInspect, ExecutionInterval interval) {
        BigDecimal result = BigDecimal.ZERO;
        if (toInspect.isNoCourseGroupCurriculumGroup()) {
            return result;
        }
        for (CurriculumModule iter : toInspect.getCurriculumModulesSet()) {
            result = result.add(CurriculumModuleServices.getCreditsConcluded(iter, interval));
        }
        CreditsLimit rule = (CreditsLimit)toInspect.getMostRecentActiveCurricularRule(CurricularRuleType.CREDITS_LIMIT, interval.getExecutionYear());
        if (rule == null) {
            return result;
        }
        return result.min(BigDecimal.valueOf(rule.getMaximumCredits()));
    }

    @Deprecated
    private static BigDecimal getCreditsConcluded(CurriculumModule toInspect, ExecutionInterval interval) {
        BigDecimal result = BigDecimal.ZERO;
        if (CurriculumGroup.class.isAssignableFrom(toInspect.getClass())) {
            result = CurriculumModuleServices.getCreditsConcludedChildInterval((CurriculumGroup)toInspect, interval);
        } else if (Enrolment.class.isAssignableFrom(toInspect.getClass())) {
            result = CurriculumModuleServices.getCreditsConcluded((Enrolment)toInspect, interval);
        } else if (Dismissal.class.isAssignableFrom(toInspect.getClass())) {
            result = CurriculumModuleServices.getCreditsConcluded((Dismissal)toInspect, interval);
        }
        return result;
    }

    private static BigDecimal getCreditsConcluded(Enrolment toInspect, ExecutionInterval interval) {
        return interval == null || toInspect.getExecutionPeriod().isBeforeOrEquals(interval) ? BigDecimal.valueOf(toInspect.getAprovedEctsCredits()) : BigDecimal.ZERO;
    }

    private static BigDecimal getCreditsConcluded(Dismissal toInspect, ExecutionInterval interval) {
        return interval == null || toInspect.getExecutionPeriod() == null || toInspect.getExecutionPeriod().isBeforeOrEquals(interval) && !toInspect.getCredits().isTemporary() ? BigDecimal.valueOf(toInspect.getEctsCredits()) : BigDecimal.ZERO;
    }

    public static BigDecimal getEnroledAndNotApprovedEctsCreditsFor(CurriculumGroup toInspect, ExecutionInterval interval) {
        if (interval instanceof ExecutionYear) {
            return ((ExecutionYear)interval).getExecutionPeriodsSet().stream().map(i -> CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsFor(toInspect, i)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsForCurriculumGroup(toInspect, interval);
    }

    private static BigDecimal getEnroledAndNotApprovedEctsCreditsForCurriculumGroup(CurriculumGroup toInspect, ExecutionInterval interval) {
        BigDecimal result = BigDecimal.ZERO;
        for (CurriculumModule iter : toInspect.getCurriculumModulesSet()) {
            result = result.add(CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsForCurriculumModule(iter, interval));
        }
        return result;
    }

    private static BigDecimal getEnroledAndNotApprovedEctsCreditsForCurriculumModule(CurriculumModule toInspect, ExecutionInterval interval) {
        BigDecimal result = BigDecimal.ZERO;
        if (CurriculumGroup.class.isAssignableFrom(toInspect.getClass())) {
            result = CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsForCurriculumGroup((CurriculumGroup)toInspect, interval);
        } else if (Enrolment.class.isAssignableFrom(toInspect.getClass())) {
            result = CurriculumModuleServices.getEnroledAndNotApprovedEctsCreditsForEnrolment((Enrolment)toInspect, interval);
        }
        return result;
    }

    private static BigDecimal getEnroledAndNotApprovedEctsCreditsForEnrolment(Enrolment toInspect, ExecutionInterval interval) {
        if (CurriculumLineServices.isExcludedFromCurriculum((CurriculumLine)toInspect)) {
            return BigDecimal.ZERO;
        }
        if (toInspect.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        if (!toInspect.isEnroled() && !toInspect.isFlunked()) {
            return BigDecimal.ZERO;
        }
        if (!toInspect.isValid(interval)) {
            return BigDecimal.ZERO;
        }
        if (toInspect.isAnual()) {
            if (!interval.getChildOrder().equals(1)) {
                return BigDecimal.ZERO;
            }
            AcademicPeriod contextPeriod = toInspect.getCurricularCourse().getParentContextsByExecutionYear(toInspect.getExecutionInterval().getExecutionYear()).stream().map(ctx -> ctx.getCurricularPeriod().getAcademicPeriod()).distinct().findFirst().orElse(AcademicPeriod.SEMESTER);
            if (!interval.getAcademicPeriod().equals((Object)contextPeriod)) {
                return BigDecimal.ZERO;
            }
        }
        BigDecimal result = toInspect.getEctsCreditsForCurriculum();
        logger.debug("{}#UC {}#{} ECTS", new Object[]{toInspect.getCode(), interval.getQualifiedName(), result.toPlainString()});
        return result;
    }

    public static YearMonthDay calculateLastAcademicActDate(CurriculumGroup group, final ExecutionYear executionYear, boolean forConclusion) {
        return CurriculumModuleServices.calculateLastAcademicActDate(group, new Predicate<CurriculumLine>(){

            public boolean apply(CurriculumLine toEval) {
                return toEval.getExecutionYear() == executionYear;
            }
        }, forConclusion);
    }

    public static YearMonthDay calculateLastAcademicActDate(CurriculumGroup group, final boolean forConclusion) {
        return CurriculumModuleServices.calculateLastAcademicActDate(group, new Predicate<CurriculumLine>(){

            public boolean apply(CurriculumLine toEval) {
                return !forConclusion || toEval.isApproved();
            }
        }, forConclusion);
    }

    private static YearMonthDay calculateLastAcademicActDate(CurriculumGroup group, Predicate<CurriculumLine> predicate, boolean forConclusion) {
        TreeSet<YearMonthDay> result = new TreeSet<YearMonthDay>();
        for (CurriculumLine line : group.getAllCurriculumLines()) {
            YearMonthDay lineAcademicActDate;
            if (line.getCurriculumGroup().isNoCourseGroupCurriculumGroup() || CurriculumLineServices.isAffinity(line) || !predicate.apply((Object)line) || (lineAcademicActDate = CurriculumLineServices.getAcademicActDate(line, forConclusion)) == null) continue;
            result.add(lineAcademicActDate);
        }
        return result.isEmpty() ? null : (YearMonthDay)result.last();
    }
}

