/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.evaluation.CustomEvaluationConfiguration_Base;
import org.fenixedu.academic.domain.evaluation.EvaluationComparator;
import org.fenixedu.bennu.core.domain.Bennu;

@Deprecated
public class CustomEvaluationConfiguration
extends CustomEvaluationConfiguration_Base {
    private static Comparator<EnrolmentEvaluation> ENROLMENT_EVALUATION_ORDER = new EvaluationComparator();
    private static Predicate<Enrolment> ENROLMENT_FILTER = e -> false;

    public static void setEnrolmentFilter(Predicate<Enrolment> predicate) {
        ENROLMENT_FILTER = predicate;
    }

    public CustomEvaluationConfiguration() {
        this.setRoot(Bennu.getInstance());
    }

    public Optional<EnrolmentEvaluation> getFinalEnrolmentEvaluation(Enrolment enrolment) {
        Predicate<EnrolmentEvaluation> isFinal = EnrolmentEvaluation::isFinal;
        Predicate<EnrolmentEvaluation> isSpecialAuthorization = this.getSpecialAuthorizationFilter(enrolment);
        return enrolment.getEvaluationsSet().stream().filter(isFinal.and(isSpecialAuthorization)).max(ENROLMENT_EVALUATION_ORDER);
    }

    public Optional<EnrolmentEvaluation> getFinalEnrolmentEvaluation(Enrolment enrolment, EvaluationSeason season) {
        Predicate<EnrolmentEvaluation> isFinal = EnrolmentEvaluation::isFinal;
        Predicate<EnrolmentEvaluation> isSeason = e -> e.getEvaluationSeason().equals((Object)season);
        return enrolment.getEvaluationsSet().stream().filter(isFinal.and(isSeason)).max(ENROLMENT_EVALUATION_ORDER);
    }

    public Optional<EnrolmentEvaluation> getFinalEnrolmentEvaluation(Enrolment enrolment, ExecutionInterval executionInterval) {
        Predicate<EnrolmentEvaluation> isFinal = EnrolmentEvaluation::isFinal;
        Predicate<EnrolmentEvaluation> isSpecialAuthorization = this.getSpecialAuthorizationFilter(enrolment);
        return enrolment.getEvaluationsSet().stream().filter(isFinal.and(isSpecialAuthorization)).filter(ev -> ev.getExecutionInterval() == executionInterval).max(ENROLMENT_EVALUATION_ORDER);
    }

    public Optional<EnrolmentEvaluation> getEnrolmentEvaluationForConclusionDate(Enrolment enrolment) {
        Predicate<EnrolmentEvaluation> isFinal = EnrolmentEvaluation::isFinal;
        Predicate<EnrolmentEvaluation> isImprovement = e -> e.getEvaluationSeason().isImprovement();
        Predicate<EnrolmentEvaluation> hasExam = e -> e.getExamDateYearMonthDay() != null;
        Predicate<EnrolmentEvaluation> isSpecialAuthorization = this.getSpecialAuthorizationFilter(enrolment);
        return enrolment.getEvaluationsSet().stream().filter(isFinal.and(isSpecialAuthorization).and(isImprovement.negate()).and(hasExam)).max(ENROLMENT_EVALUATION_ORDER);
    }

    private Predicate<EnrolmentEvaluation> getSpecialAuthorizationFilter(Enrolment enrolment) {
        return this.isToApplySpecialAuthorization(enrolment) ? x -> x.getEvaluationSeason().getSpecialAuthorization() : x -> true;
    }

    protected boolean isToApplySpecialAuthorization(Enrolment enrolment) {
        return ENROLMENT_FILTER.test(enrolment);
    }

    public Optional<EnrolmentEvaluation> getCurrentEnrolmentEvaluation(Enrolment enrolment, EvaluationSeason season) {
        Predicate<EnrolmentEvaluation> isSeason = e -> e.getEvaluationSeason().equals((Object)season);
        return enrolment.getEvaluationsSet().stream().filter(isSeason).max(EnrolmentEvaluation.COMPARATORY_BY_WHEN);
    }
}

