/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.config;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.academic.domain.evaluation.config.CompetenceCourseMarkSheetTemplateFile;
import org.fenixedu.academic.domain.evaluation.config.MarkSheetSettings$callable$create;
import org.fenixedu.academic.domain.evaluation.config.MarkSheetSettings$callable$edit;
import org.fenixedu.academic.domain.evaluation.config.MarkSheetSettings$callable$editTemplateFile;
import org.fenixedu.academic.domain.evaluation.config.MarkSheetSettings_Base;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MarkSheetSettings
extends MarkSheetSettings_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$editTemplateFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected MarkSheetSettings() {
        this.setRoot(Bennu.getInstance());
    }

    public static void init() {
        if (MarkSheetSettings.getInstance() == null) {
            MarkSheetSettings.create();
        }
    }

    public static MarkSheetSettings getInstance() {
        return MarkSheetSettings.findAll().findFirst().orElseGet(MarkSheetSettings::create);
    }

    public static MarkSheetSettings create() {
        return (MarkSheetSettings)((Object)advice$create.perform((Callable)new MarkSheetSettings$callable$create()));
    }

    static /* synthetic */ MarkSheetSettings advised$create() {
        return new MarkSheetSettings();
    }

    public void edit(boolean bl, int n, boolean bl2, boolean bl3) {
        Object object = advice$edit.perform((Callable)new MarkSheetSettings$callable$edit(this, bl, n, bl2, bl3));
    }

    static /* synthetic */ void advised$edit(MarkSheetSettings this_, boolean allowTeacherToChooseCertifier, int requiredNumberOfShifts, boolean limitCertifierToResponsibleTeacher, boolean limitCreationToResponsibleTeacher) {
        super.setAllowTeacherToChooseCertifier(allowTeacherToChooseCertifier);
        super.setRequiredNumberOfShifts(requiredNumberOfShifts);
        super.setLimitCertifierToResponsibleTeacher(limitCertifierToResponsibleTeacher);
        super.setLimitCreationToResponsibleTeacher(limitCreationToResponsibleTeacher);
    }

    public void editTemplateFile(String string, byte[] byArray) {
        Object object = advice$editTemplateFile.perform((Callable)new MarkSheetSettings$callable$editTemplateFile(this, string, byArray));
    }

    static /* synthetic */ void advised$editTemplateFile(MarkSheetSettings this_, String filename, byte[] content) {
        if (this_.getTemplateFile() != null) {
            this_.getTemplateFile().delete();
        }
        CompetenceCourseMarkSheetTemplateFile.create(filename, content, this_);
    }

    public boolean isRequiredNumberOfShifts(int input) {
        if (this.isUnspecifiedNumberOfShifts()) {
            return true;
        }
        if (this.isNotAllowedShifts() && input != 0) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.shifts.not.allowed", new String[0]);
        }
        if (this.isRequiredAtLeastOneShift() && input <= 0) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.shift.required", new String[0]);
        }
        if (!this.isRequiredAtLeastOneShift() && this.getRequiredNumberOfShifts() != input) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheet.shifts.required", String.valueOf(this.getRequiredNumberOfShifts()));
        }
        return true;
    }

    public boolean isUnspecifiedNumberOfShifts() {
        return this.getRequiredNumberOfShifts() < 0;
    }

    public boolean isNotAllowedShifts() {
        return this.getRequiredNumberOfShifts() == 0;
    }

    public boolean isRequiredAtLeastOneShift() {
        return this.getRequiredNumberOfShifts() >= 10;
    }

    public boolean isMarkSheetTemplateCodeDefined() {
        return StringUtils.isNotBlank((CharSequence)this.getMarkSheetTemplateCode());
    }

    public static Stream<MarkSheetSettings> findAll() {
        return Bennu.getInstance().getMarkSheetSettingsSet().stream();
    }
}

