/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcessVersion;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class EnrolmentServices
extends org.fenixedu.academic.domain.student.services.EnrolmentServices {
    private static RelationListener<DegreeModule, CurriculumModule> ON_ENROLMENT_DELETION = new RelationAdapter<DegreeModule, CurriculumModule>(){

        public void beforeRemove(DegreeModule degreeModule, CurriculumModule module) {
            if (module == null || degreeModule == null) {
                return;
            }
            if (!(module instanceof Enrolment)) {
                return;
            }
            Enrolment enrolment = (Enrolment)module;
            EnrolmentServices.removeConclusionProcessVersionsExceptLast(enrolment);
            EnrolmentServices.checkForConclusionProcessVersions(enrolment);
        }
    };

    public static void initialize() {
        CurriculumModule.getRelationDegreeModuleCurriculumModule().addListener(ON_ENROLMENT_DELETION);
    }

    public static String getPresentationName(Enrolment enrolment) {
        String code;
        String string = code = !StringUtils.isEmpty((String)enrolment.getCurricularCourse().getCode()) ? enrolment.getCurricularCourse().getCode() + " - " : "";
        if (enrolment instanceof OptionalEnrolment) {
            OptionalEnrolment optionalEnrolment = (OptionalEnrolment)enrolment;
            return optionalEnrolment.getOptionalCurricularCourse().getNameI18N(enrolment.getExecutionPeriod()).getContent() + " (" + code + optionalEnrolment.getCurricularCourse().getNameI18N(optionalEnrolment.getExecutionPeriod()).getContent() + ")";
        }
        return code + enrolment.getName().getContent();
    }

    public static void checkForConclusionProcessVersions(Enrolment enrolment) {
        if (enrolment.isApproved() && !enrolment.getConclusionProcessVersionsSet().isEmpty()) {
            Registration registration = enrolment.getRegistration();
            throw new DomainException("error.conclusionProcess.revertion.required", new String[]{"\"" + registration.getNumber() + " - " + registration.getPerson().getPresentationName() + "\"", "\"" + EnrolmentServices.getPresentationName(enrolment) + "\"", enrolment.getConclusionProcessVersionsSet().stream().map(i -> "\"" + i.getConclusionProcess().getName().getContent() + "\"").distinct().collect(Collectors.joining("; "))});
        }
    }

    private static void removeConclusionProcessVersionsExceptLast(Enrolment enrolment) {
        Iterator iter = enrolment.getConclusionProcessVersionsSet().iterator();
        while (iter.hasNext()) {
            ConclusionProcessVersion version = (ConclusionProcessVersion)iter.next();
            if (version.getConclusionProcess().getLastVersion() == version) continue;
            iter.remove();
        }
    }

    public static Set<ExecutionCourse> getExecutionCourses(Enrolment enrolment, ExecutionInterval interval) {
        CurricularCourse curricular;
        HashSet<ExecutionCourse> result = new HashSet<ExecutionCourse>();
        if (enrolment != null && (curricular = enrolment.getCurricularCourse()) != null) {
            result.addAll(curricular.getCompetenceCourse().getExecutionCoursesByExecutionPeriod(interval));
        }
        return result;
    }

    public static ExecutionCourse getExecutionCourseUnique(Enrolment enrolment, ExecutionInterval interval) {
        Set<ExecutionCourse> all = EnrolmentServices.getExecutionCourses(enrolment, interval);
        if (all.size() == 1) {
            return all.iterator().next();
        }
        CurricularCourse curricular = enrolment.getCurricularCourse();
        List filtered = all.stream().filter(ec -> ec.getAssociatedCurricularCoursesSet().contains(curricular)).collect(Collectors.toList());
        if (filtered.size() == 1) {
            return (ExecutionCourse)filtered.iterator().next();
        }
        return null;
    }
}

