/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourseRestrictions_Base;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.AnyCurricularCourseRestrictionsExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;

public class AnyCurricularCourseRestrictions
extends AnyCurricularCourseRestrictions_Base {
    protected AnyCurricularCourseRestrictions() {
    }

    public AnyCurricularCourseRestrictions(DegreeModule toApplyRule, CourseGroup contextCourseGroup, ExecutionInterval begin, ExecutionInterval end, Set<CourseGroup> courseGroups) {
        this();
        this.init(toApplyRule, contextCourseGroup, begin, end, CurricularRuleType.CUSTOM);
        this.edit(contextCourseGroup, courseGroups);
    }

    public void edit(CourseGroup contextCourseGroup, Set<CourseGroup> courseGroups) {
        this.setContextCourseGroup(contextCourseGroup);
        super.getCourseGroupsSet().clear();
        super.getCourseGroupsSet().addAll(courseGroups);
        this.checkRules();
    }

    private void checkRules() {
    }

    public RuleResult evaluate(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return new AnyCurricularCourseRestrictionsExecutor().execute((ICurricularRule)this, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }

    protected void removeOwnParameters() {
        this.getCourseGroupsSet().clear();
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        StringBuilder label = new StringBuilder();
        label.append(AcademicExtensionsUtil.bundle("label.AnyCurricularCourseRestrictions", new String[0])).append(": ");
        if (!this.getCourseGroupsSet().isEmpty()) {
            label.append(AcademicExtensionsUtil.bundle("label.AnyCurricularCourseRestrictions.allowedCourseGroups", this.getCourseGroupsDescription()));
        }
        return Lists.newArrayList((Object[])new GenericPair[]{new GenericPair((Object)label, (Object)false)});
    }

    public String getCourseGroupsDescription() {
        return this.getCourseGroupsSet().isEmpty() ? "-" : this.getCourseGroupsSet().stream().map(i -> "\"" + i.getNameI18N().getContent() + "\"").collect(Collectors.joining(" ou "));
    }
}

