/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degree;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.ExtendedDegreeInfo$callable$getMostRecent;
import org.fenixedu.academic.domain.degree.ExtendedDegreeInfo$callable$getOrCreate;
import org.fenixedu.academic.domain.degree.ExtendedDegreeInfo_Base;
import org.fenixedu.academic.domain.dml.DynamicField;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ExtendedDegreeInfo
extends ExtendedDegreeInfo_Base {
    private static final String SCIENTIFIC_AREAS = "scientificAreas";
    private static final String STUDY_PROGRAMME_DURATION = "studyProgrammeDuration";
    private static final String STUDY_REGIME = "studyRegime";
    private static final String STUDY_PROGRAMME_REQUIREMENTS = "studyProgrammeRequirements";
    private static final String HIGHER_EDUCATION_ACCESS = "higherEducationAccess";
    private static final String PROFESSIONAL_STATUTES = "professionalStatus";
    private static final String SUPPLEMENT_EXTRA_INFORMATION = "supplementExtraInformation";
    private static final String SUPPLEMENT_OTHER_SOURCES = "supplementOtherSources";
    public static final Advice advice$getMostRecent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$getOrCreate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void setupDeleteListener() {
        FenixFramework.getDomainModel().registerDeletionListener(DegreeInfo.class, degreeInfo -> {
            ExtendedDegreeInfo edi = degreeInfo.getExtendedDegreeInfo();
            degreeInfo.setExtendedDegreeInfo(null);
            if (edi != null) {
                edi.delete();
            }
        });
    }

    public static void setupCreationListener() {
        Signal.register((String)"DEGREE_INFO_CREATION_EVENT", event -> {
            DegreeInfo degreeInfo = (DegreeInfo)event.getInstance();
            if (degreeInfo.getExtendedDegreeInfo() != null) {
                return;
            }
            ExtendedDegreeInfo mostRecent = ExtendedDegreeInfo.findMostRecent(degreeInfo.getExecutionYear(), degreeInfo.getDegree());
            if (mostRecent != null) {
                new ExtendedDegreeInfo(degreeInfo, mostRecent);
            } else {
                new ExtendedDegreeInfo(degreeInfo);
            }
        });
    }

    public ExtendedDegreeInfo() {
        this.setBennu(Bennu.getInstance());
    }

    public ExtendedDegreeInfo(DegreeInfo degreeInfo) {
        this();
        this.setDegreeInfo(degreeInfo);
    }

    public ExtendedDegreeInfo(DegreeInfo degreeInfo, ExtendedDegreeInfo olderEdi) {
        this(degreeInfo);
        this.setScientificAreas(olderEdi.getScientificAreas());
        this.setStudyRegime(olderEdi.getStudyRegime());
        this.setStudyProgrammeDuration(olderEdi.getStudyProgrammeDuration());
        this.setStudyProgrammeRequirements(olderEdi.getStudyProgrammeRequirements());
        this.setHigherEducationAccess(olderEdi.getHigherEducationAccess());
        this.setProfessionalStatus(olderEdi.getProfessionalStatus());
        this.setSupplementExtraInformation(olderEdi.getSupplementExtraInformation());
        this.setSupplementOtherSources(olderEdi.getSupplementOtherSources());
    }

    public LocalizedString getScientificAreas() {
        return DynamicField.find((DomainObject)this.getDegreeInfo(), (String)SCIENTIFIC_AREAS).map(dF -> (LocalizedString)dF.getValue(LocalizedString.class)).orElseGet(() -> super.getScientificAreas());
    }

    public void setScientificAreas(LocalizedString scientificAreas) {
        DynamicField.find((DomainObject)this.getDegreeInfo(), (String)SCIENTIFIC_AREAS).ifPresent(dF -> dF.edit((Object)scientificAreas));
        super.setScientificAreas(scientificAreas);
    }

    public LocalizedString getStudyRegime() {
        return DynamicField.find((DomainObject)this.getDegreeInfo(), (String)STUDY_REGIME).map(dF -> (LocalizedString)dF.getValue(LocalizedString.class)).orElseGet(() -> super.getStudyRegime());
    }

    public void setStudyRegime(LocalizedString studyRegime) {
        DynamicField.find((DomainObject)this.getDegreeInfo(), (String)STUDY_REGIME).ifPresent(dF -> dF.edit((Object)studyRegime));
        super.setStudyRegime(studyRegime);
    }

    public LocalizedString getStudyProgrammeDuration() {
        return DynamicField.find((DomainObject)this.getDegreeInfo(), (String)STUDY_PROGRAMME_DURATION).map(dF -> (LocalizedString)dF.getValue(LocalizedString.class)).orElseGet(() -> super.getStudyProgrammeDuration());
    }

    public void setStudyProgrammeDuration(LocalizedString studyProgrammeDuration) {
        DynamicField.find((DomainObject)this.getDegreeInfo(), (String)STUDY_PROGRAMME_DURATION).ifPresent(dF -> dF.edit((Object)studyProgrammeDuration));
        super.setStudyProgrammeDuration(studyProgrammeDuration);
    }

    public LocalizedString getStudyProgrammeRequirements() {
        return DynamicField.find((DomainObject)this.getDegreeInfo(), (String)STUDY_PROGRAMME_REQUIREMENTS).map(dF -> (LocalizedString)dF.getValue(LocalizedString.class)).orElseGet(() -> super.getStudyProgrammeRequirements());
    }

    public void setStudyProgrammeRequirements(LocalizedString studyProgrammeRequirements) {
        DynamicField.find((DomainObject)this.getDegreeInfo(), (String)STUDY_PROGRAMME_REQUIREMENTS).ifPresent(dF -> dF.edit((Object)studyProgrammeRequirements));
        super.setStudyProgrammeRequirements(studyProgrammeRequirements);
    }

    public LocalizedString getHigherEducationAccess() {
        return DynamicField.find((DomainObject)this.getDegreeInfo(), (String)HIGHER_EDUCATION_ACCESS).map(dF -> (LocalizedString)dF.getValue(LocalizedString.class)).orElseGet(() -> super.getHigherEducationAccess());
    }

    public void setHigherEducationAccess(LocalizedString higherEducationAccess) {
        DynamicField.find((DomainObject)this.getDegreeInfo(), (String)HIGHER_EDUCATION_ACCESS).ifPresent(dF -> dF.edit((Object)higherEducationAccess));
        super.setHigherEducationAccess(higherEducationAccess);
    }

    public LocalizedString getProfessionalStatus() {
        return DynamicField.find((DomainObject)this.getDegreeInfo(), (String)PROFESSIONAL_STATUTES).map(dF -> (LocalizedString)dF.getValue(LocalizedString.class)).orElseGet(() -> super.getProfessionalStatus());
    }

    public void setProfessionalStatus(LocalizedString professionalStatus) {
        DynamicField.find((DomainObject)this.getDegreeInfo(), (String)PROFESSIONAL_STATUTES).ifPresent(dF -> dF.edit((Object)professionalStatus));
        super.setProfessionalStatus(professionalStatus);
    }

    public LocalizedString getSupplementExtraInformation() {
        return DynamicField.find((DomainObject)this.getDegreeInfo(), (String)SUPPLEMENT_EXTRA_INFORMATION).map(dF -> (LocalizedString)dF.getValue(LocalizedString.class)).orElseGet(() -> super.getSupplementExtraInformation());
    }

    public void setSupplementExtraInformation(LocalizedString supplementExtraInformation) {
        DynamicField.find((DomainObject)this.getDegreeInfo(), (String)SUPPLEMENT_EXTRA_INFORMATION).ifPresent(dF -> dF.edit((Object)supplementExtraInformation));
        super.setSupplementExtraInformation(supplementExtraInformation);
    }

    public LocalizedString getSupplementOtherSources() {
        return DynamicField.find((DomainObject)this.getDegreeInfo(), (String)SUPPLEMENT_OTHER_SOURCES).map(dF -> (LocalizedString)dF.getValue(LocalizedString.class)).orElseGet(() -> super.getSupplementOtherSources());
    }

    public void setSupplementOtherSources(LocalizedString supplementOtherSources) {
        DynamicField.find((DomainObject)this.getDegreeInfo(), (String)SUPPLEMENT_OTHER_SOURCES).ifPresent(dF -> dF.edit((Object)supplementOtherSources));
        super.setSupplementOtherSources(supplementOtherSources);
    }

    public void delete() {
        this.setDegreeInfo(null);
        this.setBennu(null);
        this.deleteDomainObject();
    }

    public static ExtendedDegreeInfo getMostRecent(ExecutionYear executionYear, Degree degree) {
        return (ExtendedDegreeInfo)((Object)advice$getMostRecent.perform((Callable)new ExtendedDegreeInfo$callable$getMostRecent(executionYear, degree)));
    }

    static /* synthetic */ ExtendedDegreeInfo advised$getMostRecent(ExecutionYear executionYear, Degree degree) {
        DegreeInfo di = degree.getMostRecentDegreeInfo(executionYear);
        if (di.getExtendedDegreeInfo() == null) {
            ExtendedDegreeInfo mostRecent = ExtendedDegreeInfo.findMostRecent(executionYear, degree);
            return mostRecent != null ? new ExtendedDegreeInfo(di, mostRecent) : new ExtendedDegreeInfo(di);
        }
        return di.getExtendedDegreeInfo();
    }

    public static ExtendedDegreeInfo getOrCreate(ExecutionYear executionYear, Degree degree) {
        return (ExtendedDegreeInfo)((Object)advice$getOrCreate.perform((Callable)new ExtendedDegreeInfo$callable$getOrCreate(executionYear, degree)));
    }

    static /* synthetic */ ExtendedDegreeInfo advised$getOrCreate(ExecutionYear executionYear, Degree degree) {
        DegreeInfo di = degree.getDegreeInfoFor(executionYear);
        if (di == null) {
            DegreeInfo mrdi = degree.getMostRecentDegreeInfo(executionYear);
            DegreeInfo degreeInfo = di = mrdi != null ? new DegreeInfo(mrdi, executionYear) : new DegreeInfo(degree, executionYear);
            if (mrdi != null) {
                DegreeInfo finalDegreeInfo = di;
                mrdi.getDynamicFieldSet().stream().filter(df -> StringUtils.isNotBlank((String)df.getValue())).map(df -> df.getDescriptor().getCode()).forEach(code -> DynamicField.setFieldValue((DomainObject)finalDegreeInfo, (String)code, (Object)DynamicField.getFieldValue((DomainObject)mrdi, (String)code)));
            }
        }
        if (di.getExtendedDegreeInfo() == null) {
            ExtendedDegreeInfo mostRecent = ExtendedDegreeInfo.findMostRecent(executionYear, degree);
            return mostRecent != null ? new ExtendedDegreeInfo(di, mostRecent) : new ExtendedDegreeInfo(di);
        }
        return di.getExtendedDegreeInfo();
    }

    public static ExtendedDegreeInfo findMostRecent(ExecutionYear executionYear, Degree degree) {
        return degree.getDegreeInfosSet().stream().filter(di -> di.getExecutionYear().isBeforeOrEquals(executionYear)).sorted((di1, di2) -> ExecutionYear.REVERSE_COMPARATOR_BY_YEAR.compare(di1.getExecutionYear(), di2.getExecutionYear())).map(di -> di.getExtendedDegreeInfo()).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

