/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.CreditsLimitWithPreviousApprovals;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;

public abstract class CurricularRuleServices {
    public static List<? extends ICurricularRule> getCurricularRules(DegreeModule source, Class<? extends ICurricularRule> ruleClass, ExecutionInterval interval) {
        return CurricularRuleServices.getCurricularRules(source, null, ruleClass, interval);
    }

    public static List<? extends ICurricularRule> getCurricularRules(DegreeModule source, CourseGroup parent, Class<? extends ICurricularRule> ruleClass, ExecutionInterval interval) {
        return source.getCurricularRulesSet().stream().filter(rule -> ruleClass.isAssignableFrom(rule.getClass()) && CurricularRuleServices.isCurricularRuleValid((ICurricularRule)rule, interval) && (parent == null || rule.appliesToCourseGroup(parent))).collect(Collectors.toList());
    }

    private static boolean isCurricularRuleValid(ICurricularRule rule, ExecutionInterval interval) {
        return interval instanceof ExecutionYear ? rule.isValid((ExecutionYear)interval) : rule.isValid(interval);
    }

    protected static boolean appliesToPeriod(Context context, CurricularPeriod period) {
        return period == null || period == context.getCurricularPeriod();
    }

    public static double calculateTotalEctsInGroup(EnrolmentContext enrolmentContext, CurriculumGroup curriculumGroup) {
        double result = CurricularRuleServices.calculateCreditsConcluded(enrolmentContext, (CurriculumModule)curriculumGroup);
        return result += CurricularRuleServices.calculateEnroledEctsCredits(enrolmentContext, (CurriculumModule)curriculumGroup).doubleValue();
    }

    public static Double calculateCreditsConcluded(EnrolmentContext enrolmentContext, CurriculumModule curriculumModule) {
        return enrolmentContext.isToEvaluateRulesByYear() ? curriculumModule.getCreditsConcluded(enrolmentContext.getExecutionYear()) : curriculumModule.getCreditsConcluded(enrolmentContext.getExecutionPeriod().getExecutionYear());
    }

    public static Double calculateEnroledEctsCredits(EnrolmentContext enrolmentContext, CurriculumModule curriculumModule) {
        return enrolmentContext.isToEvaluateRulesByYear() ? curriculumModule.getEnroledEctsCredits(enrolmentContext.getExecutionYear()) : curriculumModule.getEnroledEctsCredits(enrolmentContext.getExecutionPeriod());
    }

    public static double calculateEctsCreditsFromPreviousGroups(EnrolmentContext enrolmentContext, CreditsLimitWithPreviousApprovals rule) {
        double result = 0.0;
        if (rule != null) {
            ExecutionYear executionYear = enrolmentContext.isToEvaluateRulesByYear() ? enrolmentContext.getExecutionYear() : enrolmentContext.getExecutionPeriod().getExecutionYear();
            for (CourseGroup group : rule.getPreviousGroupsSet()) {
                CurriculumGroup otherGroup;
                DegreeCurricularPlan dcp = group.getParentDegreeCurricularPlan();
                StudentCurricularPlan scp = enrolmentContext.getRegistration().getStudentCurricularPlan(dcp);
                if (scp == null || (otherGroup = scp.findCurriculumGroupFor(group)) == null) continue;
                result += otherGroup.getCreditsConcluded(executionYear).doubleValue();
            }
        }
        return result;
    }
}

