/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.struts.portal;

import com.qubit.terra.portal.domain.functionalities.Functionality;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.apache.struts.actions.DispatchAction;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.security.UserAuthenticationListener;
import org.fenixedu.bennu.portal.model.Application;
import org.fenixedu.bennu.portal.model.ApplicationRegistry;
import org.fenixedu.bennu.portal.servlet.PortalBackend;
import org.fenixedu.bennu.portal.servlet.PortalBackendRegistry;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.plugin.StrutsAnnotationsPlugIn;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsApplication;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.bennu.struts.portal.StrutsPortalBackend;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.RenderersSessionSecret;

@HandlesTypes(value={Mapping.class, StrutsApplication.class, StrutsFunctionality.class})
public class RenderersAnnotationProcessor
implements ServletContainerInitializer {
    static final String DELEGATE = "$DELEGATE_TO_PARENT$";
    private static final Map<Class<?>, org.fenixedu.bennu.portal.model.Functionality> functionalityClasses = new HashMap();

    public void onStartup(Set<Class<?>> classes, ServletContext context) throws ServletException {
        PortalBackendRegistry.registerPortalBackend((PortalBackend)new StrutsPortalBackend());
        Authenticate.addUserAuthenticationListener((UserAuthenticationListener)new RenderersSessionSecret.RenderersUserAuthenticationListener());
        if (classes != null) {
            StrutsFunctionality functionality;
            HashMap applicationClasses = new HashMap();
            HashSet actionsWithoutFunctionality = new HashSet();
            for (Class<?> clazz : classes) {
                StrutsApplication application;
                Mapping mapping = clazz.getAnnotation(Mapping.class);
                if (mapping != null) {
                    StrutsAnnotationsPlugIn.registerMapping(clazz);
                    if (mapping.functionality() != Object.class) {
                        actionsWithoutFunctionality.add(clazz);
                    }
                }
                if ((functionality = clazz.getAnnotation(StrutsFunctionality.class)) != null) {
                    String bundle = "resources." + this.findBundleForFunctionality(clazz);
                    LocalizedString title = BundleUtil.getLocalizedString((String)bundle, (String)functionality.titleKey(), (String[])new String[0]);
                    LocalizedString description = functionality.descriptionKey().equals(DELEGATE) ? title : BundleUtil.getLocalizedString((String)bundle, (String)functionality.descriptionKey(), (String[])new String[0]);
                    functionalityClasses.put(clazz, new org.fenixedu.bennu.portal.model.Functionality("struts", this.computePath(clazz), functionality.path(), this.findGroupForFunctionality(clazz), title, description));
                }
                if ((application = clazz.getAnnotation(StrutsApplication.class)) == null) continue;
                String bundle = "resources." + application.bundle();
                LocalizedString title = BundleUtil.getLocalizedString((String)bundle, (String)application.titleKey(), (String[])new String[0]);
                LocalizedString description = application.descriptionKey().equals(DELEGATE) ? title : BundleUtil.getLocalizedString((String)bundle, (String)application.descriptionKey(), (String[])new String[0]);
                Application app = new Application(clazz.getName(), application.path(), application.accessGroup(), title, description, application.hint());
                applicationClasses.put(clazz, app);
                if (functionality != null || mapping == null) continue;
                this.registerStartPage(clazz, app);
            }
            for (Map.Entry entry : functionalityClasses.entrySet()) {
                Class<?> applicationClass = ((Class)entry.getKey()).isAnnotationPresent(StrutsApplication.class) ? (Class<?>)entry.getKey() : ((Class)entry.getKey()).getAnnotation(StrutsFunctionality.class).app();
                Application app = (Application)applicationClasses.get(applicationClass);
                if (app == null) {
                    throw new Error("Functionality " + ((Class)entry.getKey()).getName() + " does not have a defined application");
                }
                app.addFunctionality((Functionality)entry.getValue());
            }
            for (Application application : applicationClasses.values()) {
                ApplicationRegistry.registerApplication((Application)application);
            }
            for (Class clazz : actionsWithoutFunctionality) {
                Class<?> functionalityType = clazz.getAnnotation(Mapping.class).functionality();
                functionality = functionalityClasses.get(functionalityType);
                if (functionality == null) {
                    throw new Error("Action type " + clazz.getName() + " declares " + functionalityType.getName() + " but it is not a functionality!");
                }
                functionalityClasses.put(clazz, (org.fenixedu.bennu.portal.model.Functionality)functionality);
            }
        }
    }

    private void registerStartPage(Class<?> type, Application app) {
        LocalizedString title = BundleUtil.getLocalizedString((String)"resources.RendererResources", (String)"label.start.page", (String[])new String[0]);
        org.fenixedu.bennu.portal.model.Functionality functionality = new org.fenixedu.bennu.portal.model.Functionality("struts", this.computePath(type), "start-page", app.getAccessGroup(), title, title, false);
        functionalityClasses.put(type, functionality);
    }

    private String findGroupForFunctionality(Class<?> type) {
        StrutsFunctionality functionality = type.getAnnotation(StrutsFunctionality.class);
        if (functionality.accessGroup().equals(DELEGATE)) {
            return functionality.app().getAnnotation(StrutsApplication.class).accessGroup();
        }
        return functionality.accessGroup();
    }

    private String findBundleForFunctionality(Class<?> type) {
        StrutsFunctionality functionality = type.getAnnotation(StrutsFunctionality.class);
        if (functionality.bundle().equals(DELEGATE)) {
            return functionality.app().getAnnotation(StrutsApplication.class).bundle();
        }
        return functionality.bundle();
    }

    private String computePath(Class<?> type) {
        Mapping mapping = type.getAnnotation(Mapping.class);
        StringBuilder path = new StringBuilder();
        if (!mapping.module().isEmpty()) {
            path.append('/').append(mapping.module());
        }
        path.append(mapping.path()).append(".do");
        if (DispatchAction.class.isAssignableFrom(type)) {
            path.append('?').append(mapping.parameter()).append('=').append(this.findEntryPoint(type));
        }
        return path.toString();
    }

    private String findEntryPoint(Class<?> actionClass) {
        for (Class<?> type = actionClass; type != DispatchAction.class; type = type.getSuperclass()) {
            for (Method method : type.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(EntryPoint.class)) continue;
                return method.getName();
            }
        }
        throw new Error("Functionality class " + actionClass + " does not have a entry point!");
    }

    public static org.fenixedu.bennu.portal.model.Functionality getFunctionalityForType(Class<?> actionClass) {
        return functionalityClasses.get(actionClass);
    }
}

