/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.struts.servlet;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.html.FormTag;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.struts.servlet.ActionServletConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.plugin.ConfigurationReader;
import pt.ist.fenixWebFramework.renderers.plugin.RenderersRequestProcessorImpl;
import pt.ist.fenixWebFramework.renderers.taglib.EditObjectTag;
import pt.ist.fenixWebFramework.renderers.utils.ModuleResolver;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.utils.ResourceBundleMessageSource;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.core.Project;

@WebServlet(urlPatterns={"*.do"}, name="ActionServlet", loadOnStartup=1)
public class ActionServletWrapper
extends ActionServlet {
    static final String URL_PATTERN = "*.do";
    static final String SERVLET_NAME = "ActionServlet";
    private static final long serialVersionUID = -6838259271932491702L;
    private static final Logger logger = LoggerFactory.getLogger(ActionServletWrapper.class);
    private final Map<String, MessageResourcesConfig> resourcesConfigurations = new HashMap<String, MessageResourcesConfig>();
    private final Collection<ExceptionConfig> exceptionConfigs = new ArrayList<ExceptionConfig>();
    private final Map<String, String> parameterMap = new HashMap<String, String>();

    public void init(ServletConfig config) throws ServletException {
        ConfigurationReader.readAll((ServletContext)config.getServletContext());
        RenderKit.getInstance();
        EditObjectTag.registerFormTagType(FormTag.class);
        this.initializeResolvers();
        this.initializeParameterMapDefaults();
        this.initializeConfigurations();
        super.init((ServletConfig)new ServletConfigWrapper(config));
    }

    private void initializeResolvers() {
        RenderUtils.setModuleResolver((ModuleResolver)new ModuleResolver(){

            public String maybeResolveModule(HttpServletRequest request) {
                ModuleConfig config = ModuleUtils.getInstance().getModuleConfig(request, request.getServletContext());
                return config == null ? null : config.getPrefix();
            }

            public String maybeResolveActionMapping(String mapping, PageContext pageCtx) {
                if (mapping == null) {
                    ActionMapping actionMapping = (ActionMapping)pageCtx.findAttribute("org.apache.struts.action.mapping.instance");
                    mapping = actionMapping == null ? null : actionMapping.getPath();
                }
                return TagUtils.getInstance().getActionMappingURL(mapping, pageCtx);
            }
        });
        RenderUtils.setBundleResolver(bundle -> {
            HttpServletRequest request = RenderersRequestProcessorImpl.getCurrentRequest();
            ServletContext context = request.getServletContext();
            MessageResources resources = null;
            if (bundle == null) {
                bundle = "org.apache.struts.action.MESSAGE";
            }
            if (resources == null) {
                resources = (MessageResources)request.getAttribute(bundle);
            }
            if (resources == null) {
                ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(request, context);
                resources = (MessageResources)context.getAttribute(bundle + moduleConfig.getPrefix());
            }
            if (resources == null) {
                resources = (MessageResources)context.getAttribute(bundle);
            }
            if (resources == null) {
                return new ResourceBundleMessageSource(bundle);
            }
            MessageResources res = resources;
            return (locale, key) -> res.isPresent(locale, key) ? Optional.of(res.getMessage(locale, key)) : Optional.empty();
        });
    }

    protected void initServlet() {
        this.servletName = SERVLET_NAME;
        this.servletMapping = URL_PATTERN;
        this.getServletContext().setAttribute("org.apache.struts.action.SERVLET_MAPPING", (Object)this.servletMapping);
    }

    private void initializeParameterMapDefaults() {
        this.parameterMap.put("config", "/WEB-INF/conf/struts-default.xml");
        this.parameterMap.put("debug", "3");
        this.parameterMap.put("detail", "3");
        this.parameterMap.put("validating", "true");
    }

    private void initializeConfigurations() throws ServletException {
        Gson gson = new Gson();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (Project artifact : FenixFramework.getProject().getProjects()) {
                String resource = this.capitalizeArtifactId(artifact.getName()) + "Resources";
                this.createMessageResourcesConfig(this.getMessageResourceBundleKey(resource), this.getMessageResourceBundleParameter(resource));
                InputStream stream = loader.getResourceAsStream(artifact.getName() + "/renderers.json");
                try {
                    if (stream == null) continue;
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        ActionServletConfiguration configuration = (ActionServletConfiguration)gson.fromJson((Reader)reader, ActionServletConfiguration.class);
                        this.initializeResourceConfigurations(configuration.resources);
                        this.initializeModuleConfigurations(configuration.modules);
                        this.initializeExceptionHandlerConfigurations(configuration.exceptionHandlers);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void initializeResourceConfigurations(ActionServletConfiguration.ResourceConfig resources) {
        if (resources != null) {
            for (String resource : resources.bundles) {
                this.createMessageResourcesConfig(this.getMessageResourceBundleKey(resource), this.getMessageResourceBundleParameter(resource));
            }
            if (resources.defaultBundle != null) {
                this.createMessageResourcesConfig("org.apache.struts.action.MESSAGE", this.getMessageResourceBundleParameter(resources.defaultBundle));
            }
        }
    }

    private void initializeModuleConfigurations(Collection<ActionServletConfiguration.ModuleConfiguration> modules) {
        if (modules != null) {
            for (ActionServletConfiguration.ModuleConfiguration module : modules) {
                this.parameterMap.put("config/" + module.name, "/WEB-INF/conf/" + module.configFile);
            }
        }
    }

    private void initializeExceptionHandlerConfigurations(Collection<ActionServletConfiguration.ExceptionHandler> exceptionHandlers) {
        if (exceptionHandlers != null) {
            for (ActionServletConfiguration.ExceptionHandler handler : exceptionHandlers) {
                for (ActionServletConfiguration.ExceptionHandlerMapping mapping : handler.mappings) {
                    ExceptionConfig config = new ExceptionConfig();
                    config.setHandler(handler.handler);
                    config.setKey(mapping.key);
                    config.setType(mapping.type);
                    logger.debug("Adding exception config {}", (Object)config);
                    this.exceptionConfigs.add(config);
                }
            }
        }
    }

    protected ModuleConfig initModuleConfig(String prefix, String paths) throws ServletException {
        logger.info("Initializing Struts Module '{}'", (Object)prefix);
        ModuleConfig moduleConfig = super.initModuleConfig(prefix, paths);
        for (MessageResourcesConfig messageResourcesConfig : this.resourcesConfigurations.values()) {
            if (moduleConfig.findMessageResourcesConfig(messageResourcesConfig.getKey()) != null) continue;
            moduleConfig.addMessageResourcesConfig(messageResourcesConfig);
        }
        for (ExceptionConfig exceptionConfig : this.exceptionConfigs) {
            moduleConfig.addExceptionConfig(exceptionConfig);
        }
        return moduleConfig;
    }

    private void createMessageResourcesConfig(String key, String parameter) {
        if (this.bundleExists(parameter)) {
            logger.debug("Adding Message Resource Config with key: {}, parameter: {}", (Object)key, (Object)parameter);
            MessageResourcesConfig messageResourcesConfig = new MessageResourcesConfig();
            messageResourcesConfig.setFactory("org.apache.struts.util.PropertyMessageResourcesFactory");
            messageResourcesConfig.setKey(key);
            messageResourcesConfig.setNull(false);
            messageResourcesConfig.setParameter(parameter);
            this.resourcesConfigurations.put(key, messageResourcesConfig);
        }
    }

    private boolean bundleExists(String parameter) {
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            try {
                return ResourceBundle.getBundle(parameter, locale) != null;
            }
            catch (NullPointerException | MissingResourceException runtimeException) {
            }
        }
        return false;
    }

    private String capitalizeArtifactId(String name) {
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        for (String string : name.split("-")) {
            parts.add((CallSite)((Object)(string.substring(0, 1).toUpperCase() + string.substring(1))));
        }
        return Joiner.on((String)"").join(parts);
    }

    private String getMessageResourceBundleKey(String resource) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < resource.length(); ++i) {
            char c = resource.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                stringBuilder.append('_');
            }
            stringBuilder.append(Character.toUpperCase(c));
        }
        return stringBuilder.toString();
    }

    private String getMessageResourceBundleParameter(String resource) {
        return "resources." + resource;
    }

    private class ServletConfigWrapper
    implements ServletConfig {
        private final ServletConfig servletConfig;

        public ServletConfigWrapper(ServletConfig servletConfig) {
            this.servletConfig = servletConfig;
        }

        public String getInitParameter(String name) {
            String parameter = ActionServletWrapper.this.parameterMap.get(name);
            return parameter == null ? (this.servletConfig == null ? null : this.servletConfig.getInitParameter(name)) : parameter;
        }

        public Enumeration getInitParameterNames() {
            return new Enumeration(){
                private final Enumeration enumeration;
                private final Iterator iterator;
                {
                    this.enumeration = ServletConfigWrapper.this.servletConfig == null ? null : ServletConfigWrapper.this.servletConfig.getInitParameterNames();
                    this.iterator = ActionServletWrapper.this.parameterMap.keySet().iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.iterator.hasNext() || this.enumeration != null && this.enumeration.hasMoreElements();
                }

                public Object nextElement() {
                    return this.enumeration != null && this.enumeration.hasMoreElements() ? this.enumeration.nextElement() : this.iterator.next();
                }
            };
        }

        public ServletContext getServletContext() {
            return this.servletConfig == null ? null : this.servletConfig.getServletContext();
        }

        public String getServletName() {
            return this.servletConfig == null ? null : this.servletConfig.getServletName();
        }
    }
}

