/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.struts;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.RequestProcessor;
import org.fenixedu.bennu.struts.base.ExceptionHandler;
import org.fenixedu.bennu.struts.portal.StrutsPortalBackend;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixWebFramework.RenderersConfigurationManager;
import pt.ist.fenixWebFramework.renderers.components.state.ComponentLifeCycle;
import pt.ist.fenixWebFramework.renderers.components.state.EditRequest;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.LifeCycleConstants;
import pt.ist.fenixWebFramework.renderers.components.state.ViewDestination;
import pt.ist.fenixWebFramework.renderers.plugin.RenderersRequestProcessorImpl;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class SimpleRenderersRequestProcessor
extends RequestProcessor {
    private static final String PROCESSED_PARAM_NAME = SimpleRenderersRequestProcessor.class.getName() + ".PROCESSED";

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RenderersRequestProcessorImpl.currentRequest.set(request);
        try {
            super.process(request, response);
        }
        finally {
            RenderersRequestProcessorImpl.currentRequest.set(null);
        }
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException {
        Action action = super.processActionCreate(request, response, mapping);
        return action == null ? new Action() : action;
    }

    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        if (!StrutsPortalBackend.chooseSelectedFunctionality(request, action.getClass())) {
            return new ActionForward("unauthorized", "/bennu-renderers/unauthorized.jsp", false, "");
        }
        if (request.getParameter("org.apache.struts.taglib.html.CANCEL") != null) {
            request.setAttribute("pt.ist.fenixWebFramework.renderers.CANCEL", (Object)Boolean.TRUE);
        }
        SimpleRenderersRequestProcessor.updateLocaleForStruts(request);
        if (SimpleRenderersRequestProcessor.hasViewState(request)) {
            try {
                SimpleRenderersRequestProcessor.setViewStateProcessed(request);
                ViewDestination forward = ComponentLifeCycle.execute((HttpServletRequest)request);
                if (forward != null) {
                    return this.forwardForDestination(forward);
                }
                return super.processActionPerform(request, response, action, form, mapping);
            }
            catch (EditRequest.ViewStateUserChangedException e) {
                response.sendRedirect(RenderersConfigurationManager.getConfiguration().tamperingRedirect());
                return null;
            }
            catch (Exception e) {
                if (action instanceof ExceptionHandler) {
                    ActionForward forward;
                    ExceptionHandler handler = (ExceptionHandler)action;
                    ActionForward input = null;
                    IViewState viewState = RenderUtils.getViewState();
                    if (viewState != null) {
                        ViewDestination destination = viewState.getInputDestination();
                        input = this.forwardForDestination(destination);
                    }
                    if ((forward = handler.processException(request, mapping, input, e)) != null) {
                        return forward;
                    }
                }
                throw new ServletException((Throwable)e);
            }
        }
        return super.processActionPerform(request, response, action, form, mapping);
    }

    private ActionForward forwardForDestination(ViewDestination destination) {
        if (destination == null) {
            return null;
        }
        ActionForward forward = new ActionForward();
        forward.setModule(destination.getModule());
        forward.setPath(destination.getPath());
        forward.setRedirect(destination.getRedirect());
        return forward;
    }

    private static boolean hasViewState(HttpServletRequest request) {
        return SimpleRenderersRequestProcessor.viewStateNotProcessed(request) && request.getParameterValues(LifeCycleConstants.VIEWSTATE_PARAM_NAME) != null;
    }

    private static boolean viewStateNotProcessed(HttpServletRequest request) {
        return request.getAttribute(PROCESSED_PARAM_NAME) == null;
    }

    private static void setViewStateProcessed(HttpServletRequest request) {
        request.setAttribute(PROCESSED_PARAM_NAME, (Object)Boolean.TRUE);
    }

    private static void updateLocaleForStruts(HttpServletRequest request) {
        Locale locale = I18N.getLocale();
        HttpSession session = request.getSession(false);
        if (session != null && !Objects.equals(session.getAttribute("org.apache.struts.action.LOCALE"), locale)) {
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
        }
        request.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        super.processPopulate(request, response, form, mapping);
        if (form != null && request.getParameter("pt.ist.fenixWebFramework.renderers.CANCEL") != null) {
            request.setAttribute("org.apache.struts.action.CANCEL", (Object)Boolean.TRUE);
        }
    }
}

