/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.struts.base;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jvstm.cps.ConsistencyException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public abstract class BaseAction
extends DispatchAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("bennu", (Object)Bennu.getInstance());
        return super.execute(mapping, form, request, response);
    }

    protected <T> T getAttribute(HttpServletRequest request, String attributeName) {
        Object t = request.getAttribute(attributeName);
        return (T)(t == null ? request.getParameter(attributeName) : t);
    }

    protected <T extends DomainObject> T getDomainObject(HttpServletRequest request, String name) {
        String parameter = request.getParameter(name);
        return (T)FenixFramework.getDomainObject((String)(parameter != null ? parameter : (String)request.getAttribute(name)));
    }

    protected <T> T getRenderedObject() {
        IViewState viewState = RenderUtils.getViewState();
        return this.getRenderedObject(viewState);
    }

    protected <T> T getRenderedObject(String id) {
        IViewState viewState = RenderUtils.getViewState((String)id);
        return this.getRenderedObject(viewState);
    }

    protected <T> T getRenderedObject(IViewState viewState) {
        MetaObject metaObject;
        if (viewState != null && (metaObject = viewState.getMetaObject()) != null) {
            return (T)metaObject.getObject();
        }
        return null;
    }

    protected byte[] consumeInputStream(InputStream inputStream) throws IOException {
        return ByteStreams.toByteArray((InputStream)inputStream);
    }

    protected ActionForward download(HttpServletResponse response, String filename, byte[] bytes, String contentType) throws IOException {
        try (ServletOutputStream outputStream = response.getOutputStream();){
            response.setContentType(contentType);
            response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
            response.setContentLength(bytes.length);
            outputStream.write(bytes);
            outputStream.flush();
            ActionForward actionForward = null;
            return actionForward;
        }
    }

    protected ActionForward download(HttpServletResponse response, String filename, InputStream stream, String contentType) throws IOException {
        try {
            ActionForward actionForward;
            block9: {
                ServletOutputStream outputStream = response.getOutputStream();
                try {
                    response.setContentType(contentType);
                    response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
                    int byteCount = (int)ByteStreams.copy((InputStream)stream, (OutputStream)outputStream);
                    response.setContentLength(byteCount);
                    outputStream.flush();
                    actionForward = null;
                    if (outputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputStream.close();
            }
            return actionForward;
        }
        finally {
            stream.close();
        }
    }

    protected void addLocalizedMessage(HttpServletRequest request, String localizedMessage) {
        ActionMessages messages = this.getMessages(request);
        ActionMessage actionMessage = new ActionMessage(localizedMessage, false);
        messages.add("message", actionMessage);
        this.saveMessages(request, messages);
    }

    protected void addLocalizedSuccessMessage(HttpServletRequest request, String localizedMessage) {
        ActionMessages messages = this.getMessages(request);
        ActionMessage actionMessage = new ActionMessage(localizedMessage, false);
        messages.add("messageSuccess", actionMessage);
        this.saveMessages(request, messages);
    }

    protected void addLocalizedWarningMessage(HttpServletRequest request, String localizedMessage) {
        ActionMessages messages = this.getMessages(request);
        ActionMessage actionMessage = new ActionMessage(localizedMessage, false);
        messages.add("messageWarning", actionMessage);
        this.saveMessages(request, messages);
    }

    protected void addMessage(HttpServletRequest request, String key, String ... args) {
        this.addMessage(request, "message", key, args);
    }

    protected void addMessage(HttpServletRequest request, String property, String key, String ... args) {
        ActionMessages messages = this.getMessages(request);
        messages.add(property, new ActionMessage(key, (Object[])args));
        this.saveMessages(request, messages);
    }

    protected void setAttribute(HttpServletRequest request, String attributeName, Object attributeValue) {
        if (request != null) {
            request.setAttribute(attributeName, attributeValue);
        }
    }

    protected ActionForward redirect(HttpServletRequest request, String url) {
        String digest = GenericChecksumRewriter.calculateChecksum((String)(request.getContextPath() + url), (HttpSession)request.getSession(false));
        char seperator = url.indexOf(63) >= 0 ? (char)'&' : '?';
        String urlWithChecksum = url + seperator + "_request_checksum_=" + digest;
        return new ActionForward(urlWithChecksum, true);
    }

    protected void displayConsistencyException(ConsistencyException exc, HttpServletRequest request) {
        if (exc.getLocalizedMessage() != null) {
            this.addLocalizedMessage(request, exc.getLocalizedMessage());
        } else {
            exc.printStackTrace();
            this.addLocalizedMessage(request, BundleUtil.getString((String)"resources/MyorgResources", (String)"error.ConsistencyException", (String[])new String[0]));
        }
    }

    protected ActionForward forward(String path) {
        return new ActionForward(path);
    }
}

