/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.struts.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.servlet.CommonsFile;
import pt.ist.fenixWebFramework.servlets.commons.UploadedFile;

public class RequestWrapperFilter
implements Filter {
    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        chain.doFilter((ServletRequest)RequestWrapperFilter.getFenixHttpServletRequestWrapper(httpServletRequest), response);
        this.setSessionTimeout(httpServletRequest);
    }

    private void setSessionTimeout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.setMaxInactiveInterval(7200);
        }
    }

    public static FenixHttpServletRequestWrapper getFenixHttpServletRequestWrapper(HttpServletRequest httpServletRequest) {
        return new FenixHttpServletRequestWrapper(httpServletRequest);
    }

    public static class FenixHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private static final String PAGE_DEFAULT = "0";
        private static final String[] PAGE_DEFAULT_ARRAY = new String[]{"0"};
        private final Map<String, UploadedFile> itemsMap = new HashMap<String, UploadedFile>();
        private final Map<String, List<String>> parameters = new HashMap<String, List<String>>();

        public FenixHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                try {
                    this.parseRequest(request);
                }
                catch (FileUploadException e) {
                    throw new Error(e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error(e);
                }
            }
            request.setAttribute("$BENNU_RENDERERS$_ITEM_MAP", this.itemsMap);
        }

        private void parseRequest(HttpServletRequest request) throws FileUploadException, UnsupportedEncodingException {
            List fileItems = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(request);
            String characterEncoding = request.getCharacterEncoding();
            for (FileItem item : fileItems) {
                if (item.isFormField()) {
                    this.addParameter(item.getFieldName(), characterEncoding != null ? item.getString(characterEncoding) : item.getString());
                    continue;
                }
                CommonsFile uploadedFile = new CommonsFile(item);
                String uploadFileName = uploadedFile.getName();
                String decodedName = null;
                if (uploadFileName != null && uploadFileName.length() > 0) {
                    this.itemsMap.put(item.getFieldName(), uploadedFile);
                    decodedName = characterEncoding != null ? new String(uploadFileName.getBytes(), characterEncoding) : new String(uploadFileName.getBytes());
                }
                this.addParameter(item.getFieldName(), decodedName);
            }
        }

        private void addParameter(String fieldName, String value) {
            List<String> strings = this.parameters.get(fieldName);
            if (strings == null) {
                strings = new ArrayList<String>();
                String[] values = super.getParameterValues(fieldName);
                if (values != null) {
                    for (String v : values) {
                        strings.add(v);
                    }
                }
                this.parameters.put(fieldName, strings);
            }
            strings.add(value);
        }

        public Enumeration getParameterNames() {
            Vector<String> params = new Vector<String>();
            Enumeration paramEnum = super.getParameterNames();
            boolean gotPageParameter = false;
            while (paramEnum.hasMoreElements()) {
                String parameterName = (String)paramEnum.nextElement();
                if (paramEnum.equals("page")) {
                    gotPageParameter = true;
                }
                params.add(parameterName);
            }
            if (!gotPageParameter) {
                params.add("page");
            }
            for (String name : this.parameters.keySet()) {
                params.add(name);
            }
            return params.elements();
        }

        public String[] getParameterValues(String parameter) {
            if (this.parameters.containsKey(parameter)) {
                List<String> parameterList = this.parameters.get(parameter);
                return parameterList.toArray(new String[0]);
            }
            String[] parameterValues = super.getParameterValues(parameter);
            return parameterValues == null && parameter.equals("page") ? PAGE_DEFAULT_ARRAY : parameterValues;
        }

        public String getParameter(String parameter) {
            if (this.parameters.containsKey(parameter)) {
                List<String> parameterList = this.parameters.get(parameter);
                return parameterList.size() > 0 ? parameterList.get(0) : null;
            }
            String parameterValue = super.getParameter(parameter);
            return parameterValue == null && parameter.equals("page") ? PAGE_DEFAULT : parameterValue;
        }

        public Map<String, String[]> getParameterMap() {
            Hashtable<String, String[]> resultMap = new Hashtable<String, String[]>(super.getParameterMap());
            for (String parameter : this.parameters.keySet()) {
                resultMap.put(parameter, this.parameters.get(parameter).toArray(new String[0]));
            }
            return resultMap;
        }

        public boolean isUserInRole(String role) {
            return Group.parse((String)role).isMember(Authenticate.getUser());
        }

        public String getRemoteUser() {
            User user = Authenticate.getUser();
            return user == null ? super.getRemoteUser() : user.getUsername();
        }

        public Principal getUserPrincipal() {
            return Authenticate.getUser();
        }
    }
}

