/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.struts.plugin;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Input;
import org.fenixedu.bennu.struts.annotations.Mapping;

public class StrutsAnnotationsPlugIn
implements PlugIn {
    private static final String INPUT_PAGE_AND_METHOD = ".do?page=0&method=";
    private static final String INPUT_DEFAULT_PAGE_AND_METHOD = ".do?page=0&method=prepare";
    private static final List<String> UPPER_BOUND_SUPERCLASSES = Arrays.asList("DispatchAction", "Action", "Object");
    private static final Set<Class<?>> actionClasses = new HashSet();

    public void destroy() {
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        String modulePrefix = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)config.getPrefix());
        for (Class<?> actionClass : actionClasses) {
            Mapping mapping = actionClass.getAnnotation(Mapping.class);
            if (mapping == null || !modulePrefix.equals(mapping.module())) continue;
            ActionMapping actionMapping = new ActionMapping();
            actionMapping.setPath(mapping.path());
            actionMapping.setType(actionClass.getName());
            actionMapping.setScope(mapping.scope());
            actionMapping.setParameter(mapping.parameter());
            actionMapping.setValidate(mapping.validate());
            actionMapping.setCancellable(true);
            if (mapping.formBeanClass() != ActionForm.class) {
                String formName = mapping.formBeanClass().getName();
                this.createFormBeanConfigIfNecessary(config, mapping, formName);
                actionMapping.setName(formName);
            } else if (!mapping.formBean().isEmpty()) {
                actionMapping.setName(mapping.formBean());
            }
            if (mapping.input().isEmpty()) {
                actionMapping.setInput(this.findInputMethod(actionClass, mapping));
            } else {
                actionMapping.setInput(mapping.input());
            }
            for (Forward forward : (Forward[])actionClass.getAnnotationsByType(Forward.class)) {
                StrutsAnnotationsPlugIn.registerForward(actionMapping, forward);
            }
            StrutsAnnotationsPlugIn.registerSuperclassForwards(actionMapping, actionClass.getSuperclass());
            StrutsAnnotationsPlugIn.registerExceptionHandling(actionMapping, actionClass);
            config.addActionConfig((ActionConfig)actionMapping);
        }
    }

    private static void registerExceptionHandling(ActionMapping actionMapping, Class<?> actionClass) {
        for (ExceptionHandling exception : (ExceptionHandling[])actionClass.getAnnotationsByType(ExceptionHandling.class)) {
            ExceptionConfig exceptionConfig = new ExceptionConfig();
            Class<? extends Exception> exClass = exception.type();
            Class<? extends ExceptionHandler> handlerClass = exception.handler();
            exceptionConfig.setKey(Strings.emptyToNull((String)exception.key()));
            exceptionConfig.setHandler(handlerClass.getName());
            exceptionConfig.setType(exClass.getName());
            if (!Strings.isNullOrEmpty((String)exception.path())) {
                exceptionConfig.setPath(exception.path());
            }
            if (!Strings.isNullOrEmpty((String)exception.scope())) {
                exceptionConfig.setScope(exception.scope());
            }
            actionMapping.addExceptionConfig(exceptionConfig);
        }
    }

    private static void registerSuperclassForwards(ActionMapping actionMapping, Class<?> superclass) {
        if (UPPER_BOUND_SUPERCLASSES.contains(superclass.getSimpleName())) {
            return;
        }
        for (Forward forward : (Forward[])superclass.getAnnotationsByType(Forward.class)) {
            try {
                actionMapping.findForward(forward.name());
            }
            catch (NullPointerException ex) {
                StrutsAnnotationsPlugIn.registerForward(actionMapping, forward);
            }
        }
        StrutsAnnotationsPlugIn.registerSuperclassForwards(actionMapping, superclass.getSuperclass());
    }

    private static void registerForward(ActionMapping actionMapping, Forward forward) {
        actionMapping.addForwardConfig((ForwardConfig)new ActionForward(forward.name(), forward.path(), forward.redirect(), forward.contextRelative()));
    }

    private void createFormBeanConfigIfNecessary(ModuleConfig config, Mapping mapping, String formName) {
        FormBeanConfig formBeanConfig = config.findFormBeanConfig(formName);
        if (formBeanConfig == null) {
            formBeanConfig = new FormBeanConfig();
            formBeanConfig.setType(mapping.formBeanClass().getName());
            formBeanConfig.setName(formName);
            config.addFormBeanConfig(formBeanConfig);
        }
    }

    private String findInputMethod(Class<?> actionClass, Mapping mapping) {
        for (Method method : actionClass.getMethods()) {
            Input input = method.getAnnotation(Input.class);
            if (input == null) continue;
            return mapping.path() + INPUT_PAGE_AND_METHOD + method.getName();
        }
        return mapping.path() + INPUT_DEFAULT_PAGE_AND_METHOD;
    }

    public static void registerMapping(Class<?> type) {
        actionClasses.add(type);
    }
}

